# Based loosely on Fedora FC-6 2.5-10 glibc.spec

%bcond_with initscripts

Summary: The GNU libc libraries.
Name: glibc
Version: 2.5
Release: 1_WR%{?_wr_rel}
License: LGPL
Group: System Environment/Libraries
Buildroot: %{_tmppath}/%{name}-%{version}-root

Provides: ldconfig
# The dynamic linker supports DT_GNU_HASH
# Does the WR version really support this?
#Provides: rtld(GNU_HASH)
Requires: glibc-common = %{version}-%{release}
# Require libgcc in case some program calls pthread_cancel in its %%post
#Prereq: basesystem, libgcc
Prereq: libgcc
# This is for building auxiliary programs like memusage, nscd
# For initial glibc bootstraps it can be commented out

%description
The glibc package contains standard libraries which are used by
multiple programs on the system. In order to save disk space and
memory, as well as to make upgrading easier, common system code is
kept in one place and shared between programs. This particular package
contains the most important sets of shared libraries: the standard C
library and the standard math library. Without these two libraries, a
Linux system will not function.

%package devel
Summary: Object files for development using standard C libraries.
Group: Development/Libraries
#Prereq: /sbin/install-info
Prereq: %{name}-headers
Requires: %{name}-headers = %{version}-%{release}, %{name} = %{version}-%{release}

%description devel
The glibc-devel package contains the object files necessary
for developing programs which use the standard C libraries (which are
used by nearly all programs).  If you are developing programs which
will use the standard C libraries, your system needs to have these
standard object files available in order to create the
executables.

Install glibc-devel if you are going to develop programs which will
use the standard C libraries.

%package headers
Summary: Header files for development using standard C libraries.
Group: Development/Libraries
Provides: %{name}-headers(%{_target_cpu})
Prereq: kernel-headers

%description headers
The glibc-headers package contains the header files necessary
for developing programs which use the standard C libraries (which are
used by nearly all programs).  If you are developing programs which
will use the standard C libraries, your system needs to have these
standard header files available in order to create the
executables.

Install glibc-headers if you are going to develop programs which will
use the standard C libraries.

%package common
Summary: Common binaries and locale data for glibc
Conflicts: %{name} < %{version}
Conflicts: %{name} > %{version}
#Requires: timezone >= 2003a
Group: System Environment/Base

%description common
The glibc-common package includes common binaries for the GNU libc
libraries, as well as national language (locale) support.

%package -n nscd
Summary: A Name Service Caching Daemon (nscd).
Group: System Environment/Daemons
#Prereq: /sbin/chkconfig, /usr/sbin/useradd, /usr/sbin/userdel, sh-utils
%if %{with initscripts}
Requires: initscripts
%endif

%description -n nscd
Nscd caches name service lookups and can dramatically improve
performance with NIS+, and may help with DNS as well.

%package utils
Summary: Development utilities from GNU C library
Group: Development/Tools
Requires: glibc = %{version}-%{release}

%description utils
The glibc-utils package contains memusage, a memory usage profiler,
mtrace, a memory leak tracer and xtrace, a function call tracer
which can be helpful during program debugging.

If unsure if you need this, don't install this package.

%prep

%build

%install
# The RPM_BUILD_ROOT should already be populated!
# Remove any existing file lists
rm -f rpm.filelist.in \
 rpm.filelist \
 devel.filelist \
 headers.filelist \
 rpm.filelist.full \
 common.filelist \
 nscd.filelist \
 utils.filelist

# ... Fedora install follows ...

if [ -d $RPM_BUILD_ROOT%{_prefix}/info -a "%{_infodir}" != "%{_prefix}/info" ]; then
    mkdir -p $RPM_BUILD_ROOT%{_infodir}
    mv -f $RPM_BUILD_ROOT%{_prefix}/info/* $RPM_BUILD_ROOT%{_infodir}
    rm -rf $RPM_BUILD_ROOT%{_prefix}/info
fi

gzip -9nvf $RPM_BUILD_ROOT%{_infodir}/libc*

ln -sf libbsd-compat.a $RPM_BUILD_ROOT%{_prefix}/%{_lib}/libbsd.a

mkdir -p $RPM_BUILD_ROOT/etc/default
install -p -m 644 nis/nss $RPM_BUILD_ROOT/etc/default/nss

# Take care of setuids
# -- new security review sez that this shouldn't be needed anymore
#chmod 755 $RPM_BUILD_ROOT%{_prefix}/libexec/pt_chown

# This is for ncsd - in glibc 2.2
install -m 644 nscd/nscd.conf $RPM_BUILD_ROOT/etc
%if %{with initscripts}
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
install -m 755 nscd/nscd.init $RPM_BUILD_ROOT/etc/rc.d/init.d/nscd
%endif

# Don't include ld.so.cache
rm -f $RPM_BUILD_ROOT/etc/ld.so.cache

# Include ld.so.conf
echo 'include ld.so.conf.d/*.conf' > $RPM_BUILD_ROOT/etc/ld.so.conf
touch $RPM_BUILD_ROOT/etc/ld.so.cache
chmod 644 $RPM_BUILD_ROOT/etc/ld.so.conf
mkdir -p $RPM_BUILD_ROOT/etc/ld.so.conf.d
mkdir -p $RPM_BUILD_ROOT/etc/sysconfig
touch $RPM_BUILD_ROOT/etc/sysconfig/nscd

# Include %{_prefix}/%{_lib}/gconv/gconv-modules.cache
> $RPM_BUILD_ROOT%{_prefix}/%{_lib}/gconv/gconv-modules.cache
chmod 644 $RPM_BUILD_ROOT%{_prefix}/%{_lib}/gconv/gconv-modules.cache

# Install the upgrade program
#install -m 700 build-%{nptl_target_cpu}-linuxnptl/glibc_post_upgrade.%{_target_cpu} \
#  $RPM_BUILD_ROOT/usr/sbin/glibc_post_upgrade.%{_target_cpu}

# rquota.x and rquota.h are now provided by quota
rm -f $RPM_BUILD_ROOT%{_prefix}/include/rpcsvc/rquota.[hx]

# Hardlink identical locale files together
#gcc -O2 -o build-%{nptl_target_cpu}-linuxnptl/hardlink fedora/hardlink.c
#build-%{nptl_target_cpu}-linuxnptl/hardlink -vc $RPM_BUILD_ROOT%{_prefix}/lib/locale

# Ugly hack for buggy rpm (RPM isn't buggy..)
ln -f ${RPM_BUILD_ROOT}%{_sbindir}/iconvconfig{,.%{_target_cpu}}

# BUILD THE FILE LIST
find $RPM_BUILD_ROOT -type f -or -type l |
	sed -e 's|.*/etc|%config &|' \
	    -e 's|.*/gconv/gconv-modules$|%verify(not md5 size mtime) %config(noreplace) &|' \
	    -e 's|.*/gconv/gconv-modules.cache|%verify(not md5 size mtime) &|' \
	    -e '/lib\/debug/d' > rpm.filelist.in
for n in %{_prefix}/share %{_prefix}/include %{_prefix}/lib/locale; do
    find ${RPM_BUILD_ROOT}${n} -type d | \
	grep -v '%{_prefix}/share$' | \
	grep -v '%{_infodir}' | \
	sed "s/^/%dir /" >> rpm.filelist.in
done

# primary filelist
SHARE_LANG='s|.*/share/locale/\([^/_]\+\).*/LC_MESSAGES/.*\.mo|%lang(\1) &|'
LIB_LANG='s|.*/lib/locale/\([^/_]\+\)|%lang(\1) &|'
# rpm does not handle %lang() tagged files hardlinked together accross
# languages very well, temporarily disable
# LIB_LANG=''
sed -e "s|$RPM_BUILD_ROOT||" -e "$LIB_LANG" -e "$SHARE_LANG" < rpm.filelist.in |
	grep -v '/etc/\(localtime\|nsswitch.conf\|ld.so.conf\|ld.so.cache\|default\)'  | \
	grep -v '/%{_lib}/lib\(pcprofile\|memusage\).so' | \
	grep -v 'bin/\(memusage\|mtrace\|xtrace\|pcprofiledump\)' | \
	sort > rpm.filelist

mkdir -p $RPM_BUILD_ROOT%{_prefix}/%{_lib}
mv -f $RPM_BUILD_ROOT/%{_lib}/lib{pcprofile,memusage}.so $RPM_BUILD_ROOT%{_prefix}/%{_lib}
# For some reason memusage isn't available to us!
#for i in $RPM_BUILD_ROOT%{_prefix}/bin/{xtrace,memusage}; do
for i in $RPM_BUILD_ROOT%{_prefix}/bin/xtrace; do
  cp -a $i $i.tmp
  sed -e 's~=/%{_lib}/libpcprofile.so~=%{_prefix}/%{_lib}/libpcprofile.so~' \
      -e 's~=/%{_lib}/libmemusage.so~=%{_prefix}/%{_lib}/libmemusage.so~' \
      -e 's~='\''/\\\$LIB/libpcprofile.so~='\''%{_prefix}/\\$LIB/libpcprofile.so~' \
      -e 's~='\''/\\\$LIB/libmemusage.so~='\''%{_prefix}/\\$LIB/libmemusage.so~' \
    $i.tmp > $i
  chmod 755 $i; rm -f $i.tmp
done

grep '%{_infodir}' < rpm.filelist | grep -v '%{_infodir}/dir' > devel.filelist
grep '%{_prefix}/include/gnu/stubs-[32164]\+\.h' < rpm.filelist >> devel.filelist || :

grep '%{_prefix}/include' < rpm.filelist |
	egrep -v '%{_prefix}/include/(linuxthreads|gnu/stubs-[32164]+\.h)' \
		> headers.filelist

mv rpm.filelist rpm.filelist.full
grep -v '%{_prefix}/%{_lib}/lib.*_p\.a' < rpm.filelist.full |
	egrep -v "(%{_prefix}/include)|(%{_infodir})" > rpm.filelist

# This may fail, it's expected
grep '%{_prefix}/%{_lib}/lib.*_p\.a' < rpm.filelist.full >> devel.filelist || :
grep '%{_prefix}/%{_lib}/lib.*\.a' < rpm.filelist >> devel.filelist
grep '%{_prefix}/%{_lib}/.*\.o' < rpm.filelist >> devel.filelist
grep '%{_prefix}/%{_lib}/lib.*\.so' < rpm.filelist >> devel.filelist

mv rpm.filelist rpm.filelist.full
grep -v '%{_prefix}/%{_lib}/lib.*\.a' < rpm.filelist.full |
	grep -v '%{_prefix}/%{_lib}/.*\.o' |
	grep -v '%{_prefix}/%{_lib}/lib.*\.so'|
	grep -v '%{_prefix}/%{_lib}/linuxthreads' |
	grep -v 'nscd' > rpm.filelist

grep '%{_prefix}/bin' < rpm.filelist >> common.filelist
grep '%{_prefix}/lib/locale' < rpm.filelist >> common.filelist
#grep '%{_prefix}/libexec/pt_chown' < rpm.filelist >> common.filelist
grep '%{_prefix}/sbin/[^gi]' < rpm.filelist >> common.filelist
grep '%{_prefix}/share' < rpm.filelist \
  | grep -v '%{_prefix}/share/zoneinfo' >> common.filelist

mv rpm.filelist rpm.filelist.full
grep -v '%{_prefix}/bin' < rpm.filelist.full |
	grep -v '%{_prefix}/lib/locale' |
	grep -v '%{_prefix}/libexec/pt_chown' |
	grep -v '%{_prefix}/sbin/[^gi]' |
	grep -v '%{_prefix}/share' > rpm.filelist

#echo '%{_prefix}/sbin/build-locale-archive' >> common.filelist
#echo '%{_prefix}/sbin/tzdata-update' >> common.filelist
echo '%{_prefix}/sbin/nscd' > nscd.filelist

cat > utils.filelist <<EOF
%{_prefix}/%{_lib}/libmemusage.so
%{_prefix}/%{_lib}/libpcprofile.so
#%{_prefix}/bin/memusage
#%{_prefix}/bin/memusagestat
%{_prefix}/bin/mtrace
%{_prefix}/bin/pcprofiledump
%{_prefix}/bin/xtrace
EOF

# /etc/localtime
#rm -f $RPM_BUILD_ROOT/etc/localtime
#cp -f $RPM_BUILD_ROOT%{_prefix}/share/zoneinfo/US/Eastern $RPM_BUILD_ROOT/etc/localtime

rm -rf $RPM_BUILD_ROOT%{_prefix}/share/zoneinfo

# Make sure %config files have the same timestamp
touch -r SPECS/glibc.spec $RPM_BUILD_ROOT/etc/ld.so.conf
touch -r timezone/northamerica $RPM_BUILD_ROOT/etc/localtime
touch -r sunrpc/etc.rpc $RPM_BUILD_ROOT/etc/rpc

#cd fedora
#$GCC -Os -static -o build-locale-archive build-locale-archive.c \
#  ../build-%{nptl_target_cpu}-linuxnptl/locale/locarchive.o \
#  ../build-%{nptl_target_cpu}-linuxnptl/locale/md5.o \
#  -DDATADIR=\"%{_datadir}\" -DPREFIX=\"%{_prefix}\" \
#  -L../build-%{nptl_target_cpu}-linuxnptl
#install -m 700 build-locale-archive $RPM_BUILD_ROOT/usr/sbin/build-locale-archive
#$GCC -Os -static -o tzdata-update tzdata-update.c \
#  -L../build-%{nptl_target_cpu}-linuxnptl
#install -m 700 tzdata-update $RPM_BUILD_ROOT/usr/sbin/tzdata-update
#cd ..

# the last bit: more documentation
rm -rf documentation
mkdir documentation
cp crypt/README.ufc-crypt documentation/README.ufc-crypt
cp timezone/README documentation/README.timezone
cp ChangeLog{,.15,.16} documentation
mkdir documentation/ports
for each in ports/ChangeLog* ports/README ; do
  cp $each documentation/ports.`basename $each`
done
bzip2 -9 documentation/ChangeLog*
bzip2 -9 documentation/ports.ChangeLog*
cp posix/gai.conf documentation/

mkdir -p $RPM_BUILD_ROOT/var/{db,run}/nscd
touch $RPM_BUILD_ROOT/var/{db,run}/nscd/{passwd,group,hosts}
touch $RPM_BUILD_ROOT/var/run/nscd/{socket,nscd.pid}

#%%post -p /usr/sbin/glibc_post_upgrade.%{_target_cpu}

#%%postun -p /sbin/ldconfig

#%%post common -p /usr/sbin/build-locale-archive

#%%triggerin common -p /usr/sbin/tzdata-update -- tzdata

#%%post devel
#/sbin/install-info %{_infodir}/libc.info.gz %{_infodir}/dir

#%%pre headers
# this used to be a link and it is causing nightmares now
#if [ -L %{_prefix}/include/scsi ] ; then
#    rm -f %{_prefix}/include/scsi
#fi

#%%preun devel
#if [ "$1" = 0 ]; then
#    /sbin/install-info --delete %{_infodir}/libc.info.gz %{_infodir}/dir
#fi

#%%post utils -p /sbin/ldconfig

#%%postun utils -p /sbin/ldconfig

#%%postun -n nscd
#if [ $1 = 0 ] ; then
#    /usr/sbin/userdel nscd > /dev/null 2>&1 || :
#fi
#if [ "$1" -ge "1" ]; then
#    service nscd condrestart > /dev/null 2>&1 || :
#fi

%pre -n nscd -p <lua>
wrs.useradd('-M -o -r -d / -s /sbin/nologin -c "NSCD Daemon" -u 28 nscd')

%if %{with initscripts}
%post -n nscd -p <lua>
wrs.chkconfig('--add nscd')
%endif

%if %{with initscripts}
%preun -n nscd -p <lua>
if (tonumber(arg[2]) == 0) then
  wrs.chkconfig('--del nscd')
end
%endif

%clean
rm -f *.filelist*

%files -f rpm.filelist
%defattr(-,root,root)
%attr(0644,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /etc/localtime
%verify(not md5 size mtime) %config(noreplace) /etc/nsswitch.conf
%verify(not md5 size mtime) %config(noreplace) /etc/ld.so.conf
%dir /etc/ld.so.conf.d
%dir %{_prefix}/libexec/getconf
%dir %{_prefix}/%{_lib}/gconv
%attr(0644,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /etc/ld.so.cache
%doc README NEWS INSTALL FAQ BUGS NOTES PROJECTS CONFORMANCE
%doc COPYING COPYING.LIB README.libm LICENSES
%doc hesiod/README.hesiod

%files -f common.filelist common
%defattr(-,root,root)
#%%attr(0644,root,root) %%verify(not md5 size mtime mode) %%ghost %%config(missingok,noreplace) %{_prefix}/lib/locale/locale-archive
%dir %attr(755,root,root) /etc/default
%verify(not md5 size mtime) %config(noreplace) /etc/default/nss
%doc documentation/*

%files -f devel.filelist devel
%defattr(-,root,root)

%files -f headers.filelist headers
%defattr(-,root,root)

%files -f utils.filelist utils
%defattr(-,root,root)

%files -f nscd.filelist -n nscd
%defattr(-,root,root)
%config(noreplace) /etc/nscd.conf
%if %{with initscripts}
%config /etc/rc.d/init.d/nscd
%endif
%dir %attr(0755,root,root) /var/run/nscd
%dir %attr(0755,root,root) /var/db/nscd
%attr(0644,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/run/nscd/nscd.pid
%attr(0666,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/run/nscd/socket
%attr(0600,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/run/nscd/passwd
%attr(0600,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/run/nscd/group
%attr(0600,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/run/nscd/hosts
%attr(0600,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/db/nscd/passwd
%attr(0600,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/db/nscd/group
%attr(0600,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/db/nscd/hosts
%ghost %config(missingok,noreplace) /etc/sysconfig/nscd

%changelog
* Tue Jan 16 2007 Mark Hatle <mark.hatle@windriver.com> 2.5-1
- Initial version...
- based on Fedora Core 6 glibc 2.5-10.fc6 version.
