Summary: remote shell tools
Name: hhl-target-netkit-rsh
Version: 0.17
Release: %{_hhl_build_id}.3
Source: netkit-rsh_%{version}.orig.tar.gz
Source1: netkit-rsh-client.tmpl
Source2: netkit-rsh-server.tmpl
Source3: netkit-rsh-doc.tmpl
Patch0: netkit-rsh_%{version}-5.diff.gz
Patch1: netkit-rsh_0.17-5-cross.diff
Patch2: netkit-rsh-0.16.1-makefile.patch
License: BSD
Group: net
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
%define _docdir	%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}

%description
Clients and servers for the remote shell (rsh) protocol

%package -n hhl-%{_hhl_target_arch}-netkit-rsh-client
Summary: rsh clients
Group: net
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-netkit-rsh-client
This package contains rsh, rcp and rlogin.

%package -n hhl-%{_hhl_target_arch}-netkit-rsh-server
Summary: rsh servers
Group: net
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-netkit-rsh-server
This package contains rexecd, rlogind and rshd.

%package -n hhl-%{_hhl_target_arch}-netkit-rsh-doc
Summary: rsh documentation
Group: net
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-netkit-rsh-doc
This package includes the documentation for the rsh family of utilities.

%prep
%target_check
%setup -q -n netkit-rsh-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%build
%target_setup
# configure script is non-autoconf
./configure --with-c-compiler=$CC --installroot=%{?buildroot:%{buildroot}}%{_hhl_cross_target_dir} --prefix=%{_hhl_target_prefix} --exec-prefix=%{_hhl_target_exec_prefix}

%make all CC="$CC -DOPEN_MAX=256"| tee -a build.log

%install
rm -rf %{buildroot}
%target_setup
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_prefix}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_exec_prefix}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_include_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/usr/man/man{1,2,3,4,5,6,7,8}
make install | tee -a build.log
for ANum in 1 2 3 4 5 6 7 8; do
	mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man${ANum}
	for AFile in %{buildroot}%{_hhl_cross_target_dir}/usr/man/man${ANum}/*; do
		test -f $AFile && mv $AFile %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man${ANum}/
	done
done
for AFile in %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man?/*.?; do
	test -f ${AFile} && rm -f ${AFile}.gz && gzip ${AFile}
done

mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/pam.d
cp debian/pam.d/* %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/pam.d
cp debian/hosts.equiv %{buildroot}%{_hhl_cross_target_dir}/%{_hhl_target_sysconf_dir}
cp debian/copyright LICENSE

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/netkit-rsh-client
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE2} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/netkit-rsh-server
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE3} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/netkit-rsh-doc

%clean
rm -rf %{buildroot}

%files -n hhl-%{_hhl_target_arch}-netkit-rsh-client
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/rcp
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/rexec
%attr(4755,root,root)%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/rlogin
%attr(4755,root,root)%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/rsh

%doc LICENSE

%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/netkit-rsh-client
# rexecd, rlogind and rshd.
%files -n hhl-%{_hhl_target_arch}-netkit-rsh-server
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/*
%config %{_hhl_cross_target_dir}/%{_hhl_target_sysconf_dir}/pam.d/*
%config %{_hhl_cross_target_dir}/%{_hhl_target_sysconf_dir}/hosts.equiv

%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/netkit-rsh-server

%files -n hhl-%{_hhl_target_arch}-netkit-rsh-doc
%defattr(-,root,root)
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man*/*
%doc BUGS ChangeLog README

%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/netkit-rsh-doc

%changelog
* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Thu Feb 22 2001 Charles Duffy <source@mvista.com>
- First cut
