Summary: Basic TCP/IP networking system
Name: hhl-target-netbase
Version: 4.06
Release: %{_hhl_build_id}.1
Source: netbase_%{version}.tar.gz
Source1: netbase.tmpl
Patch: netbase-initd.diff
License: GPL
Group: Applications/Internet
%define pkgname hhl-%{_hhl_target_arch}-netbase
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
%define targetroot %{_hhl_cross_target_dir}
Prefix: %{targetroot}

%define _bindir		%{targetroot}%{_hhl_target_bin_dir}
%define _sbindir	%{targetroot}%{_hhl_target_sbin_dir}
%define _etcdir		%{targetroot}%{_hhl_target_sysconf_dir}
%define _libdir		%{targetroot}%{_hhl_target_lib_dir}
%define _datadir	%{targetroot}%{_hhl_target_datadir}
%define _mandir		%{targetroot}%{_hhl_target_man_dir}
%define _infodir	%{targetroot}%{_hhl_target_info_dir}
%define _docdir		%{targetroot}%{_hhl_target_doc_dir}

%description
This package provides the necessary infrastructure for basic TCP/IP based
networking.

%package -n %{pkgname}
Summary: Basic TCP/IP networking system
Group: Applications/Internet
AutoReqProv: no
Requires: hhl-%{_hhl_target_arch}-hardhatutils, hhl-%{_hhl_target_arch}-initscripts

%description -n %{pkgname}
This package provides the necessary infrastructure for basic TCP/IP based
networking.

%prep
%target_check
%setup -q -n netbase-%{version}
%patch -p1

%build

echo spoofprotect=yes > debian/options
echo ip_forward=no >> debian/options
echo syncookies=no >> debian/options
echo disable_tcp_ecn=yes >> debian/options

%install
%target_setup
rm -rf %{buildroot}

for i in %{_bindir} %{_sbindir} %{_libdir}/perl5 %{_etcdir}/{network,init.d} %{_mandir}/man{5,8} ; do 
    install -d %{buildroot}/$i
done

install -m 755 debian/networking.init.d %{buildroot}%{_etcdir}/init.d/networking
install -m 644 etc-gateways %{buildroot}%{_etcdir}/gateways
install -m 644 gateways.5 %{buildroot}%{_mandir}/man5/gateways.5
install -m 644 etc-protocols %{buildroot}%{_etcdir}/protocols
install -m 644 etc-rpc %{buildroot}%{_etcdir}/rpc
install -m 644 etc-services %{buildroot}%{_etcdir}/services
#install -m 644 DebianNet.pm %{buildroot}%{_libdir}/perl5/DebianNet.pm
#install -m 644 DebianNet.3pm %{buildroot}%{_mandir}/man8/DebianNet.3pm
#install -m 755 update-inetd %{buildroot}%{_sbindir}/update-inetd
#install -m 644 update-inetd.8 %{buildroot}%{_mandir}/man8/update-inetd.8
install -m 644 resolv+.8 %{buildroot}%{_mandir}/man8/resolv+.8
install -m 644 debian/options %{buildroot}%{_etcdir}/network/

gzip -9f %{buildroot}%{_mandir}/man*/*
cp debian/copyright LICENSE

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/netbase

%clean
rm -rf %{buildroot}

%post -n %{pkgname}
%target_script_prefix_setup
# Register the service
(%{_hhl_target_toolprefix}initdconfig --add networking) &> /dev/null \
        || echo "Unable to enable initd service: networking"

# We only register services, not un-register them.

%files -n %{pkgname}
%defattr(-,root,root)
#%{_sbindir}/update-inetd
#%{_libdir}/perl5/DebianNet.pm
%{_mandir}/man*/*

%config %{_etcdir}/gateways
%config %{_etcdir}/protocols
#%config %{_etcdir}/rpc
%config %{_etcdir}/services
%config %{_etcdir}/init.d/networking

%config %dir %{_etcdir}/network
%config %{_etcdir}/network/options

%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/netbase

%changelog
* Fri Aug 24 2001 Mark Hatle <source@mvista.com
- Removed the DebianNet.pm and update-inetd modules.  They are not 
- applicable for HHL! (Also updated to 4.06)

* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files

* Wed Feb 21 2001 Matthew McLean <source@mvista.com>
- First cut
