Summary: Utilities for configuring the Linux 2.4 bridge.
Name: hhl-target-bridge-utils
Version: 0.9.3
Release: %{_hhl_build_id}.1
Source: bridge-utils_0.9.3.orig.tar.gz
Source1: bridge-utils.tmpl
Source2: bridge-utils-dev.tmpl
Patch: bridge-utils_0.9.3-1.diff.gz
Patch1: bridge-utils-makefile.diff
License: GPL
Group: net
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
%define _docdir         %{_hhl_cross_target_dir}%{_hhl_target_doc_dir}

%description
This package contains utilities for configuring the Linux ethernet
bridge. The Linux ethernet bridge can be used for connecting multiple
ethernet devices together. The connecting is fully transparent: hosts
connected to one ethernet device see hosts connected to the other
ethernet devices directly.

# Primary package
%package -n hhl-%{_hhl_target_arch}-bridge-utils
Summary: Utilities for configuring the Linux bridge.
Group: net
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-bridge-utils
This package contains utilities for configuring the Linux ethernet
bridge. The Linux ethernet bridge can be used for connecting multiple
ethernet devices together. The connecting is fully transparent: hosts
connected to one ethernet device see hosts connected to the other
ethernet devices directly.

# Development package
%package -n hhl-%{_hhl_target_arch}-bridge-utils-dev
Summary: Library for configuring the Linux bridge.
Group: dev
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-bridge-utils-dev
The bridge-utils-devel package contains the header and object files
necessary for developing programs which use 'libbridge.a', the
interface to the linux kernel ethernet bridge. If you are developing
programs which need to configure the linux ethernet bridge, your  
system needs to have these standard header and object files available
in order to create the executables.

%prep
%target_check
%setup -n bridge-utils-0.9.3.orig
%patch -p1
%patch1 -p1

%build
%target_setup
%make CC=$CC | tee -a build.log

%install
rm -rf %{buildroot}
%target_setup

mkdir -p %{buildroot}%{_hhl_cross_target_dir}/sbin
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_include_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8

install -m 755 brctl/brctl %{buildroot}%{_hhl_cross_target_dir}/sbin/
install -m 644 doc/brctl.8 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/
install -m 644 libbridge/libbridge.h %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/
install -m 644 libbridge/libbridge.a %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/

gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/*

# Now copy the debian configuration/init information

mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/network/if-pre-up.d
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/network/if-up.d
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/network/if-post-down.d

install -m 755 debian/preup %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/network/if-pre-up.d/bridge
install -m 755 debian/up %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/network/if-up.d/bridge
install -m 755 debian/postdown %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/network/if-post-down.d/bridge

cp COPYING LICENSE

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/bridge-utils
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE2} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/bridge-utils-dev

%clean
rm -rf %{buildroot}

%files -n hhl-%{_hhl_target_arch}-bridge-utils
%defattr(-,root,root)
%{_hhl_cross_target_dir}/sbin/brctl
%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/brctl.8.gz
%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/network/if-pre-up.d/bridge
%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/network/if-up.d/bridge
%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/network/if-post-down.d/bridge
%doc build.log AUTHORS LICENSE THANKS doc/FAQ doc/HOWTO debian/README.Debian
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/bridge-utils

%files -n hhl-%{_hhl_target_arch}-bridge-utils-dev
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/libbridge.h
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libbridge.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/bridge-utils-dev

%changelog
* Thu Sep 20 2001 Mark Hatle <source@mvista.com>
- First cut

