Summary: Miscellaneous system utilities.
Name: hhl-target-util-linux
Version: 2.11h
Release: %{_hhl_build_id}.3
Copyright: GPL/BSD
Group: base
Source: util-linux_%{version}.orig.tar.gz
Source1: util-linux.tmpl
Source2: util-linux-mount.tmpl
Source3: bsdutils.tmpl
Patch0: util-linux_%{version}-1.diff.gz
Patch1: util-linux-%{version}-cross.diff
Patch2: util-linux-initd.diff
# The follow patch allows /dev/console to be used on the getty w/o passing 
# in a baud rate.
Patch4: util-linux-2.11h-agetty.patch
Patch6: util-linux-2.11h-msgfmt.diff

%define pkgname		hhl-%{_hhl_target_arch}-util-linux
%define pkgmount	hhl-%{_hhl_target_arch}-mount
%define pkgbsdutils	hhl-%{_hhl_target_arch}-bsdutils
BuildRoot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
%define targetroot %{_hhl_cross_target_dir}
Prefix: %{targetroot}

%define _bindir		%{targetroot}%{_hhl_target_bin_dir}
%define _sbindir	%{targetroot}%{_hhl_target_sbin_dir}
%define _etcdir		%{targetroot}%{_hhl_target_sysconf_dir}
%define _libdir		%{targetroot}%{_hhl_target_lib_dir}
%define _datadir	%{targetroot}%{_hhl_target_sharedstate_dir}
%define _mandir		%{targetroot}%{_hhl_target_man_dir}
%define _infodir	%{targetroot}%{_hhl_target_info_dir}
%define _docdir		%{targetroot}%{_hhl_target_doc_dir}

%description
A mixed bag of system utilities: arch blockdev chkdupexe cfdisk cytune
dmesg fdisk fsck.minix getty getopt hwclock ipcrm ipcs mcookie mkfs
mkfs.minix mkswap more namei pivot_root raw setterm setsid tunelp
whereis.

%package -n %{pkgname}
Summary: Miscellaneous system utilities.
Group: base
AutoReqProv: no 

%description -n %{pkgname}
A mixed bag of system utilities: arch blockdev chkdupexe cfdisk cytune
dmesg fdisk fsck.minix getty getopt hwclock ipcrm ipcs mcookie mkfs
mkfs.minix mkswap more namei pivot_root raw setterm setsid tunelp
whereis.

%package -n %{pkgmount}
Summary: Tools for mounting and manipulating filesystems.
Group: base
AutoReqProv: no

%description -n %{pkgmount}
This package provides the mount(8), umount(8), swapon(8),
swapoff(8), and losetup(8) commands.

%package -n %{pkgbsdutils}
Summary: Basic utilities from 4.4BSD-Lite.
Group: base
AutoReqProv: no

%description -n %{pkgbsdutils}
This package contains the bare minimum number of BSD utilities needed
to boot a system.  You should probably also install bsdmainutils to get 
the remaining standard BSD utilities.

Included are: logger, renice, script, wall

%prep
%target_check
%setup -q -n util-linux-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch4 -p1
%patch6 -p1

%build
%target_setup
./configure
%make CPU=%{_hhl_target_cpu} ADD_RAW=yes HAVE_SLANG=no OPT="-pipe -O2"

%install
%target_setup
rm -rf %{buildroot}

for i in %{_bindir} %{_sbindir} %{_etcdir}/init.d %{_libdir}/mime/packages \
	%{_datadir} %{targetroot}/{bin,sbin} %{_mandir}/man{1,5,8} %{_infodir}
do
    install -d %{buildroot}$i
done

# It is too complicated to use the builtin makefile, so we install manually

# Following is the main util-linux files
# INITFILES
install -m 755 debian/hwclock.sh \
	%{buildroot}%{_etcdir}/init.d/hwclock.sh

# BINFILES
install -m 755 sys-utils/{arch,dmesg} text-utils/more \
	%{buildroot}%{targetroot}/bin/

# SBINFILES
install -m 755 disk-utils/{mkswap,blockdev} login-utils/agetty \
	hwclock/hwclock \
	%{buildroot}%{targetroot}/sbin/

# SBINFILES (2.4 kernel)
install -m 755 disk-utils/raw mount/pivot_root \
	%{buildroot}%{targetroot}/sbin/

# UBINFILES
install -m 755 sys-utils/{ipcs,ipcrm,setsid} \
	misc-utils/{namei,setterm,mcookie,whereis,ddate} \
	getopt-1.1.2/getopt text-utils/rev disk-utils/fdformat \
	%{buildroot}%{_bindir}/

# UBINFILES2
install -m 755 misc-utils/chkdupexe \
	%{buildroot}%{_bindir}/

# ULIBFILES
install -m 644 text-utils/more.help \
	%{buildroot}%{_libdir}/

# USBINFILES
install -m 755 sys-utils/readprofile disk-utils/elvtune \
	%{buildroot}%{_sbindir}/

# Following is the Mount Package files
# MOUNTBINFILES
install -m 4755 mount/mount mount/umount \
	%{buildroot}%{targetroot}/bin/

# MOUNTSBINFILES
install -m 755 mount/swapon mount/losetup \
	%{buildroot}%{targetroot}/sbin/

# Following is the bsd-utils files
# BSDUBINFILES
install -m 755 misc-utils/script misc-utils/logger sys-utils/renice \
	login-utils/wall \
	%{buildroot}%{_bindir}/

# BSDMAN1FILES
install -m 644 login-utils/wall.1 misc-utils/script.1 misc-utils/logger.1 \
	%{buildroot}%{_mandir}/man1/

# BSDMAN8FILES
install -m 644 sys-utils/renice.8 \
	%{buildroot}%{_mandir}/man8/

# BSDDOCFILES [ignored]

# MAN1FILES 
install -m 644 text-utils/{more,rev}.1 misc-utils/{namei.1,mcookie.1} \
	sys-utils/{arch,readprofile}.1 \
	misc-utils/{chkdupexe.1,setterm.1,whereis.1,ddate.1} \
	getopt-1.1.2/getopt.1 \
	%{buildroot}%{_mandir}/man1/

# MAN8FILES 
install -m 644 sys-utils/{dmesg.8,ipcrm.8,ipcs.8,setsid.8} \
	login-utils/agetty.8 \
	hwclock/hwclock.8 \
	disk-utils/{mkswap.8,blockdev.8} disk-utils/elvtune.8 \
	disk-utils/fdformat.8 \
	%{buildroot}%{_mandir}/man8/

# MAN8FILES (2.4 kernel)
install -m 644 disk-utils/raw.8 mount/pivot_root.8 \
	%{buildroot}%{_mandir}/man8/

# EXAMPLES [listed in %files section]

# INFOFILES
install -m 644 sys-utils/ipc.info \
	%{buildroot}%{_infodir}/

# DOCFILES [listed in %files section]

# MOUNTMAN5FILES
install -m 644 mount/fstab.5 mount/nfs.5 \
	%{buildroot}%{_mandir}/man5/

# MOUNTMAN8FILES
install -m 644 mount/losetup.8 mount/swapoff.8 mount/umount.8 \
	mount/mount.8 mount/swapon.8 \
	%{buildroot}%{_mandir}/man8/

# MOUNTDOCFILES [listed in %files section]

# Minix tools
# SBINFILES
install -m 755 disk-utils/{fsck.minix,mkfs,mkfs.minix} \
	%{buildroot}%{targetroot}/sbin/

# MAN8FILES
install -m 644 disk-utils/{{fsck,mkfs}.minix.8,mkfs.8} \
	%{buildroot}%{_mandir}/man8/

# Fdisk tools
# USBINFILES
install -m 755 sys-utils/{tunelp,cytune} \
	%{buildroot}%{_sbindir}/

# SBINFILES
install -m 755 fdisk/{cfdisk,fdisk,sfdisk} \
	%{buildroot}%{targetroot}/sbin/

# MAN8FILES
install -m 644 fdisk/{cfdisk.8,fdisk.8,sfdisk.8} \
	sys-utils/{tunelp.8,cytune.8} \
	%{buildroot}%{_mandir}/man8/

# DOCFILES [listed in %files section]

# We do not include rdev...

# install locale files
(cd po && make install DESTDIR=%{buildroot}%{targetroot})

# compress man pages
find %{buildroot}%{_infodir} -type f | xargs gzip -9f
find %{buildroot}%{_mandir} -type f | xargs gzip -9f

# getty is a special case
# In the past we called agetty "getty" so symlink it here.
ln -s agetty %{buildroot}%{targetroot}/sbin/getty
ln -s agetty.8.gz %{buildroot}%{_mandir}/man8/getty.8.gz

# install mime
install -m 644 debian/mime.util-linux \
	%{buildroot}%{_libdir}/mime/packages/util-linux

ln -s swapon %{buildroot}%{targetroot}/sbin/swapoff
ln -s hwclock.8.gz %{buildroot}%{_mandir}/man8/clock.8.gz
cp debian/copyright LICENSE

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/util-linux
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE2} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/mount
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE3} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/bsdutils

%clean
rm -rf %{buildroot}

%files -n %{pkgname}
%defattr(-,root,root)
%{_etcdir}/init.d/hwclock.sh
%{targetroot}/bin/arch
%{targetroot}/bin/dmesg
%{targetroot}/bin/more
%{targetroot}/sbin/mkswap
%{targetroot}/sbin/blockdev
%{targetroot}/sbin/agetty
%{targetroot}/sbin/getty
%{targetroot}/sbin/hwclock
%{targetroot}/sbin/raw
%{targetroot}/sbin/pivot_root
%{_bindir}/ipcs
%{_bindir}/ipcrm
%{_bindir}/setsid
%{_bindir}/namei
%{_bindir}/setterm
%{_bindir}/mcookie
%{_bindir}/whereis
%{_bindir}/ddate
%{_bindir}/getopt
%{_bindir}/rev
%{_bindir}/fdformat
%{_bindir}/chkdupexe
%{_libdir}/more.help
%{_sbindir}/readprofile
%{_sbindir}/elvtune
%{targetroot}/sbin/fsck.minix
%{targetroot}/sbin/mkfs
%{targetroot}/sbin/mkfs.minix
%{_sbindir}/tunelp
%{_sbindir}/cytune
%{targetroot}/sbin/cfdisk
%{targetroot}/sbin/fdisk
%{targetroot}/sbin/sfdisk
%{_mandir}/man1/more.1*
%{_mandir}/man1/rev.1*
%{_mandir}/man1/namei.1*
%{_mandir}/man1/mcookie.1*
%{_mandir}/man1/arch.1*
%{_mandir}/man1/readprofile.1*
%{_mandir}/man1/chkdupexe.1*
%{_mandir}/man1/setterm.1*
%{_mandir}/man1/whereis.1*
%{_mandir}/man1/ddate.1*
%{_mandir}/man1/getopt.1*
%{_mandir}/man8/dmesg.8*
%{_mandir}/man8/ipcrm.8*
%{_mandir}/man8/ipcs.8*
%{_mandir}/man8/setsid.8*
%{_mandir}/man8/agetty.8*
%{_mandir}/man8/getty.8*
%{_mandir}/man8/clock.8*
%{_mandir}/man8/hwclock.8*
%{_mandir}/man8/mkswap.8*
%{_mandir}/man8/blockdev.8*
%{_mandir}/man8/elvtune.8*
%{_mandir}/man8/fdformat.8*
%{_mandir}/man8/raw.8*
%{_mandir}/man8/pivot_root.8*
%{_mandir}/man8/fsck.minix.8*
%{_mandir}/man8/mkfs.minix.8*
%{_mandir}/man8/mkfs.8*
%{_mandir}/man8/cfdisk.8*
%{_mandir}/man8/fdisk.8*
%{_mandir}/man8/sfdisk.8*
%{_mandir}/man8/tunelp.8*
%{_mandir}/man8/cytune.8*
%{_datadir}/locale/*/LC_MESSAGES/util-linux.mo
%{_libdir}/mime/packages/util-linux
%doc %{_infodir}/ipc.info*
%doc debian/fstab.example2 fdisk/sfdisk.examples
%doc getopt-1.1.2/test.bash getopt-1.1.2/test.tcsh
%doc getopt-1.1.2/parse.bash getopt-1.1.2/parse.tcsh
%doc README HISTORY login-utils/README.getty LICENSE
%doc login-utils/README.modems-with-agetty
%doc login-utils/README.poeigl
%doc fdisk/README.cfdisk fdisk/README.fdisk
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/util-linux

%files -n %{pkgmount}
%defattr(-,root,root)
%attr(4755,root,root)	%{targetroot}/bin/mount
%attr(4755,root,root)	%{targetroot}/bin/umount
%{targetroot}/sbin/losetup
%{targetroot}/sbin/swapon
%{targetroot}/sbin/swapoff
%doc %{_mandir}/man5/fstab.5*
%doc %{_mandir}/man5/nfs.5*
%doc %{_mandir}/man8/losetup.8*
%doc %{_mandir}/man8/swapoff.8*
%doc %{_mandir}/man8/swapon.8*
%doc %{_mandir}/man8/mount.8*
%doc %{_mandir}/man8/umount.8*
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/mount
%doc mount/README.mount debian/mount.fstab LICENSE

%files -n %{pkgbsdutils}
%defattr(-,root,root)
%{_bindir}/script
%{_bindir}/logger
%{_bindir}/renice
%{_bindir}/wall
%doc %{_mandir}/man1/script.1*
%doc %{_mandir}/man1/logger.1*
%doc %{_mandir}/man1/wall.1*
%doc %{_mandir}/man8/renice.8*
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/bsdutils
%doc debian/README.script LICENSE

%changelog
* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Tue Feb 27 2001 Matthew McLean <source@mvista.com>
- First cut
