summary: The GNU shell programming utilities.
Name: hhl-target-shellutils
Version: 2.0.11
Release: %{_hhl_build_id}.2
Source: shellutils_%{version}.orig.tar.gz
Source1: shellutils.tmpl
Source2: shellutils-doc.tmpl
Source3: shellutils-hostname.tmpl
Patch0: shellutils_%{version}-11.diff.gz
# Removes chinese lang support
Patch1: hhl-remove-zh.diff
License: GPL
Group: base
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
%define _docdir	%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}

%description
The utilities: basename chroot date dirname echo env expr factor false groups
hostid id logname nice nohup pathchk pinky printenv printf pwd seq sleep stty
tee test true tty uname users who whoami yes.

%package -n hhl-%{_hhl_target_arch}-shellutils
Summary: The GNU shell programming utilities.
Group: base
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-shellutils
The utilities: basename chroot date dirname echo env expr factor false groups
hostid id logname nice nohup pathchk pinky printenv printf pwd seq sleep stty
tee test true tty uname users who whoami yes.

%package -n hhl-%{_hhl_target_arch}-shellutils-doc
Summary: The GNU shell programming utilities.
Group: base
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-shellutils-doc
The utilities: basename chroot date dirname echo env expr factor false groups
hostid id logname nice nohup pathchk pinky printenv printf pwd seq sleep stty
tee test true tty uname users who whoami yes.

This package includes the documentation for shellutils.

%package -n hhl-%{_hhl_target_arch}-shellutils-hostname
Summary: The GNU shell programming utilities.
Group: base
AutoReqProv: no
Conflicts: hhl-%{_hhl_target_arch}-hostname
%description -n hhl-%{_hhl_target_arch}-shellutils-hostname
The utilities: basename chroot date dirname echo env expr factor false groups
hostid id logname nice nohup pathchk pinky printenv printf pwd seq sleep stty
tee test true tty uname users who whoami yes.

This package provides the shellutils version of hostname.

%prep
%target_check
%setup -q -n shellutils-2.0.11
%patch0 -p1
%patch1 -p1

%build
%target_setup
export ac_cv_func_setvbuf_reversed='no'

%target_configure

%make all | tee -a build.log

%install
rm -rf %{buildroot}
%target_setup
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_prefix}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_exec_prefix}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_include_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_info_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/bin
%target_makeinstall | tee -a build.log
gzip -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man?/*.?
rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_info_dir}/*.gz
gzip -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_info_dir}/*

# The procps package is supposed to supply uptime.
rm %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/uptime
rm %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/uptime.1.gz
# The shadow package is supposed to supply su
rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/su
rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/su.1.gz
# The hostname package supplies hostname

# move stuff into /bin to match debian standards
mv %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/{echo,pwd,sleep,uname,hostname,true,stty,false,date,chroot} %{buildroot}%{_hhl_cross_target_dir}/bin

cd ..
cp COPYING LICENSE

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/shellutils
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE2} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/shellutils-doc
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE3} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/shellutils-hostname

%clean
rm -rf %{buildroot}

%files -n hhl-%{_hhl_target_arch}-shellutils-hostname
%defattr(-,root,root)
%{_hhl_cross_target_dir}/bin/hostname
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/hostname.1.gz
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/shellutils-hostname

%files -n hhl-%{_hhl_target_arch}-shellutils
%defattr(-,root,root)
%{_hhl_cross_target_dir}/bin/chroot
%{_hhl_cross_target_dir}/bin/date
%{_hhl_cross_target_dir}/bin/echo
%{_hhl_cross_target_dir}/bin/false
%{_hhl_cross_target_dir}/bin/pwd
%{_hhl_cross_target_dir}/bin/sleep
%{_hhl_cross_target_dir}/bin/stty
%{_hhl_cross_target_dir}/bin/true
%{_hhl_cross_target_dir}/bin/uname
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/basename
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/dirname
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/env
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/expr
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/factor
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/groups
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/hostid
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/id
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/logname
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/nice
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/nohup
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/pathchk
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/pinky
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/printenv
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/printf
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/seq
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/tee
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/test
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/tty
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/users
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/who
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/whoami
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/yes
%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/locale/*
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/shellutils

%files -n hhl-%{_hhl_target_arch}-shellutils-doc
%defattr(-,root,root)
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/basename.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/chroot.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/date.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/dirname.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/echo.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/env.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/expr.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/factor.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/false.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/groups.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/hostid.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/id.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/logname.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/nice.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/nohup.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/pathchk.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/pinky.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/printenv.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/printf.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/pwd.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/seq.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/sleep.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/stty.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/tee.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/test.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/true.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/tty.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/uname.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/users.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/who.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/whoami.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/yes.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_info_dir}/*.info*
%doc ABOUT-NLS AUTHORS COPYING NEWS README README-alpha THANKS TODO
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/shellutils-doc

%changelog
* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Sat Feb 24 2001 Charles Duffy <source@mvista.com>
- First cut
