Summary: The GNU text file processing utilities.
Name: hhl-target-textutils
Version: 2.0
Release: %{_hhl_build_id}.1
Source: textutils-%{version}.tar.gz
Source1: textutils.tmpl
Patch: textutils_%{version}-diff
License: GPL
Group: base
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}

%define pkgname hhl-%{_hhl_target_arch}-textutils
%define targetroot %{_hhl_cross_target_dir}

%define _bindir %{targetroot}%{_hhl_target_bin_dir}
%define _docdir	%{targetroot}%{_hhl_target_doc_dir}
%define _mandir	%{targetroot}%{_hhl_target_man_dir}
%define _datadir %{targetroot}%{_hhl_target_sharedstate_dir}
%define _infodir %{targetroot}%{_hhl_target_info_dir}

%description
The utilities: cat cksum comm csplit cut expand fmt fold head join md5sum
nl od paste pr ptx sort split sum tac tail tr tsort unexpand uniq wc.

# textutils
%package -n %{pkgname}
Summary: The GNU text file processing utilities.
Group: System Environment/Base 
AutoReqProv: no
%description -n %{pkgname}
The utilities: cat cksum comm csplit cut expand fmt fold head join md5sum
nl od paste pr ptx sort split sum tac tail tr tsort unexpand uniq wc.

%prep
%target_check
%setup -q -n textutils-%{version}
%patch -p1

%build
%target_setup
# Avoid checks which fail on cross-compiling.
export ac_cv_func_fnmatch_works=yes
export ac_cv_func_mmap_fixed_mapped=yes
export am_cv_func_working_getline=yes
export jm_cv_func_working_chown=yes
export ac_cv_func_working_mktime=yes
export jm_cv_func_lstat_empty_string_bug=no
export jm_cv_func_stat_empty_string_bug=no
export jm_cv_func_working_realloc=yes
export jm_cv_func_working_malloc=yes
export jm_cv_func_working_readdir=yes
export jm_cv_func_memcmp_working=yes
export ac_cv_func_setvbuf_reversed=no
export am_cv_func_strtod=yes
export jm_cv_func_working_re_compile_pattern=yes
%target_configure | tee ../build.log

%make | tee -a ../build.log

%install
rm -rf %{buildroot}
%target_setup
%target_makeinstall | tee -a ../build.log
install -d %{buildroot}%{targetroot}/bin
mv %{buildroot}%{_bindir}/cat %{buildroot}%{targetroot}/bin/cat
gzip -9f %{buildroot}%{_mandir}/man*/* %{buildroot}%{_infodir}/*.info
cd ..
cp COPYING LICENSE

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/textutils

%clean
rm -rf %{buildroot}

%files -n %{pkgname}
%defattr(-,root,root)
%{targetroot}/bin/cat
%{_bindir}/*
%{_datadir}/locale/*/*/*
%doc %{_infodir}/*.gz
%doc %{_mandir}/man*/*.gz

%doc README NEWS LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/textutils

%changelog
* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Tue Jan 30 2001 Matthew McLean <source@mvista.com>
: First cut
