Summary: NetBSD /bin/sh
Name: hhl-target-ash
Version: 0.3.8
Release: %{_hhl_build_id}.8
Source: ftp://ftp.debian.org/pub/mirrors/debian/pool/main/a/ash/ash_%{version}.orig.tar.gz
Source1: hhl-ash.tmpl
Source2: ash-LICENSE
Patch: ftp://ftp.debian.org/pub/mirrors/debian/pool/main/a/ash/ash_%{version}-32.diff.gz
Patch1: ash-0.3.7-autoconf.diff
Patch2: ash-0.3.7-bison.diff
Patch3: ash-0.3.8-hhl.patch
Patch4: ash-0.3.8-dotcmd-param.patch
License: BSD
Group: shells
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
BuildRequires: hhl-%{_hhl_target_arch}-flex
Prefix: %{_hhl_cross_target_dir}
%define _docdir         %{_hhl_cross_target_dir}%{_hhl_target_doc_dir}

%description
"ash" is a POSIX compliant shell that is much smaller than "bash".

It can be usefully installed as /bin/sh (because it executes scripts
somewhat faster than "bash"), or as the default shell either of root
or of a second user with a userid of 0 (because it depends on fewer
libraries, and is therefore less likely to be affected by an upgrade
problem or a disk failure).  It is also useful for checking that a
script uses only POSIX syntax.

"bash" is a better shell for most users, since it has some nice
features absent from "ash", and is a required part of the system.

# Primary package
%package -n hhl-%{_hhl_target_arch}-ash
Summary: NetBSD /bin/sh
Group: shells
AutoReqProv: no
Requires: hhl-%{_hhl_target_arch}-hardhatutils
%description -n hhl-%{_hhl_target_arch}-ash
"ash" is a POSIX compliant shell that is much smaller than "bash".

It can be usefully installed as /bin/sh (because it executes scripts
somewhat faster than "bash"), or as the default shell either of root
or of a second user with a userid of 0 (because it depends on fewer
libraries, and is therefore less likely to be affected by an upgrade
problem or a disk failure).  It is also useful for checking that a
script uses only POSIX syntax.

"bash" is a better shell for most users, since it has some nice
features absent from "ash", and is a required part of the system.

%prep
%target_check
%setup -q -n ash-%{version}.orig
%patch -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%build
autoconf
%define _objdir .
%target_setup

# Will NOT shadow build!
export ac_cv_func_getpgrp_void='yes'

./configure \
        --host=%{_hhl_target_config} \
        --build=%{_hhl_host_config} \
        --prefix=%{_hhl_target_prefix} \
        --exec-prefix=%{_hhl_target_exec_prefix} \
        --bindir=%{_hhl_target_bin_dir} \
        --sbindir=%{_hhl_target_sbin_dir} \
        --sysconfdir=%{_hhl_target_sysconf_dir} \
        --datadir=%{_hhl_target_data_dir} \
        --includedir=%{_hhl_target_include_dir} \
        --libdir=%{_hhl_target_lib_dir} \
        --libexecdir=%{_hhl_target_libexec_dir} \
        --localstatedir=%{_hhl_target_localstate_dir} \
        --sharedstatedir=%{_hhl_target_sharedstate_dir} \
        --mandir=%{_hhl_target_man_dir} \
        --infodir=%{_hhl_target_info_dir} | tee build.log

%make | tee -a build.log

%install
%target_setup
rm -rf %{buildroot}

mkdir -p %{buildroot}%{_hhl_cross_target_dir}/bin/
install -m 755 ash %{buildroot}%{_hhl_cross_target_dir}/bin/
install -m 755 ash.static %{buildroot}%{_hhl_cross_target_dir}/bin/
install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > ash.pml
install -m 644 ash.pml %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ash

cp %{SOURCE2} LICENSE

%clean
rm -rf %{buildroot}

%post -n hhl-%{_hhl_target_arch}-ash
%target_script_prefix_setup

# Register the shell
(%{_hhl_target_toolprefix}shellconfig --add /bin/ash 10) &> /dev/null || echo "Unable to register shell"
(%{_hhl_target_toolprefix}shellconfig --add /bin/ash.static 11) &> /dev/null || echo "Unable to register shell"

%preun -n hhl-%{_hhl_target_arch}-ash
%target_script_prefix_setup

# Unregister the shell
(%{_hhl_target_toolprefix}shellconfig --del /bin/ash) &> /dev/null || echo "Unable to unregister shell"
(%{_hhl_target_toolprefix}shellconfig --del /bin/ash.static) &> /dev/null || echo "Unable to unregister shell"

%files -n hhl-%{_hhl_target_arch}-ash
%defattr(-,root,root)
%{_hhl_cross_target_dir}/bin/ash
%{_hhl_cross_target_dir}/bin/ash.static
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ash
%doc LICENSE build.log

%changelog
* Tue Mar 13 2001 Jeremy Puhlman <jpuhlman@mvista.com>
- first-cut hhl spec file
