#ifndef TX4925_TX4925_H
#define TX4925_TX4925_H

/*
 * linux/include/asm-mips/tx4925/tx4925.h
 *
 * tx4925 defs
 *
 * Author: MontaVista Software, Inc.
 *         source@mvista.com
 *
 * Copyright 2001-2002 MontaVista Software Inc.
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <asm/tx4925/tx4925_mips.h>
#include <asm/tx4925/tx4925_bringup.h>

/*
 This register naming came from the intergrate cpu/controoler name TX4925
 followed by the device name from table 4.2.1 on page 4-3 and then followed
 by the register name from table 4.2.2 on pages 4-4 to 4-11.  The manaul
 used is "TMPR4925XB Preliminary Rev 0.0 Dec.2001".
 */

/* TX4925 controller */
#define TX4925_BASE                     0xff1f0000
#define TX4925_LIMIT                    0xff1fffff


/* TX4925 SDRAM controller */
#define TX4925_SDRAMC_BASE              0x8000 
#define TX4925_SDRAMC_SDCCR0            0x8000 
#define TX4925_SDRAMC_SDCCR1            0x8004
#define TX4925_SDRAMC_SDCCR2            0x8008
#define TX4925_SDRAMC_SDCCR3            0x800c
#define TX4925_SDRAMC_SDCTR             0x8020
#define TX4925_SDRAMC_SDCMD             0x802c
#define TX4925_SDRAMC_SFCMD             0x8030
#define TX4925_SDRAMC_LIMIT             0x8fff 


/* TX4925 external bus controller */
#define TX4925_EBUSC_BASE               0x9000
#define TX4925_EBUSC_EBCCR0             0x9000
#define TX4925_EBUSC_EBBAR0             0x9004
#define TX4925_EBUSC_EBCCR1             0x9008
#define TX4925_EBUSC_EBBAR1             0x900c
#define TX4925_EBUSC_EBCCR2             0x9010
#define TX4925_EBUSC_EBBAR2             0x9014
#define TX4925_EBUSC_EBCCR3             0x9018
#define TX4925_EBUSC_EBBAR3             0x901c
#define TX4925_EBUSC_EBCCR4             0x9020
#define TX4925_EBUSC_EBBAR4             0x9024
#define TX4925_EBUSC_EBCCR5             0x9028
#define TX4925_EBUSC_EBBAR5             0x902c
#define TX4925_EBUSC_EBCCR6             0x9030
#define TX4925_EBUSC_EBBAR6             0x9034
#define TX4925_EBUSC_EBCCR7             0x9038
#define TX4925_EBUSC_EBBAR7             0x903c
#define TX4925_EBUSC_LIMIT              0x9fff


/* TX4925 CHI Module */
#define	TX4925_CHI_BASE			0xa800
#define	TX4925_CHI_CTRL			0xa800
#define	TX4925_CHI_PNTREN		0xa804
#define	TX4925_CHI_RXPTRA		0xa808
#define	TX4925_CHI_RXPTRB		0xa80c
#define	TX4925_CHI_TXPTRA		0xa810
#define	TX4925_CHI_TXPTRB		0xa814
#define	TX4925_CHI_CHISIZE		0xa818
#define	TX4925_CHI_RXSTRT		0xa81c
#define	TX4925_CHI_TXSTRT		0xa820
#define	TX4925_CHI_HOLD			0xa824
#define	TX4925_CHI_CLOCK		0xa828
#define	TX4925_CHI_CHIINTE		0xa82c
#define	TX4925_CHI_CHIINT		0xa830
#define	TX4925_CHI_LIMIT		0xafff


/* TX4925 DMA Controller */
#define TX4925_DMAC_BASE                0xb000
#define TX4925_DMAC_DMMCR               0xb0a8
#define TX4925_DMAC_LIMIT               0xbfff


/* TX4925 NAND Flash Controller */
#define TX4925_NDFMC_BASE               0xc000
#define TX4925_NDFMC_LIMIT              0xcfff


/* TX4925 PCI Controller */
#define TX4925_PCIC_BASE                0xd000
#define TX4925_PCIC_LIMIT               0xdfff


/* TX4925 Configuration registers */
#define TX4925_CONFIG_BASE              0xe000
#define TX4925_CONFIG_CCFG              0xe000
#define TX4925_CONFIG_REVID             0xe004 
#define TX4925_CONFIG_PCFG              0xe008 
#define TX4925_CONFIG_TOEA              0xe00c 
#define TX4925_CONFIG_PDNCTR            0xe010 
#define TX4925_CONFIG_GARBP             0xe018 
#define TX4925_CONFIG_TOCNT             0xe020 
#define TX4925_CONFIG_DRQCTR            0xe024 
#define TX4925_CONFIG_CLKCTR            0xe028 
#define TX4925_CONFIG_GARBC             0xe02C
#define TX4925_CONFIG_RAMP              0xe030 
#define TX4925_CONFIG_LIMIT             0xefff


/* TX4925 Timer 0 */
#define TX4925_TMR0_BASE                0xf000
#define TX4925_TMR0_TMTCR               0xf000
#define TX4925_TMR0_TMTISR              0xf004
#define TX4925_TMR0_TMCPRA              0xf008
#define TX4925_TMR0_TMCPRB              0xf00c
#define TX4925_TMR0_TMITMR              0xf010
#define TX4925_TMR0_TMCCDR              0xf020
#define TX4925_TMR0_TMPGMR              0xf030
#define TX4925_TMR0_TMTRR               0xf0f0
#define TX4925_TMR0_LIMIT               0xf0ff


/* TX4925 Timer 1  */
#define TX4925_TMR1_BASE                0xf100
#define TX4925_TMR1_TMTCR               0xf100
#define TX4925_TMR1_TMTISR              0xf104
#define TX4925_TMR1_TMCPRA              0xf108
#define TX4925_TMR1_TMCPRB              0xf10c
#define TX4925_TMR1_TMITMR              0xf110
#define TX4925_TMR1_TMCCDR              0xf120
#define TX4925_TMR1_TMPGMR              0xf130
#define TX4925_TMR1_TMTRR               0xf1f0
#define TX4925_TMR1_LIMIT               0xf1ff


/* TX4925 Timer 2 */
#define TX4925_TMR2_BASE                0xf200
#define TX4925_TMR2_TMTCR               0xf200
#define TX4925_TMR2_TMTISR              0xf204
#define TX4925_TMR2_TMCPRA              0xf208
#define TX4925_TMR2_TMCPRB              0xf20c
#define TX4925_TMR2_TMITMR              0xf210
#define TX4925_TMR2_TMCCDR              0xf220
#define TX4925_TMR2_TMPGMR              0xf230
#define TX4925_TMR2_TMTRR               0xf2f0
#define TX4925_TMR2_LIMIT               0xf2ff

/* bits for TMTCRn */
#define	TX4925_TMR_TMTCR_TCE		0x00000080
#define	TX4925_TMR_TMTCR_CCDE		0x00000040
#define	TX4925_TMR_TMTCR_CRE		0x00000020
#define	TX4925_TMR_TMTCR_ECES		0x00000008
#define	TX4925_TMR_TMTCR_CCS_IMBUS	0x00000000
#define	TX4925_TMR_TMTCR_CCS_TCLK	0x00000004
#define	TX4925_TMR_TMTCR_TMODE_INTVL	0x00000000
#define	TX4925_TMR_TMTCR_TMODE_PULSE	0x00000001
#define	TX4925_TMR_TMTCR_TMODE_WDT	0x00000002

/* bits for TMITMRn */
#define	TX4925_TMR_TMITMRn_TIIE		0x00008000
#define	TX4925_TMR_TMITMRn_TZCE		0x00000001

/* TX4925 serial port 0 */
#define TX4925_SIO0_BASE                0xf300 
#define TX4925_SIO0_SILCR               0xf300 
#define TX4925_SIO0_SIDICR              0xf304 
#define TX4925_SIO0_SIDISR              0xf308 
#define TX4925_SIO0_SISCISR             0xf30c 
#define TX4925_SIO0_SIFCR               0xf310 
#define TX4925_SIO0_SIFLCR              0xf314 
#define TX4925_SIO0_SIBGR               0xf318 
#define TX4925_SIO0_SITFIF0             0xf31c 
#define TX4925_SIO0_SIRFIFO             0xf320          
#define TX4925_SIO0_SIRFIFO             0xf320          
#define TX4925_SIO0_LIMIT               0xf3ff 


/* TX4925 serial port 1 */
#define TX4925_SIO1_BASE                0xf400 
#define TX4925_SIO1_SILCR               0xf400 
#define TX4925_SIO1_SIDICR              0xf404 
#define TX4925_SIO1_SIDISR              0xf408 
#define TX4925_SIO1_SISCISR             0xf40c 
#define TX4925_SIO1_SIFCR               0xf410 
#define TX4925_SIO1_SIFLCR              0xf414 
#define TX4925_SIO1_SIBGR               0xf418 
#define TX4925_SIO1_SITFIF0             0xf41c 
#define TX4925_SIO1_SIRFIFO             0xf420 
#define TX4925_SIO1_LIMIT               0xf4ff 


/* TX4925 parallel port */
#define TX4925_PIO_BASE                 0xf500
#define TX4925_PIO_PIODO                0xf500
#define TX4925_PIO_PIODI                0xf504
#define TX4925_PIO_PIODIR               0xf508
#define TX4925_PIO_PIOOD                0xf50c
#define TX4925_PIO_LIMIT                0xf50f


/* TX4925 Interrupt Controller */
#define TX4925_IRC_BASE                 0xf510
#define TX4925_IRC_IRFLAG0              0xf510
#define TX4925_IRC_IRFLAG1              0xf514
#define TX4925_IRC_IRPOL                0xf518
#define TX4925_IRC_IRRCNT               0xf51c
#define TX4925_IRC_IRMASKINT            0xf520
#define TX4925_IRC_IRMASKEXT            0xf524
#define TX4925_IRC_IRDEN                0xf600
#define TX4925_IRC_IRDM0                0xf604
#define TX4925_IRC_IRDM1                0xf608
#define TX4925_IRC_IRLVL0               0xf610
#define TX4925_IRC_IRLVL1               0xf614
#define TX4925_IRC_IRLVL2               0xf618
#define TX4925_IRC_IRLVL3               0xf61c
#define TX4925_IRC_IRLVL4               0xf620
#define TX4925_IRC_IRLVL5               0xf624
#define TX4925_IRC_IRLVL6               0xf628
#define TX4925_IRC_IRLVL7               0xf62c
#define TX4925_IRC_IRMSK                0xf640
#define TX4925_IRC_IREDC                0xf660
#define TX4925_IRC_IRPND                0xf680
#define TX4925_IRC_IRCS                 0xf6a0
#define TX4925_IRC_LIMIT                0xf6ff


/* TX4925 AC-link controller */
#define TX4925_ACLC_BASE                0xf700
#define TX4925_ACLC_ACCTLEN             0xf700
#define TX4925_ACLC_ACCTLDIS            0xf704
#define TX4925_ACLC_ACREGACC            0xf708
#define TX4925_ACLC_ACINTSTS            0xf710
#define TX4925_ACLC_ACINTMSTS           0xf714
#define TX4925_ACLC_ACINTEN             0xf718
#define TX4925_ACLC_ACINTDIS            0xf71c
#define TX4925_ACLC_ACSEMAPH            0xf720
#define TX4925_ACLC_ACGPIDAT            0xf740
#define TX4925_ACLC_ACGPODAT            0xf744
#define TX4925_ACLC_ACSLTEN             0xf748
#define TX4925_ACLC_ACSLTDIS            0xf74c
#define TX4925_ACLC_ACFIFOSTS           0xf750
#define TX4925_ACLC_ACDMASTS            0xf780
#define TX4925_ACLC_ACDMASEL            0xf784
#define TX4925_ACLC_ACAUDODAT           0xf7a0
#define TX4925_ACLC_ACSURRDAT           0xf7a4
#define TX4925_ACLC_ACCENTDAT           0xf7a8
#define TX4925_ACLC_ACLFEDAT            0xf7ac
#define TX4925_ACLC_ACAUDIDAT           0xf7b0
#define TX4925_ACLC_ACMODODAT           0xf7b8
#define TX4925_ACLC_ACMODIDAT           0xf7bc
#define TX4925_ACLC_ACREVID             0xf7fc
#define TX4925_ACLC_LIMIT               0xf7ff


/* TX4925 SPI Module */
#define	TX4925_SPI_BASE			0xf800
#define	TX4925_SPI_SPMCR		0xf800
#define	TX4925_SPI_SPCR0		0xf804
#define	TX4925_SPI_SPCR1		0xf808
#define	TX4925_SPI_SPFS			0xf80c
#define	TX4925_SPI_SPSR			0xf814
#define	TX4925_SPI_SPDR			0xf818
#define	TX4925_SPI_LIMIT		0xf8ff

/* bits for SPMCR */
#define	TX4925_SPI_SPMCR_OPMODE_CONFIG	0x00000040
#define	TX4925_SPI_SPMCR_OPMODE_ACTIVE	0x00000080
#define	TX4925_SPI_SPMCR_SPSTP		0x00000002
#define	TX4925_SPI_SPMCR_BCLR		0x00000001

/* bits for SPSR */
#define	TX4925_SPI_SPSR_TBSI		0x00008000
#define	TX4925_SPI_SPSR_RBSI		0x00004000
#define	TX4925_SPI_SPSR_TBS_MASK	0x00003800
#define	TX4925_SPI_SPSR_RBS_MASK	0x00000700
#define	TX4925_SPI_SPSR_SPOE		0x00000080
#define	TX4925_SPI_SPSR_IFSD		0x00000008
#define	TX4925_SPI_SPSR_SIDLE		0x00000004
#define	TX4925_SPI_SPSR_STRDY		0x00000002
#define	TX4925_SPI_SPSR_SRRDY		0x00000001

/* TX4925 RTC Module */
#define TX4925_RTC_BASE			0xf900
#define TX4925_RTC_RTCHI		0xf900
#define TX4925_RTC_RTCLO		0xf904
#define TX4925_RTC_ALARMHI		0xf908
#define TX4925_RTC_ALARMLO		0xf90c
#define TX4925_RTC_RTCCTRL		0xf910
#define TX4925_RTC_RTCINT		0xf914
#define TX4925_RTC_LIMIT		0xf9ff



#define TX4925_REG(x) ((TX4925_BASE)+(x))

#define TX4925_RD08( reg      )   (*(vu08*)(reg))
#define TX4925_WR08( reg, val )  ((*(vu08*)(reg))=(val))

#define TX4925_RD16( reg      )   (*(vu16*)(reg))
#define TX4925_WR16( reg, val )  ((*(vu16*)(reg))=(val))

#define TX4925_RD32( reg      )   (*(vu32*)(reg))
#define TX4925_WR32( reg, val )  ((*(vu32*)(reg))=(val))

#define TX4925_RD( reg      )	TX4925_RD32( TX4925_REG(reg) )
#define TX4925_WR( reg, val )	TX4925_WR32( TX4925_REG(reg), val )





#define TX4925_IRQ_CP0_RAW_BEG   0    /* tx4925 cpu built-in cp0 */
#define TX4925_IRQ_CP0_RAW_END   7
#define TX4925_IRQ_PIC_RAW_BEG   0    /* tx4925 cpu build-in pic */
#define TX4925_IRQ_PIC_RAW_END  31


#define TX4925_IRQ_CP0_BEG  (TX4925_IRQ_CP0_RAW_BEG)  /* 0 */
#define TX4925_IRQ_CP0_END  (TX4925_IRQ_CP0_RAW_END)  /* 7 */

#define TX4925_IRQ_PIC_BEG  ((TX4925_IRQ_CP0_END+1)+TX4925_IRQ_PIC_RAW_BEG)  /* 8 */
#define TX4925_IRQ_PIC_END  ((TX4925_IRQ_CP0_END+1)+TX4925_IRQ_PIC_RAW_END)  /* 39 */


#define TX4925_IRQ_USER0            (TX4925_IRQ_CP0_BEG+0)
#define TX4925_IRQ_USER1            (TX4925_IRQ_CP0_BEG+1)
#define TX4925_IRQ_NEST_PIC_ON_CP0  (TX4925_IRQ_CP0_BEG+2)
#define TX4925_IRQ_CPU_TIMER        (TX4925_IRQ_CP0_BEG+7)
#define TX4925_IRQ_IRC_INT0         (TX4925_IRQ_PIC_BEG+2)
#define TX4925_IRQ_IRC_INT1         (TX4925_IRQ_PIC_BEG+3)
#define TX4925_IRQ_IRC_INT2         (TX4925_IRQ_PIC_BEG+4)
#define TX4925_IRQ_IRC_INT3         (TX4925_IRQ_PIC_BEG+5)
#define TX4925_IRQ_IRC_INT4         (TX4925_IRQ_PIC_BEG+6)
#define TX4925_IRQ_IRC_INT5         (TX4925_IRQ_PIC_BEG+7)
#define TX4925_IRQ_IRC_INT6         (TX4925_IRQ_PIC_BEG+8)
#define TX4925_IRQ_IRC_INT7         (TX4925_IRQ_PIC_BEG+9)
#define TX4925_IRQ_IRC_TMR0         (TX4925_IRQ_PIC_BEG+21)





#endif
