/*
 * linux/arch/mips/tx4925/common/tx4925_bringup.c
 *
 * Routines helpful for bringup on a new tx4925 board.
 *
 * Author: MontaVista Software, Inc.
 *         source@mvista.com
 *
 * Copyright 2001-2002 MontaVista Software Inc.
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <linux/tx4925_sio.h>


static tx4925_sio_hw_st* g_bringup_port = (tx4925_sio_hw_st*)TX4925_SIO_BASE_SIO0;


void
tx4925_bringup_printk_raw_serial_io_putc( u8 ch )
{
#ifdef CONFIG_RICOH_BASIL_S1
  basil_s1_bringup_printk_raw_serial_io_putc( ch );
#else
  tx4925_sio_tx_fifo_wait_wr_flush( g_bringup_port, ch );
#endif
  return;
}


void
tx4925_brinup_put_sio0( u8 ch )
{
  tx4925_sio_tx_fifo_wait_wr_flush( TX4925_SIO_BASE_SIO0, ch );
  return;
}


void
tx4925_brinup_put_sio1( u8 ch )
{
  tx4925_sio_tx_fifo_wait_wr_flush( TX4925_SIO_BASE_SIO1, ch );
  return;
}


void (*printk_bringup_raw_serial_io_putc)(u8 ch) = tx4925_bringup_printk_raw_serial_io_putc;
