/*
 * linux/arch/mips/tx4925/basil_s1/basil_s1_irq.c
 *
 * Toshiba Basil-S1 specific interrupt handlers
 *
 * Author: MontaVista Software, Inc.
 *         source@mvista.com
 *
 * Copyright 2001-2002 MontaVista Software Inc.
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
IRQ  Device  
00   TX4925-CP0/00 Software 0
01   TX4925-CP0/01 Software 1
02   TX4925-CP0/02 Cascade TX4925-CP0
03   TX4925-CP0/03 Multiplexed -- do not use 
04   TX4925-CP0/04 Multiplexed -- do not use 
05   TX4925-CP0/05 Multiplexed -- do not use 
06   TX4925-CP0/06 Multiplexed -- do not use 
07   TX4925-CP0/07 CPU TIMER -- do not use (Basil-S1 use TMR0)

08   TX4925-PIC/00
09   TX4925-PIC/01
10   TX4925-PIC/02 Basil-S1 LANC#0 (RTL-8100 ethernet) 
11   TX4925-PIC/03 Basil-S1 LANC#1 (RTL-8100 ethernet)
12   TX4925-PIC/04
13   TX4925-PIC/05
14   TX4925-PIC/06 Basil-S1 PCMCIA I/F CN#A
15   TX4925-PIC/07 Basil-S1 PCMCIA I/F CN#B & DEBUG I/F
16   TX4925-PIC/08
17   TX4925-PIC/09
18   TX4925-PIC/10
19   TX4925-PIC/11
20   TX4925-PIC/12 TX4925 SerialIO Channel 0
21   TX4925-PIC/13 TX4925 SerialIO Channel 1
22   TX4925-PIC/14
23   TX4925-PIC/15
24   TX4925-PIC/16
25   TX4925-PIC/17
26   TX4925-PIC/18
27   TX4925-PIC/19
28   TX4925-PIC/20 TX4925 PCI PCI-C
29   TX4925-PIC/21 TX4925 Timer Channel 0
30   TX4925-PIC/22 
31   TX4925-PIC/23
32   TX4925-PIC/24
33   TX4925-PIC/25
34   TX4925-PIC/26
35   TX4925-PIC/27
36   TX4925-PIC/28
37   TX4925-PIC/29 TX4925 PCI PCI-ERR
38   TX4925-PIC/30 TX4925 PCI PCI-PMA (net used)
39   TX4925-PIC/31
*/


#include <linux/config.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/mm.h>
#include <linux/swap.h>
#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/pci.h>
#include <linux/timex.h>
#include <asm/bootinfo.h>
#include <asm/page.h>
#include <asm/bootinfo.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/pci.h>
#include <asm/processor.h>
#include <asm/ptrace.h>
#include <asm/reboot.h>
#include <asm/time.h>
#include <linux/version.h>
#include <linux/bootmem.h>
#include <linux/blk.h>
#include <linux/tx4925_sio.h>
#include <asm/tx4925/basil_s1/basil_s1.h>

int 
basil_s1_irq_nested( int sw_irq )
{
    return( sw_irq );
}

void __init
init_IRQ( void )
{
    extern void tx4925_irq_init(void);

    cli();

    tx4925_irq_init();

    #ifdef CONFIG_PCI
    {
      extern void basil_s1_pci_irq_init( void );
      basil_s1_pci_irq_init();
    }
    #endif

    wbflush();

    return;
}

