Summary: The GNU C Library
Name: glibc
Version: 2.3.2
Release: 25.0.36.%{_hhl_build_id}
# GNU Blessed Source -- Part of the glibc release
Source0: ftp://ftp.gnu.org/gnu/glibc/glibc-2.3.2.tar.bz2
Source1: ftp://ftp.gnu.org/gnu/glibc/glibc-linuxthreads-2.3.2.tar.bz2

Source4: glibc-xtensa_linux_be.tar
Source5: glibc-xtensa_linux_le.tar
Source6: glibc-xtensa_linux_test.tar

Source10: ftp://elsie.nci.nih.gov/pub/tzcode2001c.tar.gz

# HHL Configuration Files
Source20: nsswitch.conf
Source21: host.conf
Source22: hhl-libopt-build-libc
Source23: hhl-libopt-build-libm
Source25: glibc.tmpl
Source26: glibc-dev.tmpl
Source27: glibc-doc.tmpl
Source28: glibc-i18ndata.tmpl
Source29: glibc-libopt.tmpl
Source30: glibc-locales.tmpl
Source31: glibc-nscd.tmpl
Source32: glibc-pic.tmpl
Source33: glibc-prof.tmpl
Source34: devpts
Source35: nscd
Source36: tzconfig

# Patches from Debian

Patch1: glibc22-ttyname-devfs.dpatch
Patch3: librt-mips.dpatch
Patch4: glibc23-ctype-compat.dpatch
Patch5: glibc23-function-compat.dpatch
Patch6: glibc23-errno.dpatch
Patch7: libgcc-compat-all.dpatch
Patch8: libgcc-compat-other.dpatch
Patch9: ldd.dpatch
Patch10: tcsetattr.dpatch

# MontaVista Patches
Patch75: glibc-2.2.5-arm_memcpy.patch
Patch76: glibc-2.3.2-nounit.patch
Patch100: hhl-glibc-rpc-cross.patch
Patch101: hhl-powerpc-altivec.patch
Patch102: hhl-405-atomicity.patch
Patch103: hhl-glibc-2.3.2-sh.patch
Patch104: hhl-glibc-2.2.5-save-lds.patch
Patch105: glibc-2.2.3-arm_sa_be.patch
Patch106: glibc-2.2.5-xtensa_linux_common.patch
Patch107: glibc-2.3.2-lock-memory.patch
Patch108: glibc-linuxthreads-db-static.patch
Patch109: glibc-2.2.5_mips_nfp.patch
Patch110: glibc-2.2.5-sh-compat.patch
Patch111: glibc-2.3.2-vfork-backtrace.patch
Patch112: hhl-glibc-asm-debug.patch
Patch113: glibc-2.3.2-mips-vfork.patch
Patch114: hhl-glibc-libgcc-compat.patch
Patch115: glibc-2.2.5-lsb-locale.patch
Patch116: glibc-2.2.5-rel_calc.patch
Patch117: glibc-2.2.5-xtensa_memcpy.patch
Patch118: glibc-2.2.5-xtensa_strlen.patch
#Patch119: glibc-2.2.5-xtensa-corebits.patch
Patch120: glibc-2.2.5-xtensa_align.patch
Patch121: glibc-2.3.2-arm.patch
Patch122: glibc-2.3.2-libc-lds-error.patch
Patch123: glibc-2.3.2-arm-nobits.patch
Patch124: glibc-2.3.2-sh-features.patch
Patch125: glibc-2.3.2-powerpc-softfp-hidden.patch
Patch126: glibc-2.3.2-arm-asm.spec
Patch128: glibc-2.2.5-timers.patch
Patch129: glibc-2.3.2-prelink-diagnostic.patch
Patch130: glibc-2.3.2-elcstd.patch
Patch131: glibc-2.3.2-mips-shmlba.patch
Patch132: glibc-2.3.2-sh4_syscallfix.patch
Patch133: mvl-glibc-2.3.2-isv-compat.patch
Patch134: glibc-2.3.2-libthreaddb-initial.patch
Patch135: glibc-2.2.5-mips-profile.patch
Patch136: glibc-2.3.2-mips-jalr-gp.patch
Patch137: glibc-2.3.2-arm-spinlock.patch
#Patch138: glibc-2.3.2-getenv.patch
Patch139: glibc-2.3.2-mips_atomicity.patch
Patch140: glibc-2.3.2-sig_race.patch
Patch141: glibc-2.3.2-arm_sigrtmax.patch
Patch143: glibc-2.3.2-pthread_cleanup.patch
Patch144: glibc-2.3.2-sysconf.patch
Patch145: glibc-2.3.2-syslog.patch
Patch146: glibc-2.3.2-setgid.patch
Patch147: glibc-2.3.2-o_streaming.patch

Patch149: glibc-2.3.2-xtensa_configure.patch
Patch150: glibc-2.3.2-xtensa_sysdep-cancel.h.patch
Patch151: glibc-2.3.2-xtensa_tls.h.patch
Patch152: glibc-2.3.2-xtensa_missing_arg.patch
Patch153: glibc-2.3.2-xtensa_ptrace.h.patch
Patch154: glibc-2.3.2-xtensa_dl-machine.h.patch
Patch155: glibc-2.3.2-xtensa-noerrno.patch
Patch156: glibc-2.2.5-xtensa_setjmp.patch
Patch157: glibc-2.2.5_xtensa_hal.patch
Patch158: glibc-2.2.5-xtensa_syscall.patch
Patch159: glibc-2.2.5-xtensa_cleanup.patch
Patch160: glibc-2.2.5-xtensa_segfault.patch
Patch161: glibc-2.2.5-xtensa_ipc.patch
Patch162: glibc-2.2.5-xtensa_nosyscall.patch
#Patch163: glibc-2.3.2-xtensa_getresuid_etc.patch
Patch164: glibc-2.2.5-xtensa_profil.patch
Patch165: glibc-2.3.2-ppc_options.patch
Patch166: glibc-2.3.2-xtensa_msq.h.patch
Patch167: glibc-2.3.2-xtensa_missing_files.patch

Patch170: mvl-glibc-2.3.2-iwmmxt-stat.patch
Patch171: mvl-glibc-2.3.2-iwmmxt-stack.patch
Patch172: mvl-glibc-2.3.2-iwmmxt-mmap.patch
Patch173: mvl-glibc-2.3.2-iwmmxt-vfp.patch
Patch174: mvl-glibc-2.3.2-sem_timedwait.patch
Patch175: glibc-2.3.2-ldt-overflow.patch
 
Patch180: glibc-2.3.2-thumb.patch
Patch181: glibc-2.3.2-arm-interwork-returns.patch
Patch182: glibc-2.3.2-thumb-syscall.patch
Patch183: glibc-2.3.2-thumb-dlsym.patch  
Patch184: glibc-2.3.2-ppc-fix-soft-float.patch
Patch185: glibc-2.3.2-arm-shm_h.patch

#Community patches
Patch200: glibc-2.3.2-no-rela.patch
Patch201: glibc-2.3.2-scanf.patch
Patch202: glibc-2.3.2-arm-cancel2.patch
#Patch203: glibc-2.3.2-ppc4xx.patch
#Patch204: glibc-2.3.2-ppc405.patch
#Patch205: glibc-2.3.2-ppc440.patch
Patch206: glibc-2.2.4-getgrouplist.patch
Patch207: glibc-2.3.2-ppc-spinlock.patch
Patch208: glibc-2.3.2-mips_sigevent.patch
Patch209: glibc-2.3.2-mips-msqid.patch
Patch210: glibc-2.3.2-getaddrinfo.patch
Patch211: glibc-2.3.2-signals.patch
Patch212: glibc-2.3.2-arm_vfork.patch

Patch213: glibc-2.3.2-pthreadcancel.patch
Patch214: glibc-2.3.2-malloc-deadlock.patch
Patch215: glibc-2.3.2-attribute-used.patch
Patch216: glibc-no_locale_archive.patch

# SPE support
Patch217: glibc-2.3.2-spe-configure.patch
Patch218: glibc-2.3.2-spe-addon.patch

Patch219: glibc-2.3.2-scanfproblem.patch
Patch220: glibc-context-ppc.patch
Patch221: glibc-2.3.2-popen-fork.patch
Patch222: glibc-2.3.2-static-atfork.patch
Patch223: glibc-2.3.2-add_ipv6_v6only_option.patch

Patch1000: hhl-glibc-regenerate-configure.patch
Patch1001: glibc-2.3.2-disable-sanity.patch
Patch1002: glibc-2.3.2-arm-gmon.patch
Patch1003: glibc-x86_bt_syscall.patch
Patch1004: glibc-pthread-exit.patch
Patch1005: glibc-flush-io-locks.patch

Patch1006: glibc-ppc-context.patch
Patch1007: glibc-x86-sysdep-cancel.patch
Patch1008: glibc-f1-timezone-update.patch


License: LGPL/BSD
Group: devel
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
%define _docdir          %{_hhl_cross_target_dir}/%{_hhl_target_doc_dir}
BuildRequires: kernel-headers
BuildRequires: cross-%{_hhl_target_arch}-libopt
Provides: /sbin/ldconfig
Obsoletes: hhl-%{_hhl_target_arch}-glibc

%description
The standard libraries that are used by nearly all programs on the system.
This package includes shared versions of the standard C library and the
standard math library, as well as many others. Timezone data is also
included.

# glibc
%package -n glibc-dev
Summary: GNU C Library: Development Libraries and Header Files.
Group: devel
Requires: kernel-headers, glibc = %{version}
Obsoletes: glibc-bootstrap
Obsoletes: hhl-%{_hhl_target_arch}-glibc-dev

%description -n glibc-dev
Contains the symlinks, headers, and object files needed to compile
and link programs which use the standard C library. 

# glibc-prof
%package -n glibc-prof
Summary: GNU C Library: Profiling Libraries.
Group: devel
Requires: glibc = %{version}
Obsoletes: hhl-%{_hhl_target_arch}-glibc-prof

%description -n glibc-prof
Static libraries compiled with profiling info (-pg) suitable for use
with gprof.  

# glibc-pic
%package -n glibc-pic
Summary: GNU C Library: PIC archive library
Group: devel
Requires: glibc = %{version}
Obsoletes: hhl-%{_hhl_target_arch}-glibc-pic

%description -n glibc-pic
Contains an archive library (ar file) composed of individual shared objects.
This is used for creating a library which is a smaller subset of the
standard libc shared library.

# glibc-libopt
%package -n glibc-libopt
Summary: GNU C Library: Library Optimizer information
Group: devel
Requires: glibc = %{version}
Obsoletes: hhl-%{_hhl_target_arch}-glibc-libopt

%description -n glibc-libopt
Contains information for the Library Optimizer Tool.
This is used for creating libraries which are a smaller subset of the
standard shared libraries.

# glibc-locales
%package -n glibc-locales
Summary: GNU C Library: National Language (locale) data [support]
Group: admin
Obsoletes: hhl-%{_hhl_target_arch}-glibc-locales

%description -n glibc-locales
Machine-readable data files, shared objects and programs used by the
C library for localization (l10n) and internationalization
(i18n) support.

This package contains the libc.mo i18n files, plus tools to generate
locale definitions from the i18ndata package. It allows you to customize
which definitions actually get generated.

# glibc-i18ndata
%package -n glibc-i18ndata
Summary: GNU C Library: National Language (locale) data [source]
Group: admin
Obsoletes: hhl-%{_hhl_target_arch}-glibc-i18ndata

%description -n glibc-i18ndata
Machine-readable data files used by the C library
for localization and internationalization support.

This package contains uncompiled source data for locales. To compile
locale definitions, you must have the `locales' package as well.

# glibc-nscd
%package -n glibc-nscd
Summary: GNU C Library: Name Service Cache Daemon
Group: admin
Requires: glibc = %{version}
Obsoletes: hhl-%{_hhl_target_arch}-glibc-nscd

%description -n glibc-nscd
A daemon which handles passwd and group lookups
for running programs and caches the results for the next
query. You should install this package only if you use
slow Services like LDAP, NIS or NIS+.

# glibc-doc
%package -n glibc-doc
Summary: GNU C Library: Documentation
Group: doc
Obsoletes: hhl-%{_hhl_target_arch}-glibc-doc

%description -n glibc-doc
Contains The GNU C Library Reference manual in info format as well as man
pages for libpthread functions. Also included is the complete GNU C Library
ChangeLog.

%prep
%target_check
%setup -n glibc-%{version} -q -a 1

# Tensilica Xtensa support
%if "%{_hhl_target_arch}" == "xtensa_linux_be"
tar -xf  %{SOURCE4}
%endif
%if "%{_hhl_target_arch}" == "xtensa_linux_le"
tar -xf  %{SOURCE5}
%endif
%if "%{_hhl_target_arch}" == "xtensa_linux_test"
tar -xf  %{SOURCE6}
%endif

%patch1 -p0
%patch3 -p0
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p0
%patch8 -p1
%patch9 -p1
%patch10 -p1

# Add optimized memcpy for ARM
%patch75 -p1

# Force no-unit-at-a-time
%patch76 -p1

# Cross RPC patches
%patch100 -p1

%patch101 -E -p1

# PPC 405 Errata 77 Fix
%if "%{_hhl_target_arch}" == "ppc_405"
%patch102 -p1
%endif

%patch103 -p1
%patch104 -p1
%patch105 -p1
%patch106 -p1
%patch107 -p1
%patch108 -p1
%patch109 -p1
%patch110 -p1
%patch111 -p1
%patch112 -p1
%patch113 -p1
%patch114 -p1
%patch115 -p1
%patch116 -p1
%patch117 -p1
%patch118 -p1
#%patch119 -p1
%patch120 -p1
%patch121 -p1
%patch122 -p1
%patch123 -p1
%patch124 -p1
%patch125 -p1
%patch126 -p1
%patch128 -p1
%patch129 -p1
%patch130 -p1
%patch131 -p1

# SH4 syscall fix
%if "%{_hhl_target_arch}" == "sh_sh4_le" || "%{_hhl_target_arch}" == "sh_sh4_be"
%patch132 -p1
%endif

%patch133 -p1
%patch134 -p1
%patch135 -p1
%patch136 -p1
%patch137 -p1
#%patch138 -p1
%patch139 -p1
%patch140 -p1
%patch141 -p1
%patch143 -p1

%if "%{_hhl_target_arch}" != "xtensa_linux_le" && "%{_hhl_target_arch}" != "xtensa_linux_be" && "%{_hhl_target_arch}" != "xtensa_linux_test"
%patch144 -p1
%endif

%patch145 -p1
%patch146 -p1
%patch147 -p1

# Xtensa patches
%patch149 -p1
%patch150 -p1
%patch151 -p1
%patch152 -p1
%patch153 -p1
%patch154 -p1
%patch155 -p1
%patch156 -p0
%patch157 -p1
%patch158 -p1
%patch159 -p1
%patch160 -p1
%patch161 -p1
%patch162 -p1
#%patch163 -p1
%patch164 -p1
%patch165 -p1
%patch166 -p1
%patch167 -p1

%patch170 -p1
%patch171 -p1
%patch172 -p1
%patch173 -p1
%patch174 -p1
%patch175 -p1

%patch180 -p1
%patch181 -p1
%patch182 -p1
%patch183 -p1

%if "%{_hhl_target_arch}" == "ppc_405" || "%{_hhl_target_arch}" == "ppc_440" || "%{_hhl_target_arch}" == "ppc_8xx"
%patch184 -p1
%endif

%if "%{_hhl_target_arch}" == "ppc_405" || "%{_hhl_target_arch}" == "ppc_440" || "%{_hhl_target_arch}" == "ppc_8xx"
%define _hhl_target_fpu no
%endif

%patch185 -p1

%patch200 -p1
%patch201 -p1
%patch202 -p1

# PPC 4xx routines from IBM
#%if "%{_hhl_target_arch}" == "ppc_405"
#%patch203 -p1
#%patch204 -p1
#%endif
#%if "%{_hhl_target_arch}" == "ppc_440"
#%patch203 -p1
#%patch205 -p1
#%endif

%patch206 -p1
%patch207 -p1
%patch208 -p0
%patch209 -p1
%patch210 -p1
%patch211 -p1
%patch212 -p1

# Xtensa does not define INTERNAL_SYSCALL. We should not apply this patch 
%if "%{_hhl_target_arch}" != "xtensa_linux_le" && "%{_hhl_target_arch}" != "xtensa_linux_be" && "%{_hhl_target_arch}" != "xtensa_linux_test"
%patch213 -p1
%endif

%patch214 -p1
%patch215 -p1
%patch216 -p1

%patch217 -p1
%patch218 -p1
%patch219 -p1
%patch220 -p1
%patch221 -p1
%patch222 -p1
%patch223 -p1

%patch1000 -p1
%patch1002 -p1
%patch1003 -p1
%patch1004 -p1
%patch1005 -p1

%patch1006 -p1
%patch1007 -p1
%patch1008 -p1


# For glibc-bootstrap only.
%patch1001 -p1

# This file used to assume a 32-byte cache line; therefore it didn't work
# on 8xx or 403 (which have 16-byte cache lines).  That was fixed, but now
# it triggers a hardware bug on the MPC860.  Disable it for ppc_8xx.
%if "%{_hhl_target_arch}" == "ppc_8xx"
  rm sysdeps/powerpc/powerpc32/memset.S
%endif

%build

# Needed for GCC 3.1
# The choice of inline limit is arbitrary but it must be high enough
# for all of the early relocation functions to be inlined.  Debian/SPARC
# uses 3000, which also works for MIPS, but SH needs more.
export CFLAGS='-g -O2 -finline-limit-10000'

%target_setup

touch configure

# Things configure will get wrong:
#  - ac_tool_prefix=mipsel-hardhat-linux instead of mips_fp_le
#    (we override the only thing this is used for anyway)
#  - CPP=/lib/cpp instead of %{_hhl_target_toolprefix}gcc -E
#    when bootstrapping, because no <assert.h> exists for the
#    target.  No harm done, since it never invokes $(CPP) anyway.
ac_cv_prog_cc_works=no
export ac_cv_prog_cc_works
ac_cv_prog_cc_cross=yes
export ac_cv_prog_cc_cross

# This test relies on -lgcc_eh, which isn't built yet for gcc-bootstrap.
# The value is verified correct for ARM, MIPS, x86, SH, PowerPC.
libc_cv_gcc_dwarf2_unwind_info=no_registry_needed

# This test links to -lc.  Which isn't built yet, of course.
libc_cv_asm_set_directive=yes

# Unforunately, glibc's configure script tries to locate perl in $PATH
# and then run it.  Force it to pick up the right location.
export PERL=/usr/bin/perl

AddOns=
%if "%{_hhl_target_arch}" == "ppc_85xx"
AddOns="$AddOns,spe"
%endif

cat > build.log <<-EOF
%target_tool_configure \
	--libexecdir=%{_hhl_target_lib_dir} \
	--build=%{_hhl_host_config} \
	--enable-add-ons=linuxthreads$AddOns \
	--without-cvs \
	--enable-kernel=2.4.17 \
%if "%{_hhl_target_cpu_type}" == "xtensa"
	--with-cpu=%{_hhl_target_cpu_id} \
%endif
%if "%{_hhl_target_fpu}" == "no"
	--without-fp \
%endif
%if "%{_hhl_target_altivec}" == "yes"
	--with-altivec=default
%endif

EOF

%target_tool_configure \
	--libexecdir=%{_hhl_target_lib_dir} \
	--build=%{_hhl_host_config} \
	--enable-add-ons=linuxthreads$AddOns \
	--without-cvs \
	--enable-kernel=2.4.17 \
%if "%{_hhl_target_cpu_type}" == "xtensa"
	--with-cpu=%{_hhl_target_cpu_id} \
%endif
%if "%{_hhl_target_fpu}" == "no"
	--without-fp \
%endif
%if "%{_hhl_target_altivec}" == "yes"
	--with-altivec=default \
%endif
	2>&1 | tee -a ../build.log

%dmake	2>&1 | tee -a ../build.log

%make -C ../linuxthreads/man all

#if cross compiling....
cd ..
mkdir -p LOCALOBJDIR
cd LOCALOBJDIR
cp -a ../timezone/* .
tar xvfz %{SOURCE10}
# Because the make file expects it...
cp yearistype yearistype.sh
%make 2>&1 | tee -a ../build.log
#endif cross compiling....

%install
%target_setup
rm -rf %{buildroot}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}

cd %{_objdir}
%make install_root=%{buildroot}%{_hhl_cross_target_dir} \
	install 2>&1 | tee -a ../build.log

%if "%{_hhl_target_cpu_type}" == "x86"
%make install_root=%{buildroot}%{_hhl_cross_target_dir} \
        objdir=`pwd` -C ../localedata install-locales   \
        2>&1 | tee -a ../build.log
%endif

(cd ../manual && makeinfo --html libc.texinfo)

mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/default

# nsswitch.conf
install -m 644 %{SOURCE20} %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/.
# host.conf
install -m 644 %{SOURCE21} %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/.
# Should this still be in the glibc package?
install -m 755 %{SOURCE34} %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/default/devpts

install -m 755 %{SOURCE35} %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/nscd
install -m 755 %{SOURCE36} %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/.

cd ..

#if cross compiling....
cd LOCALOBJDIR
( export TZBASE="africa antarctica asia australasia europe northamerica southamerica etcetera factory solar87 solar88 solar89 backward systemv"
./zic -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/zoneinfo/right/ -L leapseconds -y yearistype $TZBASE 
./zic -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/zoneinfo/posix/ -L /dev/null -y yearistype $TZBASE 
./zic -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/zoneinfo/ -L /dev/null -y yearistype $TZBASE 
cp %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/zoneinfo/America/New_York %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/zoneinfo/posixrules
)
cd ..
#endif

# Fix up libc.so to use relative paths.  Also fix up brain damage in
# generating libc.so.  There's a 34-line sed script responsible for this
# mess.  It works fine with no OUTPUT_FORMAT.
for file in libc.so libpthread.so; do
  cat %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/$file \
	| sed 's# /[^ ]*/lib# lib#g' \
	| grep -v 'BUG in libc' \
	> %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/$file~
  mv -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/$file~ \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/$file
done

# Install libc_pic in the correct location
cd %{_objdir}
mkdir -p           %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic

install -m 644 libc_pic.a      %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/.
install -m 644 libc.map        %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic.map

install -m 644 elf/soinit.os   %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic/soinit.o
install -m 644 elf/sofini.os   %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic/sofini.o

install -m 644 elf/interp.os   %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic/interp.o

install -m 644 math/libm_pic.a %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/.
install -m 644 libm.map        %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libm_pic.map

install -m 644 resolv/libresolv_pic.a %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/.
install -m 644 libresolv.map   %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libresolv_pic.map

install -m 644 linuxthreads/libpthread_pic.a %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/.
install -m 644 libpthread.map %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpthread_pic.map

# Set Library Optimizer variables
%define _optdir %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/optinfo
OBJECTDIR=`/bin/pwd`

# Install Library Optimizer information (libc)
install -d -m 755 %{_optdir}/libc
install -m 755 %{SOURCE22} %{_optdir}/libc/build
install -m 644 libc.map %{_optdir}/libc/libc.map
install -m 644 libc.so.lds %{_optdir}/libc/libc.so.lds
install -m 644 csu/abi-note.o %{_optdir}/libc/abi-note.o
install -m 644 elf/soinit.os %{_optdir}/libc/soinit.o
install -m 644 elf/sofini.os %{_optdir}/libc/sofini.o
install -m 644 elf/interp.os %{_optdir}/libc/interp.o
(cd %{_optdir}/libc; umask 022; %{_hhl_target_toolprefix}ar x $OBJECTDIR/libc_pic.a)
(cd %{_optdir}/libc; umask 022; %{_hhl_target_toolprefix}libindex $OBJECTDIR/libc.so -r *.o -o *.os > index)
(umask 022; echo "/lib/libc-"%{version}".so" > %{_optdir}/libc/path)

# Install Library Optimizer information (libm)
install -d -m 755 %{_optdir}/libm
install -m 755 %{SOURCE23} %{_optdir}/libm/build
install -m 644 libm.map %{_optdir}/libm/libm.map
install -m 644 math/libm.so.lds %{_optdir}/libm/libm.so.lds
install -m 644 csu/abi-note.o %{_optdir}/libm/abi-note.o
install -m 644 elf/interp.os %{_optdir}/libm/interp.o
install -m 644 libc_nonshared.a %{_optdir}/libm/libc_nonshared.a
(cd %{_optdir}/libm; umask 022; %{_hhl_target_toolprefix}ar x $OBJECTDIR/math/libm_pic.a)
(cd %{_optdir}/libm; umask 022; %{_hhl_target_toolprefix}libindex $OBJECTDIR/math/libm.so -r *.o -o *.os > index)
(umask 022; echo "/lib/libm-"%{version}".so" > %{_optdir}/libm/path)

mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}
mv %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/locale/locale.alias %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/locale.alias
ln -s ../../..%{_hhl_target_sysconf_dir}/locale.alias %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/locale/locale.alias
cd ..

mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3
install -m 644 linuxthreads/man/*.3thr %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/.

install -m 644 nscd/nscd.conf %{buildroot}%{_hhl_cross_target_dir}/etc/nscd.conf

# RPM is on crack..  We need to "prepare" the doc files..
cp -pr linuxthreads/ChangeLog ChangeLog.linuxthreads
cp -pr linuxthreads/Changes Changes.linuxthreads
cp -pr linuxthreads/LICENSE LICENSE.linuxthreads
cp -pr linuxthreads/README README.linuxthreads
cp -pr linuxthreads/FAQ.html FAQ.threads.html
cp -pr localedata/ChangeLog ChangeLog.localedata
cp -pr localedata/README README.localedata
cp -pr COPYING LICENSE

gzip -9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man*/*
gzip -9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_info_dir}/*

mv %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/zdump %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/
mv %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/rpcinfo %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE25} > glibc.pml
install -m 644 glibc.pml %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE26} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-dev
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE27} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-doc
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE28} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-i18ndata
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE29} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-libopt
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE30} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-locales
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE31} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-nscd
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE32} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-pic
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE33} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-prof


# This is complicated enough we need to build file lists....
# glibc file list generation follows
echo "%defattr(-,root,root)" > glibc.filelist

for i in `ls %{buildroot}%{_hhl_cross_target_dir}/lib/ld-%{version}.so | sed -e s,%{buildroot},,`; do
 echo "%attr(0755,root,root) $i" >> glibc.filelist
done

for i in `ls %{buildroot}%{_hhl_cross_target_dir}/lib/lib*-%{version}.so | sed -e s,%{buildroot},, | grep -v libc-%{version}.so`; do
 echo "%attr(0644,root,root) $i" >> glibc.filelist
done

echo "%attr(0755,root,root) %{_hhl_cross_target_dir}/lib/libc-%{version}.so" >> glibc.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}/lib/libSegFault.so" >> glibc.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}/lib/libpthread-0.10.so" >> glibc.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}/lib/libthread_db-1.0.so" >> glibc.filelist

for i in `find %{buildroot}%{_hhl_cross_target_dir}/lib/ -type l -name '*.so.*' ! -name 'libnss*_*.so.1*' | sed -e s,%{buildroot},,`; do
 echo "$i" >> glibc.filelist
done

echo "%dir %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/gconv" >> glibc.filelist
for i in `ls %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/gconv/* | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) $i" >> glibc.filelist
done

echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/getent" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/iconv" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/locale" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/localedef" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/catchsegv" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/glibcbug" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/tzselect" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/ldd" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/rpcgen" >> glibc.filelist

echo "%attr(0755,root,root) %{_hhl_cross_target_dir}/sbin/ldconfig" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}/sbin/sln" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/zdump" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/rpcinfo" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/zic" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/tzconfig" >> glibc.filelist
echo "%attr(4755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pt_chown" >> glibc.filelist

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/zoneinfo -type d | sed -e s,%{buildroot},,`; do
 echo "%dir $i" >> glibc.filelist
done
for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/zoneinfo/ ! -type d | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) $i" >> glibc.filelist
done

echo "%attr(0644,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/nsswitch.conf" >> glibc.filelist
echo "%attr(0644,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/host.conf" >> glibc.filelist

echo "%attr(0755,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/default/devpts" >> glibc.filelist
# Moved to the sysvinit package
#echo "%attr(0755,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/devpts.sh" >> glibc.filelist

echo "%attr(0644,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/rpc" >> glibc.filelist

# glibc-dev file list follows
echo "%defattr(-,root,root)" > glibc-dev.filelist

echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/gencat" >> glibc-dev.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/getconf" >> glibc-dev.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/mtrace" >> glibc-dev.filelist

echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/pcprofiledump" >> glibc-dev.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/xtrace" >> glibc-dev.filelist

echo "%attr(0644,root,root) %{_hhl_cross_target_dir}/lib/libmemusage.so" >> glibc-dev.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}/lib/libpcprofile.so" >> glibc-dev.filelist

for i in `ls %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/*.o | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) $i" >> glibc-dev.filelist
done

for i in `ls %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/*.a | sed -e 's,%{buildroot},,;/^.*_.\.a$/d;/^.*_pic.a/d'`; do
 echo "%attr(0644,root,root) $i" >> glibc-dev.filelist
done

echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc.so" >> glibc-dev.filelist

for i in `ls %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/lib*.so | sed -e s,%{buildroot},,`; do
 case "$i" in \
 *-%{version}.so | *-0.[789].so ) ;; \
 */libSegFault.so) ;; \
 */libc.so ) ;; \
 *) echo $i >> glibc-dev.filelist;; \
 esac
done
# Unlike debian we _WANT_ our links relative!

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_include_dir} -type d | sed -e s,%{buildroot},,`; do
 echo "%dir $i" >> glibc-dev.filelist
done

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_include_dir} ! -type d | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) $i" >> glibc-dev.filelist
done

# glibc-prof file list follows
echo "%defattr(-,root,root)" > glibc-prof.filelist

for i in `ls %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/*_p.a | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) $i" >> glibc-prof.filelist
done 

echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/sprof" >> glibc-prof.filelist

# glibc-pic file list follows
echo "%defattr(-,root,root)" > glibc-pic.filelist

echo "%dir %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic" >> glibc-pic.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic.a" >> glibc-pic.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic.map" >> glibc-pic.filelist

echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic/soinit.o" >> glibc-pic.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic/sofini.o" >> glibc-pic.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic/interp.o" >> glibc-pic.filelist

echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libm_pic.a" >> glibc-pic.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libm_pic.map" >> glibc-pic.filelist

echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libresolv_pic.a" >> glibc-pic.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libresolv_pic.map" >> glibc-pic.filelist

echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpthread_pic.a" >> glibc-pic.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpthread_pic.map" >> glibc-pic.filelist

# glibc-locales file list follows
echo "%defattr(-,root,root)" > glibc-locales.filelist

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/locale -type d | sed -e s,%{buildroot},,`; do
 echo "%dir $i" >> glibc-locales.filelist
done

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/locale ! -type d | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) $i" >> glibc-locales.filelist
done

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/locale -type d | sed -e s,%{buildroot},,`; do
 echo "%dir $i" >> glibc-locales.filelist
done

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/locale ! -type d | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) $i" >> glibc-locales.filelist
done

echo "%attr(0644,root,root) %config %{_hhl_cross_target_dir}/etc/locale.alias" >> glibc-locales.filelist

# glibc-i18ndata file list follows
echo "%defattr(-,root,root)" > glibc-i18ndata.filelist

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/i18n -type d | sed -e s,%{buildroot},,`; do
 echo "%dir $i" >> glibc-i18ndata.filelist
done

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/i18n ! -type d | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) $i" >> glibc-i18ndata.filelist
done

# glibc-nscd file list follows
echo "%defattr(-,root,root)" > glibc-nscd.filelist

echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/nscd" >> glibc-nscd.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/nscd_nischeck" >> glibc-nscd.filelist
echo "%attr(0644,root,root) %config %{_hhl_cross_target_dir}/etc/nscd.conf" >> glibc-nscd.filelist
echo "%attr(0755,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/nscd" >> glibc.filelist

# glibc-doc file list follows
echo "%defattr(-,root,root)" > glibc-doc.filelist

for i in `ls %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_info_dir}/*.info* | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) %doc $i" >> glibc-doc.filelist
done 

for i in `ls %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/* | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) %doc $i" >> glibc-doc.filelist
done

# Some versions of makeinfo generate one file ...
if [ -f manual/libc.html ]; then
  echo "%attr(0644,root,root) %doc manual/libc.html" >> glibc-doc.filelist
fi

# ... and others (4.x) generate a directory.
if [ -d manual/libc ]; then
  doc=%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}/glibc-doc
  if ! [ -d $doc ]; then mkdir -p $doc; fi
  mkdir $doc/html
  cp manual/libc/*.html $doc/html/
  for i in `ls $doc/html/* | sed -e s,%{buildroot},,`; do
     echo "%attr(0644,root,root) %doc $i" >> glibc-doc.filelist
  done
fi

%clean
rm -rf %{buildroot}

#post -n glibc
#target_script_prefix_setup
# Register the service
#({_hhl_target_toolprefix}initdconfig --add devpts.sh) &> /dev/null \
#        || echo "Unable to enable initd service: devpts.sh"
#
# We only register services, not un-register them.

%files -n glibc -f glibc.filelist
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc
%doc BUGS FAQ INSTALL INTERFACE NEWS NOTES PROJECTS README CONFORMANCE 
%doc COPYING COPYING.LIB hesiod/README.hesiod ChangeLog*
%doc Changes.linuxthreads LICENSE.linuxthreads README.linuxthreads
%doc LICENSE

%files -n glibc-dev -f glibc-dev.filelist
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-dev
%doc LICENSE

%files -n glibc-prof -f glibc-prof.filelist
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-prof
%doc LICENSE

%files -n glibc-pic -f glibc-pic.filelist
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-pic
%doc LICENSE

%files -n glibc-libopt
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/optinfo/libc
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/optinfo/libm
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-libopt
%doc LICENSE

%files -n glibc-locales -f glibc-locales.filelist
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-locales
%doc ChangeLog.localedata README.localedata
%doc LICENSE

%files -n glibc-i18ndata -f glibc-i18ndata.filelist
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-i18ndata
%doc LICENSE

%files -n glibc-nscd -f glibc-nscd.filelist
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-nscd
%doc LICENSE

%files -n glibc-doc -f glibc-doc.filelist
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-doc
%doc manual/dir-add.info FAQ.threads.html
%doc LICENSE

%changelog
* Wed Feb 08 2006 Nitin Gupta <ngupta@mvista.com>
- Bug 12629: ppc_85xx has its own fpu instructions.
* Wed Nov 30 2005 Qunying Pan <qpan@mvista.com>
- Bug 16018: Combine US daylight saving and leap second patch.  
* Fri Oct 28 2005 Qunying Pan <qpan@mvista.com>
- Bug 15446: Update northamerica timezone file to include the latest Daylight Savings.
* Fri Oct 28 2005 Qunying Pan <qpan@mvista.com>
- Bug 15445: Add leap second event scheduled for 12/31/2005
* Tue Jul  5 2005 Dinar Temirbulatov 2.3.2-25.0.31
- Fix 13249 pthread_cancel_type issue in libc fclose() call.
* Fri Jun 10 2005 Dinar Temirbulatov 2.3.2-25.0.30
- Fix 12629 fpu instructions in fpuless glibc for targets ppc_440,ppc_405,ppc_8xx
* Fri Jun 3 2005 Nora Pan <qpan@mvista.com> 2.3.2-25.0.29
- on behalf of Dinar
- Fix 12040: diff and cmp dump core
* Thu May 5 2005 Khem Raj <kraj@mvista.com> 2.3.2-25.0.28
- Fix 11235: Backport: Do not use locking when flushing the buffers.
* Wed Apr 20 2005 Nora Pan <qpan@mvista.com> 2.3.2-25.0.27
- Bug 11239: update patch name glibc-pthread-exit-11239.patch to glibc-pthread-exit.patch
* Mon Apr 18 2005 Nora Pan <qpan@mvista.com> 2.3.2-25.0.26
- On behalf of Daniel Jacobowitz
- Bug 11239: Fix the thread hang if it is already suspended and receives SIGSEGV.
* Thu Apr 14 2005 Ranjani Cudavalli <rcudavalli@mvista.com> 2.3.2-25.0.25
- Fix 11330 - Pulling back 5863 patch due to performance issues.
* Fri Apr 01 2005 Ranjani Cudavalli <rcudavalli@mvista.com> 2.3.2-25.0.24
- Fix 10989 - Enabling arm_memcpy patch.
* Wed Mar 9 2005 Nora Pan <qpan@mvista.com> 2.3.2-25.0.23
- On behalf of Daniel Jacobowitz
- Bug 10555: Fix system call backtrace failure in x86.
* Tue Feb 15 2005 Grigory Tolstolytkin <gtolstolytkin@ru.mvista.com> 2.3.2-25.0.22
- Bug 10154: Add an arm-specific "shm.h" header file and increase SHMLBA value
* Tue Feb 08 2005 Grigory Tolstolytkin <gtolstolytkin@ru.mvista.com> 2.3.2-25.0.21
- Bug 7084: Add missing headers under "include/bits" directory to the glibc.tmpl
* Mon Feb 07 2005 Nora Pan <qpan@mvista.com> 2.3.2-25.0.20
- Bug 9825: header files update for xtensa
* Fri Feb 04 2005 Grigory Tolstolytkin <gtolstolytkin@ru.mvista.com> 2.3.2-25.0.19
- Bug 8033: Add IPV6_V6ONLY option
* Tue Jan 25 2005 Gilbert Coville <gilbert@mvista.com> 2.3.2-25.0.18
- On behalf of Daniel Jacobowitz of CodeSourcery
- Bug 9143: Return an error when we run out of LDT entries.
* Tue Jan 25 2005 Gilbert Coville <gilbert@mvista.com> 2.3.2-25.0.17
- On behalf of Daniel Jacobowitz of CodeSourcery
- Bug 9253: add pthread_atfork to libpthread-routines and static
* Tue Jan 11 2005 Nora Pan <qpan@mvista.com> 2.3.2-25.0.16
- Fix 9259 - Provide /usr/bin/rpcinfo in glibc pml file.
* Wed Dec 08 2004 Gilbert Coville <gilbert@mvista.com> 2.3.2-25.0.15
- added O_STREAMING to bits/fcntl.h
* Wed Dec 01 2004 Grigory Tolstolytkin <gtolstolytkin@ru.mvista.com> 2.3.2-25.0.14
- Remove some floating point symbols for ppc targets
* Mon Nov 29 2004 Daniel Jacobowitz <dan@codesourcery.com> 2.3.2-25.0.13
- Merge Thumb support to Foundation One.
* Wed Nov 17 2004 Grigory Tolstolytkin <gtolstolytkin@ru.mvista.com> 2.3.2-25.0.12
- Fix 8468 - Use fork() instead of vfork() in popen()
* Sat Nov 06 2004 Grigory Tolstolytkin <gtolstolytkin@ru.mvista.com> 2.3.2-25.0.11
- Fix 7784 - Modify sem_timedwait() function according to POSIX standard
* Fri Nov 05 2004 Sergey Samoylov <ssamoylov@ru.mvista.com> 2.3.2-25.0.10
- Fix 5018 - Added ges/set/make/swapcontext functions for powerpc32
* Mon Oct 25 2004 Sergey Samoylov <ssamoylov@ru.montavista.com> 2.3.2-25.0.9
- Fix 8111 - Fix problem when calling scanf with errno set to EINTR
* Tue Oct 12 2004 Daniel Jacobowitz <dan@codesourcery.com> 2.3.2-25.0.8
- Add PowerPC SPE support.
* Tue Sep 28 2004 Joe Green <jgreen@mvista.com>
- Build separate locale files instead of single locale-archive.
* Sat Sep 25 2004 Gilbert Coville <gilbert@mvista.com> 2.3.2-25.0.5
- w/ help from Daniel Jacobowitz and Mark Mitchell of CodeSourcery
- Fix 8428 - More changes of attribute unused to attribute used
* Mon Sep 13 2004 Nora Pan <qpan@mvista.com> 2.3.2-25.4
- Fix 7965 - Fix race condition at malloc by RT thread and fork by TSS thread.
* Wed Aug 25 2004 Ranjani Cudavalli <rcudavalli@mvista.com> 2.3.2-25.3
- Fix 7696 - When effective gid is changed saved gid also changes.
* Fri Aug 13 2004 Nora Pan <qpan@mvista.com>
- INTERNAL_SYSCALL is not defined in xtensa. Don't apply 5068 fix patch for it.
* Fri Aug 05 2004 Nora Pan <qpan@mvista.com>
- Fix 5068 - Avoid cancellation point at mutex lock.
* Thu Jul 29 2004 Ranjani Cudavalli <rcudavalli@mvista.com>
- Fix 7690 - Merge "foundation_one_async_branch" with  "foundation_one_branch".
* Fri Jul 9 2004 Ranjani Cudavalli <rcudavalli@mvista.com>
- Fix 7442 - Don't free internal buffer in vsyslog(). 
* Fri Jul 9 2004 Bill Johnson <bjohnson@mvista.com> 2.3.2-23.20
- Fix 6552 - Fix the incorrect pthread stack pointer checking.
* Fri Jun 25 2004 Ranjani Cudavalli <rcudavalli@mvista.com>
- Fix 5063 - sysconf(_SC_MONOTONIC_CLOCK) doesn't work properly.
* Mon Jun 21 2004 Ranjani Cudavalli <rcudavalli@mvista.com>
- Fix 5863 - Changes to /etc/localtime are not seen until restart.
* Wed May 5 2004 Michael Eager <eager@mvista.com>
- Fix 6476 - incorrect value for SIGRTMAX for arm.
* Tue Apr 6 2004 Michael Eager <eager@mvista.com>
- Fix 5750 - fix reg corruption in MIPS compare_and_swap.
* Tue Mar 30 2004 Michael Eager <eager@mvista.com>
- Fix Bug 5912 - race in signal handling.
* Thu Mar 18 2004 Michael Eager <eager@mvista.com>
- Fix 5847 - Arm vfork (hang in pthread)
* Wed Mar 10 2004 Michael Eager <eager@mvista.com>
- Fix 5750 - mips atomicity
- Remove getenv fix for 5422 -- decided it was incorrect.
* Fri Feb 20 2004 Michael Eager <eager@mvista.com>
- Fix Bugz 5422 - SEGV in getenv.
* Wed Feb 11 2004 Daniel Jacobowitz <drow@mvista.com> 2.3.2-22.10
- Improve mutex performance for targets without compare-and-swap.
* Wed Dec 17 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-22.9
- POSIX error handling fixes for signal routines.
* Mon Dec  8 2003 Corey Minyard <cminyard@mvista.com>
- Added a patch (from Debian) to fix tcsetattr and c-iflag LSB failures.
* Tue Oct 14 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-22.7
- Fix a bug in MIPS clone() which caused crashes after threads exited.
* Mon Oct 13 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-22.6
- Fix a bug in getaddrinfo which could cause stack overflow.
* Wed Oct 8 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-22.5
- Adjust <bits/msq.h> to match the MIPS kernel.
* Thu Oct 02 2003 Michael Eager <eager@mvista.com>
- MIPS kernel sigevent mismatch patch.
* Mon Sep 29 2003 Michael Eager <eager@mvista.com>
- Remove IBM PPC 405/440 patches.
* Mon Sep 29 2003 Daniel Jacobowitz  <drow@mvista.com> 2.3.2-22.2
- Fix pthread_spin_init for PowerPC.
* Tue Aug 26 2003 Michael Eager <eager@mvista.com>
- Add PPC 405 library routines from IBM.
* Fri Aug 22 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-21
- Fix a crash in getgrouplist with a large number of groups.
* Thu Aug 21 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-20
- Fix a profiling crash on MIPS.
* Tue Aug 19 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-19
- Fix a new thread debugging problem on ARM.
* Tue Aug 5 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-18
- Add ISV compat hooks.
- Improve ldd behavior for shared libraries.
* Wed Jul 30 2003 Michael Eager <eager@mvista.com>
- Enable PPC 440 lib routines from IBM.
* Mon Jul 28 2003 Michael Eager <eager@mvista.com>
- Defect 1-1RSAY - work around SH4 silicon bug for syscall.
* Mon Jul 28 2003 Michael Eager <eager@mvista.com>
- Add PPC 440 library routines from IBM.
* Wed Jul 16 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-14
- Remove SH pread patch to match a kernel change.
* Tue Jul 15 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-13
- Update SHMLBA for MIPS.
* Wed Jul 2 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-12
- Include <elcstd.h>.
* Mon Jun 23 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-11
- Provide /sbin/ldconfig, for target packages' benefit.
* Mon Jun 16 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-10
- Better diagnostics for prelink failure.
* Fri Jun 6 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-9
- Fix a thread leak when creating multiple timers.
* Wed Jun 4 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-8
- Fix arguments to pread/pwrite on SH.
- Fix <sys/procfs.h> on SH.
- Export __fpscr_values from libc.so.6 on SH.
* Wed May 28 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-7
- Another patch for the ARM cancellation wrappers, affecting static
  binaries only.
* Mon May 19 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-6
- Fix an incorrect clobber for ARM which gcc 3.3 complains about.
* Wed May 14 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-5
- Export __sim_* on PowerPC soft-float targets.
* Mon Apr 21 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-4
- SH doesn't have a 64-bit st_ino in the kernel interface yet.  There's
  room to add it, fortunately, but turn off the assumption for now.
* Mon Apr 14 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-3
- Fix the type of .bss sections in libc.so for ARM.
- Update ELF_MACHINE_NO_RELA patch to re-enable prelink support for ARM.
- Remove an outdated patch to the NSCD configuration file.
* Mon Mar 31 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-2
- Prevent garbled linker scripts due to gcc-bootstrap.
- Preset more variables that configure gets wrong.
- Update Altivec patch.
* Tue Mar 25 2003 Daniel Jacobowitz <drow@mvista.com> 2.3.2-1
- Update to glibc 2.3.2.
- Add patches to fix ARM and SH cancellation wrappers.
- Add --enable-kernel=2.4.17.
- Install libpthread_pic.a.
* Tue Mar 14 2003 Corey Minyard <cminyard@mvista.com>
- Fixed a bug with memory locking executables, env variables didn't work.
* Tue Mar 11 2003 Daniel Jacobowitz <drow@mvista.com> 2.2.5-35
- Add profiling support for the SH architecture.
* Thu Mar 6 2003 Daniel Jacobowitz <drow@mvista.com> 2.2.5-34
- Add the missing O_DIRECT flag on PowerPC.
* Tue Feb 25 2003 Daniel Jacobowitz <drow@mvista.com> 2.2.5-33
- Fix a memory leak in libresolv.
- Force $PERL to /usr/bin/perl.
* Tue Feb 4 2003 Michael Eager <eager@mvista.com>
- Fix memory alignment problem in Xtensa
* Mon Jan 20 2003 Michael Eager <eager@mvista.com>
- Include corebits.h in xtensa build.
* Mon Jan 20 2003 Michael Eager <eager@mvista.com>
- Add Xtensa patches for strlen and memcpy.
* Fri Jan 17 2003 Michael Eager <eager@mvista.com>
- Generate locales for X86
* Tue Jan 14 2003 Michael Eager <eager@mvista.com>
- Eliminate divide in elf_dynamic_do_rel for Xtensa.
* Thu Jan 9 2003 Daniel Jacobowitz <drow@mvista.com>
- Two LSB compliance patches: nice and Euro locales.
* Wed Dec 11 2002 Daniel Jacobowitz <drow@mvista.com>
- Update scheduler affinity patch to export symbols with the correct
  versions.
* Fri Dec 6 2002 John Kwan <jkwan@mvista.com>
- Use a more recent glibc common patch for xtensa
* Thu Nov 14 2002 John Kwan <jkwan@mvista.com>
- Move patch36 from under xtensa only test
* Wed Nov 13 2002 John Kwan <jkwan@mvista.com>
- Update xtensa build to use glibc 2.2.5.
* Mon Nov  4 2002 Daniel Jacobowitz <drow@mvista.com>
- Add backwards compatibility symbols for ppc_8xx.
- Remove another bashism from the .spec file.
* Tue Oct 29 2002 Daniel Jacobowitz <drow@mvista.com>
- Disable memset.S on ppc_8xx again.
* Wed Oct 16 2002 jkwan <jkwan@mvista.com>
- Add support for xtensa_linux_test build
* Sat Oct 12 2002 Daniel Jacobowitz <drow@mvista.com>
- Re-add a MIPS thread debugging patch.
- Add vfork() for MIPS
* Wed Oct  9 2002 Daniel Jacobowitz <drow@mvista.com>
- Allow backtraces from __vfork.
- DWARF-2 debugging information for assembly source.
* Thu Sep 26 2002 jkwan <jkwan@mvista.com>
- Replace xtensa-be/le patches with tar files
* Fri Sep 20 2002 Michael Eager <eager@mvista.com>
- Update Xtensa patch for glibc-2.2.5
* Fri Sep 20 2002 Daniel Jacobowitz <drow@mvista.com>
- Add some patches from glibc CVS.
* Mon Sep 16 2002 Daniel Jacobowitz <drow@mvista.com>
- Add a binary compatibility patch for SH4.
* Tue Aug 27 2002 Daniel Jacobowitz <drow@mvista.com>
- Add scheduler affinity syscalls.
* Sun Aug 25 2002 Daniel Jacobowitz <drow@mvista.com>
- Use %target_tool_configure.
* Wed Aug 21 2002 Daniel Jacobowitz <drow@mvista.com>
- Specify "-finline-limit-10000" to make SH and ARM fit inside the limit.
* Mon Aug 12 2002 Daniel Jacobowitz <drow@mvista.com>
- Fix register dumps for MIPS targets
* Thu Aug 8 2002 John Kwan <jkwan@mvista.com>
- Add a patch to signal.h for ia64
* Mon Aug  5 2002 Daniel Jacobowitz <drow@mvista.com>
- Add patch for sysconf CPU count
- Fix an ARM bug reported by GCC 3.1.1
* Thu Aug  1 2002 Daniel Jacobowitz <drow@mvista.com>
- Build static libthread_db
- Specify "-finline-limit-3000" to work around inlining problems on GCC
  3.1/MIPS.
* Fri Jul 26 2002 Michael Eager <eager@mvista.com>
- Mips nfp setjmp/longjmp patch.
* Wed Jul 24 2002 Daniel Jacobowitz <drow@mvista.com>
- Merge memory locking patch
* Fri Jul 19 2002 Daniel Jacobowitz <drow@mvista.com>
- Move forward patches from previous glibc releases and glibc CVS.
- Moved to glibc 2.2.5
* Fri May 10 2002 Daniel Jacobowitz <drow@mvista.com>
- Fix a setjmp/longjmp bug on PowerPC 74xx.
* Sat May  4 2002 Corey Minyard <cminyard@mvista.com>
- Added the ability to lock executables in memory.
* Thu Mar  7 2002 Daniel Jacobowitz <drow@mvista.com>
- Fix defect 1-L3ST - MIPS thread debugging
* Thu Feb 28 2002 Michael Eager <eager@mvista.com>
- Fix defect 1-KM1X -- use _hhl_target_include_dir not _includedir
* Fri Jan 18 2002 Michael Eager <eager@mvista.com>
- Change to make localdata/install-locales
* Fri Dec  7 2001 Michael Eager <eager@mvista.com>
- Tensilica Xtensa LinuxBE configuration support.
* Mon Oct 29 2001 Michael Eager <eager@mvista.com>
- Intel StrongArm Big Endian patch
* Fri Sep 07 2001 Michael Eager <eager@mvista.com>
- Convert to use target_tool_configure.
* Thu Aug 16 2001 Joe Green <source@mvista.com>
- Added hhl-glibc-save-lds.patch to keep linker scripts for library optimizer.
- Installed abi-note.o and libc.so.lds for use by library optimizer.

* Mon Jul 20 2001 Mark Hatle <source@mvista.com>
- Moved to 2.2.3 release
- Restructures the sources/patches to be pulled from the Debian patch
  instead of individual patches.
- Renamed all MontaVista patches to include "hhl" in their names
- Removed the glibc-223pre1-fe_invalid.patch, glibc-mips-abi.patch,
  and glibc22-27.patch patches.  (No longer needed)

* Mon Jun 25 2001 Daniel Jacobowitz <source@mvista.com>
- Add workaround for ppc_405 atomic store issues.

* Fri May 25 2001 Daniel Jacobowitz <source@mvista.com>
- Add patch to fix mips rt_sigqueueinfo.

* Fri May 04 2001 Steve Kinneberg <source@mvista.com>
- Added TCT package description files for building.

* Sun Mar 18 2001 Joe Green <source@mvista.com>
- Added Library Optimizer information package for libc.

* Thu Feb 22 2001 Mark Hatle <source@mvista.com>
- Removed the db2 add-on stuff.  Its only for legacy and we don't have 
- any! <grin>

* Wed Jan 24 2001 Mark Hatle <source@mvista.com>
- Added missing rpc files
- Added sln
- Added /usr/lib/libthread_db.so
- Added /usr/lib/libdb.so

* Mon Jan 22 2001 Mark Hatle <fray@mvista.com>
- Initial push into repository
- Cross-compiling checks are still TODO

* Sat Dec 09 2000 Mark Hatle <fray@mvista.com>
- First cut

