%define libmaj 0
%define libmin 9
%define librel 7
%define librev b
Release: 3.0.0.%{_hhl_build_id}

%define openssldir %{_hhl_target_lib_dir}/ssl

Summary: Secure Sockets Layer and cryptography libraries and tools
Name: openssl
Version: %{libmaj}.%{libmin}.%{librel}%{librev}
Source0: openssl_%{version}.orig.tar.gz
Source1: openssl.tmpl
Source2: openssl-dev.tmpl
Patch: openssl_%{version}-2.diff.gz
Patch1: openssl-mvl-arch.diff
Patch2: mvl-openssl-xtensa.patch
Patch3: openssl-gzman.patch
Patch4: openssl-CAN-2003-0545.diff
Patch5: openssl-CAN-2004-0079.diff
Patch6: openssl-CAN-2004-0112.diff
Group: crypto
Provides: SSL
URL: http://www.openssl.org/
BuildRoot:   /var/tmp/%{name}-%{version}-root
Prefix: %{_hhl_cross_target_dir}
%define _docdir         %{_hhl_cross_target_dir}%{_hhl_target_doc_dir}

License: Other

Obsoletes : hhl-target-openssl
Obsoletes : hhl-%{_hhl_target_arch}-openssl

%description
The OpenSSL Project is a collaborative effort to develop a robust,
commercial-grade, fully featured, and Open Source toolkit implementing the
Secure Sockets Layer (SSL v2/v3) and Transport Layer Security (TLS v1)
protocols as well as a full-strength general purpose cryptography library.
The project is managed by a worldwide community of volunteers that use the
Internet to communicate, plan, and develop the OpenSSL tookit and its related
documentation. 

%package -n openssl-dev
Summary: Secure Sockets Layer and cryptography static libraries and headers
Group: crypto
Requires: openssl
Obsoletes : hhl-%{_hhl_target_arch}-openssl-dev

%description -n openssl-dev
This package contains the the OpenSSL cryptography and SSL/TLS 
static libraries and header files required when developing applications.


%prep
%target_check
%setup -q -n openssl-%{version}.orig
%patch -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1

%build 
%target_setup
# acck, gaaagh, choke  horrible hack
perl -spi -e "s/\"gcc:/\"%{_hhl_target_toolprefix}gcc:/" Configure
perl -spi -e "s/which\(\"ranlib\"\)/which\(\"%{_hhl_target_toolprefix}ranlib\"\)/" Configure

perl util/perlpath.pl /usr/bin/perl

# Define the global setups..
%define CONFIG_FLAGS --prefix=%{_hhl_target_prefix} --openssldir=/usr/lib/ssl no-idea no-mdc2 no-rc5 --openssldir=%{openssldir}

# First we build static libs...
./Configure no-shared %{CONFIG_FLAGS} %{_hhl_target_arch}
%make -f Makefile.ssl DIRS="crypto ssl" all
mv libcrypto.a libcrypto.static
mv libssl.a libssl.static
%make -f Makefile.ssl DIRS="crypto ssl" clean

# Next we build shared libs...
./Configure shared %{CONFIG_FLAGS} %{_hhl_target_arch}
ln -sf apps/openssl.pod crypto/crypto.pod ssl/ssl.pod doc/
%make -f Makefile.ssl all


%install
rm -rf %{buildroot}
%target_setup

make -f Makefile.ssl  install INSTALL_PREFIX=%{buildroot}%{_hhl_cross_target_dir}
install -m 0644 libcrypto.static \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libcrypto.a
install -m 0644 libssl.static \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libssl.a

mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ssl/
mv %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/ssl/{certs,openssl.cnf,private} \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ssl/
ln -s ../../../etc/ssl/{certs,openssl.cnf,private} \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/ssl/

cp -a lib*.so* \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/.

# Fix up libs permissions.. just in case...
chmod 0644 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/lib*

# Create the major version links
(
        cd %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}
        ln -s libcrypto.so.%{libmaj}.%{libmin}.%{librel} libcrypto.so.%{libmaj}
        ln -s libssl.so.%{libmaj}.%{libmin}.%{librel} libssl.so.%{libmaj}
        ln -s libcrypto.so.%{libmaj}.%{libmin}.%{librel} libcrypto.so
        ln -s libssl.so.%{libmaj}.%{libmin}.%{librel} libssl.so
)

# clean out unpackaged files
rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pkgconfig/openssl.pc

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}

genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/openssl
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE2} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/openssl-dev

%clean
rm -rf $RPM_BUILD_ROOT


%files -n openssl
%defattr(0644,root,root,0755)
%doc CHANGES CHANGES.SSLeay LICENSE NEWS README

%attr(0755,root,root)%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/c_rehash
%attr(0755,root,root)%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/openssl

%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libcrypto.so.0.9.7
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libssl.so.0.9.7

%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/ssl/certs
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/ssl/lib
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/ssl/misc
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/ssl/openssl.cnf
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/ssl/private

%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ssl/certs
%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ssl/openssl.cnf
%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ssl/private

%doc %attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man[157]/*

%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/openssl


%files -n openssl-dev
%defattr(0644,root,root,0755)

%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libcrypto.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libcrypto.so
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libcrypto.so.0
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libssl.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libssl.so
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libssl.so.0

%{_hhl_cross_target_dir}%{_hhl_target_prefix}/include/openssl
%doc %attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man[3]/*
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/openssl-dev


%changelog
* Wed Jul 9 2003 Mark Hatle <source@mvista.com>
- Updated to openssl-0.9.7b
* Tue Dec 10 2002 Joe Green <source@mvista.com>
- Updated Xtensa patch to support xtensa_linux_le, xtensa_linux_test configs.
* Wed Jul 31 2002 Mark Hatle <source@mvista.com>
- Updated to openssl-0.9.6e
* Mon Jun 03 2002 Joe Green <source@mvista.com>
- Added support for Xtensa architecture.
* Mon Jan 28 2002 Mark Hatle <source@mvista.com>
- Update to openssl-0.9.6c
- Revised to follow debian install procedures
- Dropped the doc package it seemed pointless
* Tue Aug 14 2001 Mark Hatle <source@mvista.com>
- Update to openssl-0.9.6b
* Fri Apr 27 2001 Troy Benjegerdes <tbenjegerdes@mvista.com>
- Update to openssl-0.9.6a
* Fri Apr 20 2001 Steve Kinneberg <source@mvista.com>
- Added TCT package description files
* Fri Feb 09 2001 Troy Benjegerdes <tbenjegerdes@mvista.com>
- add linux-shared makefile target, put things in the right place
* Tue Feb 05 2001 Troy Benjegerdes <tbenjegerdes@mvista.com>
- Based on openssl.spec included in openssl tarball


