/*      
 *	IOCTLs for MIPL Mobile IPv6 module
 *	
 *      Authors: 
 *      Henrik Petander         <lpetande@tml.hut.fi>
 * 
 *      $Id: s.mipv6_ioctl.h 1.18 02/11/25 11:18:16+02:00 vnuorval@amber.hut.mediapoli.com $ 
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 *
 *
 */

#ifndef _MIPV6_IOCTL_H
#define _MIPV6_IOCTL_H

#include <linux/ioctl.h> 
#include <linux/fs.h> 

int mipv6_ioctl_open(struct inode *inode, struct file *file);
int mipv6_ioctl_close(struct inode *inode, struct file *file);

#ifdef CONFIG_IPV6_MOBILITY_MN
int mipv6_ioctl_mn_init(void);
void mipv6_ioctl_mn_exit(void);
#define mipv6_ioctl_init mipv6_ioctl_mn_init
#define mipv6_ioctl_exit mipv6_ioctl_mn_exit
#endif

#ifdef CONFIG_IPV6_MOBILITY_HA
int mipv6_ioctl_ha_init(void);
void mipv6_ioctl_ha_exit(void);
#define mipv6_ioctl_init mipv6_ioctl_ha_init
#define mipv6_ioctl_exit mipv6_ioctl_ha_exit
#endif

/*
void set_sa_acq(void);
void un_set_sa_acq(void);
*/

/*
 * Mobile Node information record for userspace coomunications
 */
/*
struct mn_info_ext {
	struct in6_addr home_addr;
	struct in6_addr ha;
	__u8 home_plen;
	__u8 is_at_home;
	__u8 has_home_reg;
	__u8 man_conf;
	int ifindex;
	unsigned long home_addr_expires;
};
*/

/* Reserved for local / experimental use */
#define MAJOR_NUM 0xf9

/* Adds a SA (manual keying) */
#define IOCTL_DEL_SA_BUNDLE _IOWR(MAJOR_NUM, 0, void *)

/* Adds an outbound SA as a result of ACQUIRE */
#define IOCTL_ADD_OB_SA _IOWR(MAJOR_NUM, 1, void *) 

/* Adds an outbound SA as a result of ACQUIRE */
#define IOCTL_ADD_IB_SA _IOWR(MAJOR_NUM, 2, void *) 

/* Tells the kmd to create a SA */
#define IOCTL_ACQUIRE_SA _IOR(MAJOR_NUM, 3, void *)

/* Prints a sa_bundle */
#define IOCTL_PRINT_SA _IOWR(MAJOR_NUM, 4, void *)

/* Set home address information for Mobile Node */
#define IOCTL_SET_HOMEADDR _IOR(MAJOR_NUM, 5, void *)

/* Set home agent information for Mobile Node */
#define IOCTL_SET_HOMEAGENT _IOR(MAJOR_NUM, 6, void *)

/* Get home address information for Mobile Node */
#define IOCTL_GET_HOMEADDR _IOWR(MAJOR_NUM, 7, void *)

/* Get home agent information for Mobile Node */
#define IOCTL_GET_HOMEAGENT _IOWR(MAJOR_NUM, 8, void *)

/* Get Care-of address information for Mobile Node */
#define IOCTL_GET_CAREOFADDR _IOWR(MAJOR_NUM, 9, void *)

/* Set home address and corresponding home agent address */
#define IOCTL_SET_MN_INFO _IOR(MAJOR_NUM, 14, void *)

/* Get home address and corresponding home agent address */
#define IOCTL_GET_MN_INFO _IOWR(MAJOR_NUM, 15, void *)

#define IOCTL_ADD_ACL_RULE _IOWR(MAJOR_NUM, 16, void *)

#define MA_IOCTL_REQUEST_IFACE _IOR (MAJOR_NUM, 10, void *)
#define MA_IOCTL_PRINT_CURRENT_IFACE _IOWR (MAJOR_NUM, 11, void *)
#define MA_IOCTL_PRINT_IFACE_PREFERENCES _IOWR (MAJOR_NUM, 12, void *)
#define MA_IOCTL_SET_IFACE_PREFERENCE _IOR (MAJOR_NUM, 13, void *)

/* Set Mobile IPv6 Anycast Address */
#define IOCTL_SET_HA_ANYCAST _IOR (MAJOR_NUM, 16, void *)
#define IOCTL_DEL_HA_ANYCAST _IOR (MAJOR_NUM, 17, void *)

/* The name of the device file */
#define CTLFILE "mipv6_dev"

#endif /* _MIPV6_IOCTL_H */
