/*
 *	IOCTL Control device Common Functions
 *
 *	Authors:
 *
 *
 *	$Id$
 *
 *	This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 */
/*
 *	Changes:
 *
 *	nakam@USAGI		: based on ioctl_mn.c(MIPL) :-)
 */

#include <linux/module.h>
#include <linux/fs.h>
#include "debug.h"
#include "mipv6_ioctl.h"

static int inuse = 0;

int mipv6_ioctl_open(struct inode *inode, struct file *file)
{
	DEBUG(DBG_DATADUMP, "(%p)", file);

	if (inuse)
		return -EBUSY;

	inuse++;

	MOD_INC_USE_COUNT;

	return 0;
}

int mipv6_ioctl_close(struct inode *inode, struct file *file)
{
	DEBUG(DBG_DATADUMP, "(%p,%p)", inode, file);
	inuse--;

	MOD_DEC_USE_COUNT;

	return 0;
}

extern struct file_operations fops;

/* Initialize the module - Register the character device */
int mipv6_ioctl_init(void)
{
	int ret_val;

	/* Register the character device (atleast try) */
	ret_val = register_chrdev(MAJOR_NUM, CTLFILE, &fops);

	/* Negative values signify an error */
	if (ret_val < 0) {
		DEBUG(DBG_ERROR, "failed registering char device (err=%d)",
		      ret_val);
		return ret_val;
	}

	DEBUG(DBG_INFO, "Device number %x, success", MAJOR_NUM);
	return 0;
}

/* Cleanup - unregister the appropriate file from /proc */
void mipv6_ioctl_exit(void)
{
	int ret;
	/* Unregister the device */
	ret = unregister_chrdev(MAJOR_NUM, CTLFILE);

	/* If there's an error, report it */
	if (ret < 0)
		DEBUG(DBG_ERROR, "errorcode: %d", ret);
}
