/*
  * include/linux/tps65010.h  
  *
  * TPS65010 Power Management device definitions
  *
  * Author: MontaVista Software, Inc. <source@mvista.com>
  *
  * 2004 (c) MontaVista Software, Inc. This file is licensed under
  * the terms of the GNU General Public License version 2. This program
  * is licensed "as is" without any warranty of any kind, whether express
  * or implied.
  */
#ifndef _TPS65010_H
#define _TPS65010_H

#define TPS65010_I2C_CHGSTATUS	0x1
#define TPS65010_I2C_REGSTATUS	0x2
#define TPS65010_I2C_MASK1	0x3
#define TPS65010_I2C_MASK2	0x4
#define TPS65010_I2C_ACKINT1	0x5
#define TPS65010_I2C_ACKINT2	0x6
#define TPS65010_I2C_CHGCONFIG  0x7
#define TPS65010_I2C_LED1_ON	0x8
#define TPS65010_I2C_LED1_PER	0x9
#define TPS65010_I2C_LED2_ON	0xa
#define TPS65010_I2C_LED2_PER	0xb
#define TPS65010_I2C_VDCDC1	0xc
#define TPS65010_I2C_VDCDC2	0xd
#define TPS65010_I2C_VREGS1	0xe
#define TPS65010_I2C_MASK3	0xf
#define TPS65010_I2C_DEFGPIO	0x10

/* GPIO pins register */
#define DEFGPIO_IO4		0x80
#define DEFGPIO_IO3		0x40
#define DEFGPIO_IO2		0x20
#define DEFGPIO_IO1		0x10
#define DEFGPIO_GPIO4_VAL 	0x08
#define DEFGPIO_GPIO3_VAL 	0x04
#define DEFGPIO_GPIO2_VAL 	0x02
#define DEFGPIO_GPIO1_VAL 	0x01

/* LDOx enable/voltage register */
#define VREGS1_LDO2_ENABLE	0x80
#define VREGS1_LDO2_OFF		0x40
#define VREGS1_LDO21		0x20
#define VREGS1_LDO20		0x10
#define VREGS1_LDO1_ENABLE	0x08
#define VREGS1_LDO1_OFF		0x04
#define VREGS1_LDO11		0x02
#define VREGS1_LDO10		0x01

/* I2C address */
#define TPS65010_I2C_ADDR 	0x48

/* Kernel API primitives */
unsigned char tps65010_read(u8 subaddr);
int tps65010_write(u8 buf, u8 subaddr);

#endif
