 /* 
  * i2c-algo-85xx.h i2c driver defines for the MPC85xx I2C Interface
  * 
  * (C) Copyright 2002,2003 Motorola Inc
  *
  * Xianghua Xiao (x.xiao@motorola.com)
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.
  * 
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  * 
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  */


#ifndef I2C_ALGO_85xx_H
#define I2C_ALGO_85xx_H 1

#include <linux/i2c.h>
#include <asm/mpc85xx.h>
#include <asm/immap_85xx.h>

/* XXX The following three lines need formal registration with I2C team */
#define I2C_ALGO_MPC85xx          0x140000          /* Algorithm */
#define I2C_HW_MPC85xx_MPC85xxADS 0x00              /* Adapter */
#define I2C_MPC85xx_ADDR	  0x34		    /* MPC85xx's own I2C address */

#define MPC85xx_I2C_OFFSET  0x3000
#define MPC85xx_I2C_SIZE    0x1000

#define MPC85xx_I2CCR_INIT 	(MPC85xx_I2CCR_MEN | \
				 MPC85xx_I2CCR_MSTA| \
                                 MPC85xx_I2CCR_MTX | \
				 MPC85xx_I2CCR_RSTA)

struct i2c_algo_85xx_data
{
	volatile ccsr_i2c_t * i2c;
};

extern int i2c_mpc85xx_add_bus(struct i2c_adapter *);
extern int i2c_mpc85xx_del_bus(struct i2c_adapter *);

#endif /* I2C_ALGO_85xx_H */
