/*
 * linux/gmii.h: definitions for gigabit ethernet GMII-compatible transceivers
 */

#ifndef __LINUX_GMII_H__
#define __LINUX_GMII_H__

#include <linux/types.h>

/* Generic GMII registers. */

#define GMII_BMCR		0x00	/* Basic mode control register */
#define GMII_BMSR		0x01	/* Basic mode status register  */
#define GMII_PHYSID1		0x02	/* PHYS ID 1                   */
#define GMII_PHYSID2		0x03	/* PHYS ID 2                   */
#define GMII_ADVERTISE		0x04	/* Advertisement control reg   */
#define GMII_LPA		0x05	/* Link partner ability reg    */
#define GMII_EXPANSION		0x06	/* Expansion register          */
#define GMII_NEXTPAGE_XMIT	0x07	/* Autonegotiation Next Page Transmit */
#define GMII_NEXTPAGE_RCV	0x08	/* Autonegotiation Next Page Receive */
#define GMII_EXTSTATUS		0x0f	/* Extended Status */

/* Basic mode control register. */
#define BMCR_RESV               0x003f  /* Unused...                   */
#define BMCR_SPEEDMSB		0x0040	/* Speed Selection MSB, always 1 */
#define BMCR_CTST               0x0080  /* Collision test, always 0 */
#define BMCR_FULLDPLX           0x0100  /* Full duplex, always 1 */
#define BMCR_ANRESTART          0x0200  /* Auto negotiation restart */
#define BMCR_ISOLATE            0x0400  /* Disconnect DP83840 from GMII */
#define BMCR_PDOWN              0x0800  /* Powerdown the DP83840 */
#define BMCR_ANENABLE           0x1000  /* Enable auto negotiation */
#define BMCR_SPEEDLSB           0x2000  /* Speed Selection LSB, always 0 */
#define BMCR_LOOPBACK           0x4000  /* TXD loopback bits */
#define BMCR_RESET              0x8000  /* Reset the DP83840 */

/* Basic mode status register. */
#define BMSR_ERCAP		0x0001	/* Ext-reg capability          */
#define BMSR_JCD		0x0002	/* Jabber detected             */
#define BMSR_LSTATUS		0x0004	/* Link status                 */
#define BMSR_ANEGCAPABLE	0x0008	/* Able to do auto-negotiation */
#define BMSR_RFAULT		0x0010	/* Remote fault detected       */
#define BMSR_ANEGCOMPLETE	0x0020	/* Auto-negotiation complete   */
#define BMSR_MFSUPPRESSION	0x0040	/* MF Preamble Suppression     */
#define BMSR_RESV               0x0080  /* Unused...                   */
#define BMSR_EXTSTATUS		0x0100	/* Extended Status             */
#define BMSR_100T2HALF		0x0200	/* 100BASE T2 Half Duplex      */
#define BMSR_100T2FULL		0x0400	/* 100BASE T2 Full Duplex      */
#define BMSR_10HALF             0x0800  /* Can do 10mbps, half-duplex  */
#define BMSR_10FULL             0x1000  /* Can do 10mbps, full-duplex  */
#define BMSR_100HALF            0x2000  /* Can do 100-X mbps, half-duplex */
#define BMSR_100FULL            0x4000  /* Can do 100-X mbps, full-duplex */
#define BMSR_100BASE4           0x8000  /* Can do 100mbps, 4k packets  */

/* Advertisement control register. */
#define ADVERTISE_SLCT          0x001f  /* Selector bits               */
#define ADVERTISE_FULL          0x0020  /* Full duplex mode            */
#define ADVERTISE_HALF          0x0040  /* Half duplex mode            */
#define ADVERTISE_PAUSE         0x0180  /* Pause                       */
#define ADVERTISE_RESV          0x0E00  /* Unused                      */
#define ADVERTISE_RFAULT        0x3000  /* Say we can detect faults    */
#define ADVERTISE_RESV1         0x4000  /* Unused                      */
#define ADVERTISE_NPAGE         0x8000  /* Next page bit               */

/* Link partner ability register. */
#define LPA_RESV                0x001f  /* Unused...                   */
#define LPA_FULL                0x0020  /* Full-duplex                 */
#define LPA_HALF                0x0040  /* Half-duplex                 */
#define LPA_PAUSE               0x0180  /* Pause                       */
#define LPA_RESV1               0x0E00  /* Unused...                   */
#define LPA_RFAULT              0x3000  /* Link partner faulted        */
#define LPA_LPACK               0x4000  /* Link partner acked us       */
#define LPA_NPAGE               0x8000  /* Next page bit               */

/* Expansion register for auto-negotiation. */
#define EXPANSION_RESV          0x0001  /* Unused...                   */
#define EXPANSION_PRCV          0x0002  /* Page received               */
#define EXPANSION_ENABLENPAGE   0x0004  /* This enables npage words    */
#define EXPANSION_RESV1         0xfff8  /* Unused...                   */

/* This structure is used in all SIOCxMIIxxx ioctl calls */
struct gmii_ioctl_data {
	u16		phy_id;
	u16		reg_num;
	u16		val_in;
	u16		val_out;
};

#endif /* __LINUX_GMII_H__ */
