#ifndef __mv64360_h
#define __mv64360_h

/* includes */
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/pci.h>
#include <linux/slab.h>

#include <asm/pci-bridge.h>
#include <asm/byteorder.h>
#include <asm/uaccess.h>
#include <asm/machdep.h>
#include <asm/io.h>
#include <asm/mv64360_defs.h>

/* globals */
extern unsigned int mv64360_base;

/* defines  */
#ifndef TRUE
#define TRUE    1
#endif

#ifndef FALSE
#define FALSE   0
#endif


#define NO_BIT          0x00000000
#define BIT0            0x00000001
#define BIT1            0x00000002
#define BIT2            0x00000004
#define BIT3            0x00000008
#define BIT4            0x00000010
#define BIT5            0x00000020
#define BIT6            0x00000040
#define BIT7            0x00000080
#define BIT8            0x00000100
#define BIT9            0x00000200
#define BIT10           0x00000400
#define BIT11           0x00000800
#define BIT12           0x00001000
#define BIT13           0x00002000
#define BIT14           0x00004000
#define BIT15           0x00008000
#define BIT16           0x00010000
#define BIT17           0x00020000
#define BIT18           0x00040000
#define BIT19           0x00080000
#define BIT20           0x00100000
#define BIT21           0x00200000
#define BIT22           0x00400000
#define BIT23           0x00800000
#define BIT24           0x01000000
#define BIT25           0x02000000
#define BIT26           0x04000000
#define BIT27           0x08000000
#define BIT28           0x10000000
#define BIT29           0x20000000
#define BIT30           0x40000000
#define BIT31           0x80000000
    /* Size defintions */
#define _1K             0x00000400
#define _2K             0x00000800
#define _4K             0x00001000
#define _8K             0x00002000
#define _16K            0x00004000
#define _32K            0x00008000
#define _64K            0x00010000
#define _128K           0x00020000
#define _256K           0x00040000
#define _512K           0x00080000
#define _1M             0x00100000
#define _2M             0x00200000
#define _3M             0x00300000
#define _4M             0x00400000
#define _5M             0x00500000
#define _6M             0x00600000
#define _7M             0x00700000
#define _8M             0x00800000
#define _9M             0x00900000
#define _10M            0x00a00000
#define _11M            0x00b00000
#define _12M            0x00c00000
#define _13M            0x00d00000
#define _14M            0x00e00000
#define _15M            0x00f00000
#define _16M            0x01000000
#define _32M            0x02000000

/* Read/Write for multiple bridges */
#define mv_reg_read(base,offset) le32_to_cpu(* (volatile unsigned int *) ((base) + offset))
#define mv_reg_write(base,offset,data) *(volatile unsigned int *) ((base) + offset) = cpu_to_le32 (data)
#define mv_set_reg_bits(base,regOffset,bits) ((*((volatile unsigned int*)((base) + (regOffset)))) |= ((unsigned int)cpu_to_le32(bits)))
#define mv_reset_reg_bits(base,regOffset,bits) ((*((volatile unsigned int*)((base) + (regOffset)))) &= ~((unsigned int)cpu_to_le32(bits)))

/* Read/Write to/from MV64360 internal registers */
#define MV_REG_READ(offset) mv_reg_read(mv64360_base, (offset))
#define MV_REG_WRITE(offset,data) mv_reg_write(mv64360_base, (offset), (data))
#define MV_SET_REG_BITS(regOffset,bits) mv_set_reg_bits((mv64360_base), (regOffset), (bits))
#define MV_RESET_REG_BITS(regOffset,bits) mv_reset_reg_bits((mv64360_base), (regOffset), (bits))


/****************************************/
/*          GENERAL Definitions			*/
/****************************************/
#define MV64360_INTERNAL_SRAM_SIZE                      _256K
/* CPU to Internal registers window registers */
#define MV64360_WINDOW_SIZE_MIN                         _64K
#define MV64360_INTERNAL_SPACE_SIZE                     _64K
#define MV64360_INTERNAL_SPACE_DEFAULT_ADDR             0x14000000

/* CPU Memory Controller Window Registers (4 windows) */
#define MV64360_CPU_CS_DECODE_WINDOWS                   4

/* CPU Device Controller Window Registers (4 windows) */
#define MV64360_CPU_DEV_CS_DECODE_WINDOWS               4

/* CPU Windows to PCI space (2 PCI buses each w/ 1 I/O & 4 MEM windows) */
#define MV64360_PCI_BUSES                               2
#define MV64360_PCI_IO_WINDOWS_PER_BUS                  1
#define MV64360_PCI_MEM_WINDOWS_PER_BUS                 4

#define MV64360_CPU_PCI_SWAP_BYTE                       0
#define MV64360_CPU_PCI_SWAP_NONE                       BIT24
#define MV64360_CPU_PCI_SWAP_BYTE_WORD                  BIT25
#define MV64360_CPU_PCI_SWAP_WORD                       BIT24|BIT25

/* CPU Access Protection Registers */
#define MV64360_CPU_PROT_WINDOWS                        4

#define MV64360_CPU_PROT_ACCPROTECT                     BIT20
#define MV64360_CPU_PROT_WRPROTECT                      BIT21
#define MV64360_CPU_PROT_CACHEPROTECT                   BIT22

/* PCI Slave Address Decoding Registers */
#define MV64360_PCI_CS_WINDOWS                          4
#define MV64360_PCI_DEV_CS_WINDOWS                      4
#define MV64360_PCI_BOOT_WINDOWS                        1
#define MV64360_PCI_P2P_MEM_WINDOWS                     2
#define MV64360_PCI_P2P_IO_WINDOWS                      1
#define MV64360_PCI_INT_REG_MEM_WINDOWS                 1
#define MV64360_PCI_INT_REG_IO_WINDOWS                  1

/* PCI Access Control Regions Registers */
#define MV64360_PCI_ACC_CNTL_WINDOWS                    4

#define MV64360_PCI_ACC_CNTL_ENABLE                     BIT0
#define MV64360_PCI_ACC_CNTL_FORCE_REQ64                BIT1
#define MV64360_PCI_ACC_CNTL_NO_CACHE_COH               0
#define MV64360_PCI_ACC_CNTL_EN_CACHE_COH_WRITE_THROUGH BIT2
#define MV64360_PCI_ACC_CNTL_EN_CACHE_COH_WRITE_BACK    BIT3
#define MV64360_PCI_ACC_CNTL_ACCESS_ALLOWED             0
#define MV64360_PCI_ACC_CNTL_ACCESS_FORBIDDEN           BIT4
#define MV64360_PCI_ACC_CNTL_WRITE_ALLOWED              0
#define MV64360_PCI_ACC_CNTL_WRITE_PROTECTED            BIT5
#define MV64360_PCI_ACC_CNTL_NO_SWAP                    BIT6
#define MV64360_PCI_ACC_CNTL_SWAP_BYTE                  0
#define MV64360_PCI_ACC_CNTL_SWAP_WORD                  BIT6 | BIT7
#define MV64360_PCI_ACC_CNTL_SWAP_BYTE_AND_WORD         BIT7
#define MV64360_PCI_ACC_CNTL_MBURST_32_BYTES            0
#define MV64360_PCI_ACC_CNTL_MBURST_64_BYTES            BIT8
#define MV64360_PCI_ACC_CNTL_MBURST_128_BYTES           BIT9
#define MV64360_PCI_ACC_CNTL_MBURST_32_BYTES            0
#define MV64360_PCI_ACC_CNTL_READ_SIZE_32_BYTES         0
#define MV64360_PCI_ACC_CNTL_READ_SIZE_64_BYTES         BIT10
#define MV64360_PCI_ACC_CNTL_READ_SIZE_128_BYTES        BIT11
#define MV64360_PCI_ACC_CNTL_READ_SIZE_256_BYTES        BIT10 | BIT11

/* RABEEH - TBD - Redefine again the read size parameter in the following macros*/
#define MV64360_PCI_ACC_CNTL_CACHE_COHERENT MV64360_PCI_ACC_CNTL_ENABLE | MV64360_PCI_ACC_CNTL_EN_CACHE_COH_WRITE_BACK | MV64360_PCI_ACC_CNTL_ACCESS_ALLOWED | MV64360_PCI_ACC_CNTL_WRITE_ALLOWED | MV64360_PCI_ACC_CNTL_MBURST_32_BYTES | MV64360_PCI_ACC_CNTL_READ_SIZE_128_BYTES

#define MV64360_PCI_ACC_CNTL_NONE_CACHE_COHERENT MV64360_PCI_ACC_CNTL_ENABLE | MV64360_PCI_ACC_CNTL_ACCESS_ALLOWED | MV64360_PCI_ACC_CNTL_WRITE_ALLOWED | MV64360_PCI_ACC_CNTL_MBURST_128_BYTES | MV64360_PCI_ACC_CNTL_READ_SIZE_256_BYTES

/* Define struct to pass mem-map info into mv64360_common.c code */
typedef struct {
	struct pci_controller *hose_a;
	struct pci_controller *hose_b;

	u32 mem_size;

	u32 pci_0_mem_start_proc;
	u32 pci_0_mem_start_pci_hi;
	u32 pci_0_mem_start_pci_lo;
	u32 pci_0_mem_size;
	u32 pci_0_mem_swap;

	u32 pci_0_io_start_proc;
	u32 pci_0_io_start_pci;
	u32 pci_0_io_size;
	u32 pci_0_io_swap;

	u32 pci_1_mem_start_proc;
	u32 pci_1_mem_start_pci_hi;
	u32 pci_1_mem_start_pci_lo;
	u32 pci_1_mem_size;
	u32 pci_1_mem_swap;

	u32 pci_1_io_start_proc;
	u32 pci_1_io_start_pci;
	u32 pci_1_io_size;
	u32 pci_1_io_swap;
} mv64360_bridge_info_t;

/*
 * Define a default physical memory map to be set up on the bridge.
 * Also define a struct to pass that info from board-specific routines to
 * MV64360 generic set up routines.  By passing this info in, the board
 * support developer can modify it at will.
 */

/*
 * This is the default physical memory map for PCI:
 *			CPU			PCI
 *			---			---
 * PCI 0 MEM:	0x80000000-0x8fffffff	0x80000000-0x8fffffff
 * PCI 1 MEM:	0x90000000-0x9fffffff	0x90000000-0x9fffffff
 * PCI 0 I/O:	0xa0000000-0xa0ffffff	0x00000000-0x00ffffff
 * PCI 1 I/O:	0xa1000000-0xa1ffffff	0x01000000-0x01ffffff
 *
 * Note that minimum window size (and thus start boundary requirement) is 1MB.
 */

/* Default physical memory map for the MV64360 bridge */

/*
 * Window sizes & base addresses
 */
#define	MV64360_PCI_0_MEM_SIZE		0x10000000U
#define MV64360_PCI_0_I_O_SIZE		0x01000000U

#define	MV64360_PCI_1_MEM_SIZE		0x10000000U
#define MV64360_PCI_1_I_O_SIZE		0x01000000U

#define	MV64360_PCI_MEM_BASE_ADDR_PROC	0x80000000U	/* CPU Address */
#define	MV64360_PCI_IO_BASE_ADDR_PROC	(MV64360_PCI_MEM_BASE_ADDR_PROC + MV64360_PCI_0_MEM_SIZE +  MV64360_PCI_1_MEM_SIZE)

#define	MV64360_PCI_MEM_BASE_ADDR	0x80000000U	/* PCI Address */
#define	MV64360_PCI_IO_BASE_ADDR	0x00000000U

/*
 * PCI Bus 0 Definitions
 */
/* Processor Physical addresses */
#define	MV64360_PCI_0_MEM_START_PROC	MV64360_PCI_MEM_BASE_ADDR_PROC
#define	MV64360_PCI_0_MEM_END_PROC	(MV64360_PCI_0_MEM_START_PROC +	 MV64360_PCI_0_MEM_SIZE - 1)

/* PCI 0 MEM address */
#define	MV64360_PCI_0_MEM_START		MV64360_PCI_MEM_BASE_ADDR
#define	MV64360_PCI_0_MEM_END		(MV64360_PCI_0_MEM_START + MV64360_PCI_0_MEM_SIZE - 1)

/* Processor Physical addresses */
#define	MV64360_PCI_0_IO_START_PROC	MV64360_PCI_IO_BASE_ADDR_PROC
#define	MV64360_PCI_0_IO_END_PROC	(MV64360_PCI_0_IO_START_PROC + MV64360_PCI_0_I_O_SIZE - 1)

/* PCI 0 I/O address */
#define	MV64360_PCI_0_IO_START		MV64360_PCI_IO_BASE_ADDR
#define	MV64360_PCI_0_IO_END		(MV64360_PCI_0_IO_START + MV64360_PCI_0_I_O_SIZE - 1)

/*
 * PCI Bus 1 Definitions
 */
/* Processor Physical addresses */
#define	MV64360_PCI_1_MEM_START_PROC	(MV64360_PCI_0_MEM_END_PROC + 1)
#define	MV64360_PCI_1_MEM_END_PROC	(MV64360_PCI_1_MEM_START_PROC + MV64360_PCI_1_MEM_SIZE - 1)

/* PCI 0 MEM address */
#define	MV64360_PCI_1_MEM_START		(MV64360_PCI_0_MEM_END + 1)
#define	MV64360_PCI_1_MEM_END		(MV64360_PCI_1_MEM_START + MV64360_PCI_1_MEM_SIZE - 1)

/* Processor Physical addresses */
#define	MV64360_PCI_1_IO_START_PROC	(MV64360_PCI_0_IO_END_PROC + 1)
#define	MV64360_PCI_1_IO_END_PROC	(MV64360_PCI_1_IO_START_PROC + MV64360_PCI_1_I_O_SIZE - 1)

/* PCI 0 I/O address */
#define	MV64360_PCI_1_IO_START		(MV64360_PCI_0_IO_END + 1)
#define	MV64360_PCI_1_IO_END		(MV64360_PCI_1_IO_START +  MV64360_PCI_1_I_O_SIZE - 1)

/* RABEEH - TBD - FIX THIS */
#define	MV64360_BRIDGE_INFO_DEFAULT(ip, ms) {(ip)->mem_size = (ms);	\
	(ip)->pci_0_mem_start_proc   = MV64360_PCI_0_MEM_START_PROC;	\
	(ip)->pci_0_mem_start_pci_hi = 0x00000000;			\
	(ip)->pci_0_mem_start_pci_lo = MV64360_PCI_0_MEM_START;		\
	(ip)->pci_0_mem_size	     = MV64360_PCI_0_MEM_SIZE;		\
	(ip)->pci_0_mem_swap	     = MV64360_CPU_PCI_SWAP_NONE;	\
	(ip)->pci_0_io_start_proc = MV64360_PCI_0_IO_START_PROC;	\
	(ip)->pci_0_io_start_pci  = MV64360_PCI_0_IO_START;		\
	(ip)->pci_0_io_size	  = MV64360_PCI_0_I_O_SIZE;		\
	(ip)->pci_0_io_swap	  = MV64360_CPU_PCI_SWAP_NONE;		\
	(ip)->pci_1_mem_start_proc   = MV64360_PCI_1_MEM_START_PROC;	\
	(ip)->pci_1_mem_start_pci_hi = 0x00000000;			\
	(ip)->pci_1_mem_start_pci_lo = MV64360_PCI_1_MEM_START;		\
	(ip)->pci_1_mem_size	     = MV64360_PCI_1_MEM_SIZE;		\
	(ip)->pci_1_mem_swap	     = MV64360_CPU_PCI_SWAP_NONE;	\
	(ip)->pci_1_io_start_proc = MV64360_PCI_1_IO_START_PROC;	\
	(ip)->pci_1_io_start_pci  = MV64360_PCI_1_IO_START;		\
	(ip)->pci_1_io_size	  = MV64360_PCI_1_I_O_SIZE;		\
	(ip)->pci_1_io_swap	  = MV64360_CPU_PCI_SWAP_NONE;		\
}

int mv64360_find_bridges(u32 phys_base_addr, mv64360_bridge_info_t * info,
	int ((*map_irq) (struct pci_dev *, unsigned char, unsigned char)),
	int enumerate);
int mv64360_bridge_init(mv64360_bridge_info_t * info);
int mv64360_cpu_cs_set_window(u32 window, u32 base_addr, u32 size);
int mv64360_cpu_dev_cs_set_window(u32 window, u32 base_addr, u32 size);
int mv64360_cpu_boot_set_window(u32 base_addr, u32 size);
int mv64360_cpu_internal_sram_set_window(u32 base_addr);

int mv64360_cpu_set_pci_io_window(u32 pci_bus,
	u32 cpu_base_addr, u32 pci_base_addr, u32 size, u32 swap);
int mv64360_cpu_set_pci_mem_window(u32 pci_bus,
	u32 window,
	u32 cpu_base_addr,
	u32 pci_base_addr_hi, u32 pci_base_addr_lo, u32 size, u32 swap_64bit);
int mv64360_cpu_prot_set_window(u32 window,
	u32 base_addr, u32 size, u32 access_bits);
int mv64360_cpu_snoop_set_window(u32 window,
	u32 base_addr, u32 size, u32 snoop_type);
void mv64360_cpu_disable_all_windows(void);
void mv64360_pci_disable_all_windows(struct pci_controller *hose_a,
	struct pci_controller *hose_b);

int mv64360_pci_bar_enable(u32 pci_bus, u32 enable_bits);

int mv64360_pci_slave_cs_set_window(struct pci_controller *hose,
	u32 window,
	u32 pci_base_addr,
	u32 pci_base_addr_hi,
	u32 cpu_base_addr, u32 cpu_base_addr_hi, u32 size);
int mv64360_pci_slave_dev_cs_set_window(struct pci_controller *hose,
	u32 window,
	u32 pci_base_addr, u32 pci_base_addr_hi, u32 cpu_base_addr, u32 size);
int mv64360_pci_slave_boot_set_window(struct pci_controller *hose,
	u32 pci_base_addr, u32 pci_base_addr_hi, u32 cpu_base_addr, u32 size);
int mv64360_pci_slave_internal_sram_set_window(struct pci_controller *hose,
	u32 pci_base_addr, u32 pci_base_addr_hi, u32 cpu_base_addr, u32 size);
int mv64360_pci_slave_internal_registers_set_window(struct pci_controller *hose,
	u32 pci_base_addr, u32 pci_base_addr_hi, u32 cpu_base_addr, u32 size);
int mv64360_pci_slave_p2p_mem_set_window(struct pci_controller *hose,
	u32 window,
	u32 pci_base_addr,
	u32 pci_base_addr_hi,
	u32 other_bus_base_addr, u32 other_bus_base_addr_hi, u32 size);
int mv64360_pci_slave_p2p_io_set_window(struct pci_controller *hose,
	u32 pci_base_addr, u32 other_bus_base_addr, u32 size);
void mv64360_pcibios_fixup(void);

u32 mv64360_hw_read_config_dword(u8 local_bus, u8 dest_bus,
	u8 dev, u8 function, u8 offset, u8 type);

void mv64360_hw_write_config_dword(u8 local_bus, u8 dest_bus, u8 dev,
	u8 function, u8 offset, u8 type, u32 val);

int mv64360_pci_acc_cntl_set_window(u32 pci_bus,
	u32 window, u32 base_addr_hi, u32 base_addr_lo, u32 size, u32 features);
int mv64360_set_base(u32 new_base);
int mv64360_get_base(u32 * base);

void mv64360_cpu0_sync_barrier(int bus);
int mv64360_get_cpu_cs_base_and_size(int window, u32 * base, u32 * size);

int mv64360_pci_exclude_device(u8 bus, u8 devfn);

ulong mv64360_get_mem_size(void);

void mv64360_init_irq(void);
int mv64360_get_irq(struct pt_regs *regs);

void mv64360_mpsc_progress(char *s, unsigned short hex);

void gt_early_mpsc_init(int chan, unsigned short cflag);
void gt_polled_putc(int chan, char c);
int gt_polled_getc(int chan, unsigned char *c);

#endif				/* __mv64360_h */
