/* moto_ocp.h  A file with the ocp structures for Motorola
 *
 * Copyright (c) 2003 Motorola, Inc
 *
 * Contact: Andy Fleming <afleming@motorola.com>
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 */

#ifndef __MOTO_OCP_H
#define __MOTO_OCP_H


/* A table of information for supporting Motorola Ethernet Controllers
 * This helps identify which enet controller we are dealing with,
 * and what type of enet controller it is
 */
struct ocp_func_enet_data {
	uint    interruptTransmit;
	uint    interruptError;
	uint    interruptReceive;
	uint    interruptPHY;
	uint    flags;
	uint	phyid;
	uint	phyregidx;
	unsigned char	mac_addr[6];
};

/* Flags in the flags field */
#define MOTO_ENET_HAS_RMON		0x10
#define	MOTO_ENET_HAS_MULTI_INTR	0x08
#define	MOTO_ENET_FIRM_SET_MACADDR 	0x04
#define	MOTO_ENET_HAS_PHY_INTR		0x02
#define	MOTO_ENET_HAS_GIGABIT		0x01

#endif /*__MOTO_OCP_H */
