#ifndef _BASIL_S1_H_
#define _BASIL_S1_H_

#define FOR_PHASE2

/*
 * linux/include/asm-mips/tx4925/basil_s1/basil_s1.h
 *
 * Basil-S1 defs
 *
 * Author: MontaVista Software, Inc.
 *         source@mvista.com
 *
 * Copyright 2001-2002 MontaVista Software Inc.
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef CONFIG_PCI
#include <asm/tx4925/tx4925_pci.h>
#endif

#define	TX4925_PCIMEM0		0x10000000	/* 1000:0000-11FF:FFFF */
#define	TX4925_PCIMEM0_SIZE	0x02000000	/* 32MB */
//#define TX4925_PCIMEM1		0x00000000	/* DO NOT USE		*/
#define	TX4925_PCIMEM1_SIZE	0x00000000	/* 0			*/
//#define TX4925_PCIMEM2		0x00000000	/* DO NOT USE		*/
#define	TX4925_PCIMEM2_SIZE	0x00000000	/* 0			*/

#define	TX4925_PCIMEM		TX4925_PCIMEM0	/* 0800:0000-0FFF:FFFF	*/
#define	TX4925_PCIMEM_SIZE	(TX4925_PCIMEM0_SIZE + TX4925_PCIMEM1_SIZE + TX4925_PCIMEM2_SIZE)	/* 128MB (128+0+0)	*/

#define	TX4925_PCIIO		0x12800000	/* 1280:0000-128F:FFFF	*/
#define	TX4925_PCIIO_SIZE	0x00100000

#ifdef CONFIG_PCI
#define BASIL_S1_ISA_IO_OFFSET	TX4925_PCIIO
#else
#define BASIL_S1_ISA_IO_OFFSET	0
#endif

#define	BASIL_S1_MASTER_CLOCK	18432000

#define	BASIL_S1_EBBAR2		0xb3000000

#define BASIL_S1_IOPORT_BOOTDEV	(BASIL_S1_EBBAR2+0x00180000)
#define BASIL_S1_IOPORT_BOOTDEV_CDBOT		0x0001


#if CONFIG_BASIL_S1_HAVE_DEVCTL
void devctl_on(unsigned short bit);
void devctl_off(unsigned short bit);
unsigned short devctl_get(void);
#endif

#define	BASIL_PIODO_RD		TX4925_RD(TX4925_MKA(TX4925_PIO_PIODO))
#define BASIL_PIODO_WR(piodo)	TX4925_WR(TX4925_MKA(TX4925_PIO_PIODO), (piodo))
#define	BASIL_PIODI_RD		TX4925_RD(TX4925_MKA(TX4925_PIO_PIODI))
#define BASIL_PIODI_WR(piodo)	TX4925_WR(TX4925_MKA(TX4925_PIO_PIODI), (piodo))

/* RTC PIO access */
#define BASIL_S1_RTCCS	(1 << 25)

#define RTC_RX5C348_CE_ASSERT { unsigned long piodo;	\
			  piodo = BASIL_PIODO_RD;	\
			  piodo |= (BASIL_S1_RTCCS);	\
			  BASIL_PIODO_WR(piodo); }
#define RTC_RX5C348_CE_DEASSERT { unsigned long piodo;	\
			  piodo = BASIL_PIODO_RD;	\
			  piodo &= ~(BASIL_S1_RTCCS);	\
			  BASIL_PIODO_WR(piodo); }

#define BASIL_S1_DEBUG_IF	(BASIL_S1_EBBAR2+0x00100000)
#define BASIL_S1_DEBUG_IF_CLOCK 4915200

#define	BASIL_S1_RS485_RE	(1 << 12)
#define	BASIL_S1_RS485_DE	(1 << 13)
#define	BASIL_S1_RS485_5CNCT	(1 << 18)


/* Modem Board PIO access */
#define BASIL_S1_MODEM_RST	(1 << 24)
#define BASIL_S1_DTRB		(1 << 5)
#define BASIL_S1_LHKB		(1 << 2)
#define BASIL_S1_LCNT		(1 << 1)
#define BASIL_S1_FHKB		(1 << 4)
#define BASIL_S1_MDCT		(1 << 0)

#define DTRB		(BASIL_PIODO_RD & BASIL_S1_DTRB)
#define LHKB		(BASIL_PIODI_RD & BASIL_S1_LHKB)
#define LCNT		(BASIL_PIODO_RD & BASIL_S1_LCNT)
#define FHKB		(BASIL_PIODI_RD & BASIL_S1_FHKB)
#define MODEM_DCT	(BASIL_PIODI_RD & BASIL_S1_MDCT)

#define DTRB_DISC	{ unsigned long piodo;		\
			  piodo = BASIL_PIODO_RD;	\
			  piodo |= (BASIL_S1_DTRB);	\
			  BASIL_PIODO_WR(piodo); }
#define DTRB_NORMAL	{ unsigned long piodo;		\
			  piodo = BASIL_PIODO_RD;	\
			  piodo &= ~(BASIL_S1_DTRB);	\
			  BASIL_PIODO_WR(piodo); }
#define LCNT_HIGH	{ unsigned long piodo;		\
			  piodo = BASIL_PIODO_RD;	\
			  piodo |= (BASIL_S1_LCNT);	\
			  BASIL_PIODO_WR(piodo); }
#define LCNT_LOW	{ unsigned long piodo;		\
			  piodo = BASIL_PIODO_RD;	\
			  piodo &= ~(BASIL_S1_LCNT);	\
			  BASIL_PIODO_WR(piodo); }

/* Modem Reset */
#define MODEM_RST_RESET	{ unsigned long piodo;		\
			  piodo = BASIL_PIODO_RD;	\
			  piodo &= ~(BASIL_S1_MODEM_RST);	\
			  BASIL_PIODO_WR(piodo); }
#define MODEM_RST_NORMAL { unsigned long piodo;		\
			  piodo = BASIL_PIODO_RD;	\
			  piodo |= (BASIL_S1_MODEM_RST);	\
			  BASIL_PIODO_WR(piodo); }

/* ROMWP PIO access */
#define BASIL_S1_ROMWP	(1 << 26)

/* ROMWP */
#define ROM_WP_ON { unsigned long piodo;	\
		    piodo = BASIL_PIODO_RD;	\
		    piodo |= (BASIL_S1_ROMWP);	\
		    BASIL_PIODO_WR(piodo); }
#define ROM_WP_OFF { unsigned long piodo;	\
		    piodo = BASIL_PIODO_RD;	\
		    piodo &= ~(BASIL_S1_ROMWP);	\
		    BASIL_PIODO_WR(piodo); }


/* check BOOT_CHG */
//#define IS_ROM_BOOT	(devctl_get() & BASIL_S1_IOPRT_DEVCTL_BOOT_CHG)
#define IS_ROM_BOOT	((*(vu16*)BASIL_S1_IOPORT_BOOTDEV) & BASIL_S1_IOPORT_BOOTDEV_CDBOT)
#define IS_CARD_BOOT	(!IS_ROM_BOOT)


#endif /* _BASIL_S1_H_ */
