#ifndef __IDT_SPI_H__
#define __IDT_SPI_H__

/*******************************************************************************
 *
 * Copyright 2002 Integrated Device Technology, Inc.
 *		All rights reserved.
 *
 * Serial Peripheral Interface register definitions. 
 *
 * File   : $Id: spi.h,v 1.1.2.1 2004/02/11 19:04:42 mpruznick Exp $
 *
 * Author : ryan.holmQVist@idt.com
 * Date   : 20011005
 * Update :
 *	    $Log: spi.h,v $
 *	    Revision 1.1.2.1  2004/02/11 19:04:42  mpruznick
 *	    MR: 5393
 *	    bugz:5393 -- Add idt434 lsp
 *	
 *	    Revision 1.2  2002/06/06 18:34:05  astichte
 *	    Added XXX_PhysicalAddress and XXX_VirtualAddress
 *	
 *	    Revision 1.1  2002/05/29 17:33:25  sysarch
 *	    jba File moved from vcode/include/idt/acacia
 *	
 *
 ******************************************************************************/

#include  <asm/types.h>

enum {
	SPI0_PhysicalAddress = 0x18070000,
	SPI_PhysicalAddress = SPI0_PhysicalAddress,

	SPI0_VirtualAddress = 0xb8070000,
	SPI_VirtualAddress = SPI0_VirtualAddress,
};

typedef struct {
	unsigned int spcp;	/* prescalar. 0=off, * spiClk = sysClk/(2*(spcp+1)*SPR) */
	unsigned int spc;	/* spi control reg use SPC_ */
	unsigned int sps;	/* spi status reg use SPS_ */
	unsigned int spd;	/* spi data reg use SPD_ */
	unsigned int siofunc;	/* serial IO function use SIOFUNC_ */
	unsigned int siocfg;	/* serial IO config use SIOCFG_ */
	unsigned int siod;	/* serial IO data use SIOD_ */
} volatile *SPI_t;

enum {
	SPCP_div_b = 0,
	SPCP_div_m = 0x000000ff,
	SPC_spr_b = 0,
	SPC_spr_m = 0x00000003,
	SPC_spr_div2_v = 0,
	SPC_spr_div4_v = 1,
	SPC_spr_div16_v = 2,
	SPC_spr_div32_v = 3,
	SPC_cpha_b = 2,
	SPC_cpha_m = 0x00000004,
	SPC_cpol_b = 3,
	SPC_cpol_m = 0x00000008,
	SPC_mstr_b = 4,
	SPC_mstr_m = 0x00000010,
	SPC_spe_b = 6,
	SPC_spe_m = 0x00000040,
	SPC_spie_b = 7,
	SPC_spie_m = 0x00000080,

	SPS_modf_b = 4,
	SPS_modf_m = 0x00000010,
	SPS_wcol_b = 6,
	SPS_wcol_m = 0x00000040,
	SPS_spif_b = 7,
	SPS_spif_m = 0x00000070,

	SPD_data_b = 0,
	SPD_data_m = 0x000000ff,

	SIOFUNC_sdo_b = 0,
	SIOFUNC_sdo_m = 0x00000001,
	SIOFUNC_sdi_b = 1,
	SIOFUNC_sdi_m = 0x00000002,
	SIOFUNC_sck_b = 2,
	SIOFUNC_sck_m = 0x00000004,

	SIOCFG_sdo_b = 0,
	SIOCFG_sdo_m = 0x00000001,
	SIOCFG_sdi_b = 1,
	SIOCFG_sdi_m = 0x00000002,
	SIOCFG_sck_b = 2,
	SIOCFG_sck_m = 0x00000004,

	SIOD_sdo_b = 0,
	SIOD_sdo_m = 0x00000001,
	SIOD_sdi_b = 1,
	SIOD_sdi_m = 0x00000002,
	SIOD_sck_b = 2,
	SIOD_sck_m = 0x00000004,
};
#endif				/* __IDT_SPI_H__ */
