/*
 * include/asm-mips/intrinsity/memmap.h
 *
 * Include file for Intrinsity Memory Map
 *
 * Author: MontaVista Software, Inc. <source@mvista.com>
 *
 * 2004 (c) MontaVista, Software, Inc.  This file is licensed under the terms
 * of the GNU General Public License version 2.  This program is licensed
 * "as is" without any warranty of any kind, whether express or implied.
 */
#ifndef _INTRINSITY_MEMMAP_H
#define _INTRINSITY_MEMMAP_H

#include <asm/addrspace.h>	/* for KSEG1ADDR */

#ifndef KSEG1ADDR
#define	KSEG1ADDR(x)	(0xA0000000+(x))
#endif

/* Physical memory map */
#define	FM_DRAM_BASE		0x00000000	/* DRAM (alias of 1/2 DRAM0_BASE) */
#define	FM_GPIO0_BASE		0x10000000	/* GPIO area 0, 64Mb */
#define	FM_GPIO1_BASE		0x14000000	/* GPIO area 1, 64Mb */
#define	FM_GPIO2_BASE		0x18000000	/* GPIO area 2, 64Mb */
#define	FM_GPIO3_BASE		0x1C000000	/* GPIO area 3, 64Mb */
/* Everything past here requires a tlb entry */
#define	FM_DRAM0_BASE		0x20000000	/* First DRAM bank, 512Mb max */
#define	FM_DRAM1_BASE		0x40000000	/* Second DRAM bank, 512Mb max */
#define	FM_RESERV_BASE		0x60000000	/* Reserved 512Mb */
#define	FM_RIO_REGION0_BASE	0x80000000	/* Rio Region 0,  128Mb */
#define	FM_RIO_REGION1_BASE	0x88000000	/* Rio Region 1,  128Mb */
#define	FM_RIO_REGION2_BASE	0x90000000	/* Rio Region 2,  128Mb */
#define	FM_RIO_REGION3_BASE	0x98000000	/* Rio Region 3,  128Mb */
#define	FM_RIO_REGION4_BASE	0xA0000000	/* Rio Region 4,  128Mb */
#define	FM_RIO_REGION5_BASE	0xA8000000	/* Rio Region 5,  128Mb */
#define	FM_RIO_REGION6_BASE	0xB0000000	/* Rio Region 6,  128Mb */
#define	FM_RIO_REGION7_BASE	0xB8000000	/* Rio Region 7,  128Mb */
#define	FM_RIO_REGION8_BASE	0xC0000000	/* Rio Region 8,  128Mb */
#define	FM_RIO_REGION9_BASE	0xC8000000	/* Rio Region 9,  128Mb */
#define	FM_RIO_REGIONA_BASE	0xD0000000	/* Rio Region 10, 128Mb */
#define	FM_RIO_REGIONB_BASE	0xD8000000	/* Rio Region 11, 128Mb */
#define	FM_RIO_REGIONC_BASE	0xE0000000	/* Rio Region 12, 128Mb */
#define	FM_RIO_REGIOND_BASE	0xE8000000	/* Rio Region 13, 128Mb */
#define	FM_RIO_REGIONE_BASE	0xF0000000	/* Rio Region 14, 128Mb */
#define	FM_RIO_REGIONF_BASE	0xF8000000	/* Rio Region 15, 128Mb */

/* Things that live in GPIO space, as they appear to the processor */
#define	FM_GPIO_BASE		KSEG1ADDR(FM_GPIO0_BASE+0x01000000)	/* GPIO */
#define	FM_RIO0_BASE		KSEG1ADDR(FM_GPIO0_BASE+0x01300000)	/* Rapid I/O #0 */
#define	FM_RIO1_BASE		KSEG1ADDR(FM_GPIO0_BASE+0x01400000)	/* Rapid I/O #1 */
#define	FM_DMA0_BASE		KSEG1ADDR(FM_GPIO0_BASE+0x01500000)	/* DMA #0 */
#define	FM_DMA1_BASE		KSEG1ADDR(FM_GPIO0_BASE+0x01500008)	/* DMA #1 */
#define	FM_IOQ_BASE		KSEG1ADDR(FM_GPIO0_BASE+0x01600000)	/* I/O Queue */
#define	FM_L2_BASE		KSEG1ADDR(FM_GPIO0_BASE+0x01E00000)	/* L2 */
#define	FM_MCU_BASE		KSEG1ADDR(FM_GPIO0_BASE+0x01F00000)	/* Memory Controller Unit */
#define FM_UART_BASE		KSEG1ADDR(FM_GPIO1_BASE+0x00000000)	/* NS16550-ish UART */
#define	FM_I2C_BASE		KSEG1ADDR(FM_GPIO1_BASE+0x00000100)	/* I2C */
#define	FM_FPGA_BASE		KSEG1ADDR(FM_GPIO2_BASE+0x00000000)	/* FPGA */
#define	FM_SCRATCH_BASE		KSEG1ADDR(FM_GPIO2_BASE+0x00800000)	/* Scratchpad memory (2kb) */
#define	FM_EJTAG_BASE		KSEG1ADDR(FM_GPIO3_BASE+0x03200000)	/* EJTAG */
#define	FM_FLASH_BASE		KSEG1ADDR(FM_GPIO3_BASE+0x03800000)	/* 8Mb Flash Rom */

/*
 * RapidIO to PCI mappings
 * The Tundra tsi400 is attached to the RIO1 interface
 * and is setup (by redboot) to have 4 128Mb mappings into PCI space.
 * This is covered by a single wired TLB entry as a pair of 256Mb pages
 * which maps the last 4 Rio regions (512Mb) as a 1-to-1 virtual to physical translation.
 * The PCI config space is shared between actual pci config space and the tsi400.
 */
#define	TSI400_BIAS		0x04000000
#define	PCI_BIAS		0x05000000
#define	FM_PCI_SIZE		0x08000000	/* total size of mapped PCI space (one Rio region) */
#define	FM_PCI_IO_BASE		FM_RIO_REGIONC_BASE	/* PCI I/O    (E0000000-E7FFFFFF) */
#define	FM_PCI_MEM_BASE		FM_RIO_REGIOND_BASE	/* PCI Memory (E8000000-EFFFFFFF) */
#define	FM_PCI_PFM3_BASE	FM_RIO_REGIONE_BASE	/* PCI PFM3   (F0000000-F7FFFFFF) */
#define	FM_TSI400_BASE		(FM_RIO_REGIONF_BASE+TSI400_BIAS)	/* Tsi400 registers (FC000000-FC01FFFF) */
#define	FM_PCI_CONFIG_BASE	(FM_RIO_REGIONF_BASE+PCI_BIAS)	/* PCI Config and RapidIO Maint (FD000000-FFFFFFFF) */

#endif				/* _INTRINSITY_MEMMAP_H */
