/*
 * include/asm-mips/intrinsity/irq.h
 *
 * Include file for Intrinsity IRQ
 *
 * Author: MontaVista Software, Inc. <source@mvista.com>
 *
 * 2004 (c) MontaVista, Software, Inc.  This file is licensed under the terms
 * of the GNU General Public License version 2.  This program is licensed
 * "as is" without any warranty of any kind, whether express or implied.
 */
#ifndef	_INTRINSITY_IRQ_H
#define	_INTRINSITY_IRQ_H

/* Interrupt Exception Numbers */

/* These correspond to status/cause register bits */
#define	FM_IE_RIO1		IE_IRQ0
#define	FM_IE_RIO0		IE_IRQ1
#define FM_IE_DMA		IE_IRQ2
#define FM_IE_GPIO		IE_IRQ3
#define FM_IE_TIMER		IE_IRQ5

#define ALLINTS (FM_IE_RIO1 | FM_IE_RIO0 | FM_IE_DMA | FM_IE_GPIO | FM_IE_TIMER )

/* Interrupt numbers */
#define FM_IRQ_NULL		0	/* unknown/unused   */
#define	FM_IRQ_RIO0_MAILBOX0	1	/* RIO #0 Mailbox 0 */
#define	FM_IRQ_RIO0_MAILBOX1	2	/* RIO #0 Mailbox 1 */
#define	FM_IRQ_RIO0_DOORBELL	3	/* RIO #0 Doorbell  */
#define	FM_IRQ_RIO1_MAILBOX0	4	/* RIO #1 Mailbox 0 */
#define	FM_IRQ_RIO1_MAILBOX1	5	/* RIO #1 Mailbox 1 */
#define	FM_IRQ_RIO1_DOORBELL	6	/* RIO #1 Doorbell  */
#define	FM_IRQ_PCI_A		7	/* PCI INT-A        */
#define	FM_IRQ_PCI_B		8	/* PCI INT-B        */
#define	FM_IRQ_PCI_C		9	/* PCI INT-C        */
#define	FM_IRQ_PCI_D		10	/* PCI INT-D        */
#define	FM_IRQ_DMA		11	/* DMA              */
#define	FM_IRQ_UART		12	/* FPGA UART        */
#define	FM_IRQ_I2C		13	/* FPGA I2C         */
#define	FM_IRQ_LM86_ALERT	14	/* LM86 temp sensor */
#define	FM_IRQ_COUNT		15	/* FPGA Counter     */
#define	FM_IRQ_TIMER		16	/* Internal timer   */
#define FM_MAX_INTR		17

#endif				/* _INTRINSITY_IRQ_H */
