/*
 * include/asm-mips/intrinsity/gpio.h
 *
 * Include file for Intrinsity GPIO
 *
 * Author: MontaVista Software, Inc. <source@mvista.com>
 *
 * 2004 (c) MontaVista, Software, Inc.  This file is licensed under the terms
 * of the GNU General Public License version 2.  This program is licensed
 * "as is" without any warranty of any kind, whether express or implied.
 */
#ifndef	_INTRINSITY_GPIO_H
#define	_INTRINSITY_GPIO_H

#include <asm/intrinsity/memmap.h>

/* General Purpose I/O */

/* Register offsets from FM_GPIO_BASE */
#define	FM_GPIO_WE_TIM_1	0x000	/* Region 1 Write Enable Timing */
#define	FM_GPIO_CS_TIM_1	0x004	/* Region 1 Chip Select Timing */
#define	FM_GPIO_ST_TIM_1	0x008	/* Region 1 Strobe Timing */
#define	FM_GPIO_OE_TIM_1	0x00c	/* Region 1 Output Enable Timing */
#define	FM_GPIO_CYCW_TIM_1	0x010	/* Region 1 Write Cycle Timing */
#define	FM_GPIO_CYCR_TIM_1	0x014	/* Region 1 Read Cycle Timing */
#define	FM_GPIO_ADADW_TIM_1	0x018	/* Region 1 Data Write Timing */
#define	FM_GPIO_ADAD_TIM_1	0x01c	/* Region 1 Address Drive Timing */
#define	FM_GPIO_GEN_1		0x020	/* Region 1 General */
#define	FM_GPIO_ADADR_TIM_1	0x024	/* Region 1 Data Read Timing */
#define	FM_GPIO_GPO		0x02c	/* General Purpose ??? */
#define	FM_GPIO_WE_TIM_2	0x100	/* Region 2 Write Enable Timing */
#define	FM_GPIO_CS_TIM_2	0x104	/* Region 2 Chip Select Timing */
#define	FM_GPIO_ST_TIM_2	0x108	/* Region 2 Strobe Timing */
#define	FM_GPIO_OE_TIM_2	0x10c	/* Region 2 Output Enable Timing */
#define	FM_GPIO_CYCW_TIM_2	0x110	/* Region 2 Write Cycle Timing */
#define	FM_GPIO_CYCR_TIM_2	0x114	/* Region 2 Read Cycle Timing */
#define	FM_GPIO_ADADW_TIM_2	0x118	/* Region 2 Data Write Timing */
#define	FM_GPIO_ADAD_TIM_2	0x11c	/* Region 2 Address Drive Timing */
#define	FM_GPIO_GEN_2		0x120	/* Region 2 General */
#define	FM_GPIO_ADADR_TIM_2	0x124	/* Region 2 Data Read Timing */
#define	FM_GPIO_STATUS		0x12c	/* Interrupt status and config */
#define	FM_GPIO_WE_TIM_3	0x200	/* Region 3 Write Enable Timing */
#define	FM_GPIO_CS_TIM_3	0x204	/* Region 3 Chip Select Timing */
#define	FM_GPIO_ST_TIM_3	0x208	/* Region 3 Strobe Timing */
#define	FM_GPIO_OE_TIM_3	0x20c	/* Region 3 Output Enable Timing */
#define	FM_GPIO_CYCW_TIM_3	0x210	/* Region 3 Write Cycle Timing */
#define	FM_GPIO_CYCR_TIM_3	0x214	/* Region 3 Read Cycle Timing */
#define	FM_GPIO_ADADW_TIM_3	0x218	/* Region 3 Data Write Timing */
#define	FM_GPIO_ADAD_TIM_3	0x21c	/* Region 3 Address Drive Timing */
#define	FM_GPIO_GEN_3		0x220	/* Region 3 General */
#define	FM_GPIO_ADADR_TIM_3	0x224	/* Region 3 Data Read Timing */

/* bits in FM_GPIO_STATUS */
#define	FM_GPIO_STATUS_INT	0x00000002	/* interrupt pending, write 1 to clear */
#define	FM_GPIO_STATUS_NO_INT	0x00000000	/* interrupts disabled */
#define	FM_GPIO_STATUS_HL_INT	0x00040000	/* enable active high level interrupts */
#define	FM_GPIO_STATUS_LL_INT	0x00050000	/* enable active low level interrupts */
#define	FM_GPIO_STATUS_HE_INT	0x00060000	/* enable high going edge interrupts */
#define	FM_GPIO_STATUS_LE_INT	0x00070000	/* enable low going edge interrupts */

/* Various timings for GPIO */
#undef	GPIO_CS0_DEFAULT
#define	GPIO_CS0_SLOW
#undef	GPIO_CS0_FAST

#undef	GPIO_CS1_DEFAULT
#define	GPIO_CS1_SLOW
#undef	GPIO_CS1_FAST

#ifdef GPIO_CS0_DEFAULT		/* Set up GPIO region 1 (CS 0) as non-multiplexed, slow */
#define	vGPIO_WE_TIM_1		0xffffffff
#define	vGPIO_CS_TIM_1		0xffffffff
#define	vGPIO_ST_TIM_1		0xffffffff	/* NA for non-multiplexed */
#define	vGPIO_OE_TIM_1		0xffffffff
#define	vGPIO_CYCW_TIM_1	0x00000000
#define	vGPIO_CYCR_TIM_1	0x00000000
#define	vGPIO_ADADW_TIM_1	0x00000000	/* Data write timing */
#define	vGPIO_ADAD_TIM_1	0x00000000	/* Address drive timing */
#define	vGPIO_GEN_1		0x00000000	/* Ewait disable, 64MB, div 1, mux, dis */
#define	vGPIO_ADADR_TIM_1	0x00000000	/* Data read timing */
#define	vGPIO_GPO		0xffffffff
#endif

#ifdef	GPIO_CS0_SLOW		/* Set up GPIO region 1 (CS 0) as non-multiplexed, slow */
#define	vGPIO_WE_TIM_1		0xc0000001
#define	vGPIO_CS_TIM_1		0x80000000
#define	vGPIO_ST_TIM_1		0xffffffff	/* NA for non-multiplexed */
#define	vGPIO_OE_TIM_1		0xc0000001
#define	vGPIO_CYCW_TIM_1	0x80000000
#define	vGPIO_CYCR_TIM_1	0x80000000
#define	vGPIO_ADADW_TIM_1	0x7ffffffe	/* Data write timing */
#define	vGPIO_ADAD_TIM_1	0x7ffffffe	/* Address drive timing */
#define	vGPIO_GEN_1		0x0000010b	/* EWait enable, 64MB, div 4, non-mux, en */
#define	vGPIO_ADADR_TIM_1	0x10000000	/* Data read timing */
#define	vGPIO_GPO		0xaaaaaaaa
#endif

#ifdef	GPIO_CS0_FAST		/* Set up GPIO region 1 (CS 0) as multiplexed, fast */
#endif

#ifdef GPIO_CS1_DEFAULT		/* Set up GPIO region 2 (CS 1) as multiplexed, slow */
#define	vGPIO_WE_TIM_2		0xffffffff
#define	vGPIO_CS_TIM_2		0xffffffff
#define	vGPIO_ST_TIM_2		0xffffffff
#define	vGPIO_OE_TIM_2		0xffffffff
#define	vGPIO_CYCW_TIM_2	0x00000000
#define	vGPIO_CYCR_TIM_2	0x00000000
#define	vGPIO_ADADW_TIM_2	0x00000000	/* Data write timing */
#define	vGPIO_ADAD_TIM_2	0x00000000	/* Address drive timing */
#define	vGPIO_GEN_2		0x00000000	/* Ewait disable, 64MB, div 1, mux, dis */
#define	vGPIO_ADADR_TIM_2	0x00000000	/* Data read timing */
#endif

#ifdef	GPIO_CS1_SLOW		/* Set up GPIO region 2 (CS 1) as multiplexed, slow */
#define	vGPIO_WE_TIM_2		0x8000ffff
#define	vGPIO_CS_TIM_2		0x80000001
#define	vGPIO_ST_TIM_2		0xffffe007
#define	vGPIO_OE_TIM_2		0x8000ffff
#define	vGPIO_CYCW_TIM_2	0x80000000
#define	vGPIO_CYCR_TIM_2	0x80000000
#define	vGPIO_ADADW_TIM_2	0x8fff8000	/* Data write timing */
#define	vGPIO_ADAD_TIM_2	0x0000cffc	/* Address drive timing */
#define	vGPIO_GEN_2		0x00000109	/* EWait enable, 64MB, div 4, mux, en */
#define	vGPIO_ADADR_TIM_2	0x40000000	/* Data read timing */
#endif

#ifdef	GPIO_CS1_FAST		/* Set up GPIO region 2 (CS 1) as multiplexed, fast */
#define	vGPIO_WE_TIM_2		0xfffc003f
#define	vGPIO_CS_TIM_2		0xffe00000
#define	vGPIO_ST_TIM_2		0xfffffff8
#define	vGPIO_OE_TIM_2		0xfff0003f
#define	vGPIO_CYCW_TIM_2	0x00100000
#define	vGPIO_CYCR_TIM_2	0x00100000
#define	vGPIO_ADADW_TIM_2	0x000fffc0	/* Data write timing */
#define	vGPIO_ADAD_TIM_2	0x0000001f	/* Address drive timing */
#define	vGPIO_GEN_2		0x00000109	/* EWait enable, 64MB, div 4, mux, en */
#define	vGPIO_ADADR_TIM_2	0x00080000	/* Data read timing */
#endif

#ifndef __ASSEMBLY__

#define	GPIO(off)	((volatile unsigned int *)FM_GPIO_BASE)[(FM_GPIO_##off)/4]

static __inline__ void fm_gpio_print(void)
{
	printk("   WE_TIM_1: %08x\n", GPIO(WE_TIM_1));
	printk("   CS_TIM_1: %08x\n", GPIO(CS_TIM_1));
	printk("   ST_TIM_1: %08x\n", GPIO(ST_TIM_1));
	printk("   OE_TIM_1: %08x\n", GPIO(OE_TIM_1));
	printk(" CYCW_TIM_1: %08x\n", GPIO(CYCW_TIM_1));
	printk(" CYCR_TIM_1: %08x\n", GPIO(CYCR_TIM_1));
	printk("ADADW_TIM_1: %08x\n", GPIO(ADADW_TIM_1));
	printk(" ADAD_TIM_1: %08x\n", GPIO(ADAD_TIM_1));
	printk("      GEN_1: %08x\n", GPIO(GEN_1));
	printk("ADADR_TIM_1: %08x\n", GPIO(ADADR_TIM_1));
	printk("        GPO: %08x\n", GPIO(GPO));
	printk("   WE_TIM_2: %08x\n", GPIO(WE_TIM_2));
	printk("   CS_TIM_2: %08x\n", GPIO(CS_TIM_2));
	printk("   ST_TIM_2: %08x\n", GPIO(ST_TIM_2));
	printk("   OE_TIM_2: %08x\n", GPIO(OE_TIM_2));
	printk(" CYCW_TIM_2: %08x\n", GPIO(CYCW_TIM_2));
	printk(" CYCR_TIM_2: %08x\n", GPIO(CYCR_TIM_2));
	printk("ADADW_TIM_2: %08x\n", GPIO(ADADW_TIM_2));
	printk(" ADAD_TIM_2: %08x\n", GPIO(ADAD_TIM_2));
	printk("      GEN_2: %08x\n", GPIO(GEN_2));
	printk("ADADR_TIM_2: %08x\n", GPIO(ADADR_TIM_2));
	printk("     STATUS: %08x\n", GPIO(STATUS));
	printk("   WE_TIM_3: %08x\n", GPIO(WE_TIM_3));
	printk("   CS_TIM_3: %08x\n", GPIO(CS_TIM_3));
	printk("   ST_TIM_3: %08x\n", GPIO(ST_TIM_3));
	printk("   OE_TIM_3: %08x\n", GPIO(OE_TIM_3));
	printk(" CYCW_TIM_3: %08x\n", GPIO(CYCW_TIM_3));
	printk(" CYCR_TIM_3: %08x\n", GPIO(CYCR_TIM_3));
	printk("ADADW_TIM_3: %08x\n", GPIO(ADADW_TIM_3));
	printk(" ADAD_TIM_3: %08x\n", GPIO(ADAD_TIM_3));
	printk("      GEN_3: %08x\n", GPIO(GEN_3));
	printk("ADADR_TIM_3: %08x\n", GPIO(ADADR_TIM_3));
}

static __inline__ void fm_gpio_interrupt_setup(void)
{
	GPIO(STATUS) = FM_GPIO_STATUS_LL_INT | FM_GPIO_STATUS_INT;
	__asm__("sync");
}

static __inline__ void fm_gpio_interrupt_ack(void)
{
	GPIO(STATUS) = FM_GPIO_STATUS_LL_INT | FM_GPIO_STATUS_INT;
	__asm__("sync");
}

#endif				/* !__ASSEMBLY__ */

#endif				/* _INTRINSITY_GPIO_H */
