/*
 * include/asm-mips/intrinsity/fastmath.h
 *
 * Include file for Intrinsity Eval Board.
 *
 * Author: MontaVista Software, Inc. <source@mvista.com>
 *
 * 2004 (c) MontaVista, Software, Inc.  This file is licensed under the terms
 * of the GNU General Public License version 2.  This program is licensed
 * "as is" without any warranty of any kind, whether express or implied.
 */
#ifndef _INTRINSITY_FASTMATH_H_
#define _INTRINSITY_FASTMATH_H_

#include <asm/intrinsity/memmap.h>
#include <asm/intrinsity/irq.h>
#include <asm/intrinsity/gpio.h>
#include <asm/intrinsity/fpga.h>
#include <asm/intrinsity/dma.h>

/* How do you want KSEG0 to behave? (Linux _REQUIRES_ cached for ll/sc) */
#define	KSEG0_CACHING	3	/* 3=cached, 2=uncached */

/* What speed does the console run? */
#define	CONSOLE_SPEED	38400

/* Where should the initial stack be? */
#define	STACK_BASE	0x88000000	/* end of 128Mb */

#ifndef	__ASSEMBLY__

#include <linux/delay.h>
#include <asm/io.h>

/* cpu pipeline flush */
void static __inline__ fm_sync(void)
{
	__asm__ volatile ("sync");
}

void static __inline__ outb_sync(u8 val, int reg)
{
	outb(val, reg);
	fm_sync();
}

void static __inline__ outw_sync(u16 val, int reg)
{
	outw(val, reg);
	fm_sync();
}

void static __inline__ outl_sync(u32 val, int reg)
{
	outl(val, reg);
	fm_sync();
}

#endif				/* !__ASSEMBLY__ */

#endif				/* _INTRINSITY_FASTMATH_H_ */
