/*
 * Robert Lembree, lembree@metrolink.com
 * Copyright (C) 2001 Metro Link, Inc.  All rights reserved.
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * Defines for the Stw2 interrupt mechanisms.
 *
 */
#ifndef _XILLEONINT_H
#define _XILLEONINT_H

extern void xilleonint_init(void);

#ifdef CONFIG_IKOS
#define CONFIG_ATI_XILLEON_PEER_MODE
#endif

/*
 * IRQs on the Xilleon run from 1 to 128
 * Internally, these number are one less than the rest
 * of the world knows so that we can use the IRQs as shifts.
 */

#define SB_IRQBASE 1        /* INTS 1-32 are South Bridge */
#define NUM_SB_IRQS 10       /* Actual number of interrupts */

#define EXTPCI_IRQBASE 33   /* INTS 33-64 are PCI */
#define NUM_EXT_PCI_IRQS 4   /* Actual number of interrupts */

#define FIRMWARE_IRQBASE 65 /* INTS 65-94 are Firmware (General) */
#define NUM_FIRMWARE_IRQS 30 /* Actual number of interrupts */

#define PCU_IRQBASE 97      /* INTS 97-128 are PCU */
#define NUM_PCU_IRQS 30      /* Actual number of interrupts */

#define XILLEON_IDE_INT 1
#define XILLEON_USB_INT 2
/* for x225 */
#define X225_IDE_INT 3
#define X225_IDE_INT_SEC 4
#define XILLEON_LPC0_INT 5
#define XILLEON_LPC1_INT 6
#define XILLEON_LPC2_INT 7
#define XILLEON_LPC3_INT 8
#define XILLEON_DAIO1_INT 9
#define XILLEON_DAIO2_INT 10

#define XILLEON_INTR0_INT 33
#define XILLEON_INTR1_INT 34
#define XILLEON_INTR2_INT 35
#define XILLEON_INTR3_INT 36

#define XILLEON_CRTC_VBLANK_INT   65    
#define XILLEON_CRTC_VLINE_INT    66    
#define XILLEON_CRTC_VSYNC_INT    67    
#define XILLEON_SNAPSHOT_INT      68    
#define XILLEON_HM_COM_MIPS_INT   69    
#define XILLEON_HM_COM_CPU_INT    70    
#define XILLEON_TPS_MIPS_INT      71    
#define XILLEON_TPS_CPU_INT       72    
#define XILLEON_VIDCAP_INT        73    
#define XILLEON_MPEG1_INT         74    
#define XILLEON_MPEG_INT          75    
#define XILLEON_FP2_DETECT_INT    76    
#define XILLEON_VLB_OP_INT        77    
#define XILLEON_PCU_INT_INT       80    
#define XILLEON_BUSMASTER_EOL_INT 81    
#define XILLEON_CRTC_VBLANK_BIT2_INT 82 
#define XILLEON_CRTC1_VBLANK_BIT2_INT 83
#define XILLEON_SI_MIPS_INT       85    
#define XILLEON_SI_CPU_INT        86    
#define XILLEON_AUDIO_INT         87    
#define XILLEON_PCIC_INT          88    
#define XILLEON_VIPH_INT          89    
#define XILLEON_CRTC1_VBLANK_INT  90    
#define XILLEON_CRTC1_VLINE_INT   91    
#define XILLEON_CRTC1_VSYNC_INT   92    
#define XILLEON_SOUTHBRIDGE_INT   93    
#define XILLEON_SNAPSHOT1_INT     94    

#define XILLEON_DMA_INT    97
#define XILLEON_UIRT_INT   98
#define XILLEON_UART2_INT  99
#define XILLEON_UART1_INT  100
#define XILLEON_TIMER_INT  101
#define XILLEON_RTC_INT    102
#define XILLEON_FB0_INT    105
#define XILLEON_FB1_INT    106
#define XILLEON_FB2_INT    107
#define XILLEON_FB3_INT    108
#define XILLEON_FB4_INT    109
#define XILLEON_FB5_INT    110
#define XILLEON_FB6_INT    111
#define XILLEON_FB7_INT    112
#define XILLEON_I2C0_INT   113
#define XILLEON_I2C1_INT   114
#define XILLEON_SMCA_INT   115
#define XILLEON_SMCB_INT   116
#define XILLEON_SMCC_INT   117
#define XILLEON_HDCP_STAT_INT 118
#define XILLEON_HDCP_AK_INT 118
#define XILLEON_I2C_STAT_INT 119
#define XILLEON_I2C_AK_INT 119
#define XILLEON_HOST_WRITE_DETECT_INT 121

#define XILLEON_CP0_TIMER_INT 120 /* sort of a pseudo-interrupt number */


#define XILLEONINT_UART 0

/*
 * The format of the version number is in BCD.
 * It is arranged as follows:
 *
 * Major    Minor   Patch   CustomerID
 * 00       00      00      00
 *
 */

#define BSP_VERSION_NUMBER 0x14000000
#define BSP_VERSION_STRING "BSP_Version 14.0.0.0"

#endif /* !(_XILLEONINT_H) */
