/*
 * Robert Lembree, lembree@metrolink.com
 * Copyright (C) 2001 Metro Link, Inc.  All rights reserved.
 *
 * ########################################################################
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ########################################################################
 *
 */
#ifndef _MIPS_XILLEON_H
#define _MIPS_XILLEON_H

#include <asm/addrspace.h>
#include <asm/io.h>

#include <asm/ati/xilleonreg_kernel.h>


#define CRASH_ME __asm__("lw $1,0($0)\n")

/* Xilleon ChipId macros */

#define COMPILE_FOR_ALL_CHIPS
/*
#define COMPILE_FOR_X220
#define COMPILE_FOR_X225
#define COMPILE_FOR_X226
#define COMPILE_FOR_X210
*/

#define CHIP_ID_MASK            0x0000FFFF
#define CHIP_REVISION_MASK      0xFFFF0000


/*==========================
 * Chip IDs
 *=========================*/
#define ATI_PCI_VENDOR_ID       0x1002

#define X220_HBIU_DEVICE_ID     0x4845
#define X220_IDE_DEVICE_ID      0x4846
#define X220_USB_DEVICE_ID      0x4847
#define X220_AUDIO_DEVICE_ID    0x4848
#define X220_MODEM_DEVICE_ID    0x4849
#define X220_LPC_DEVICE_ID      0x484A
#define X220_PCIC_DEVICE_ID     0x484B      /* Special: not in config space */

#define X225_HBIU_DEVICE_ID     0x4855
#define X225_IDE_DEVICE_ID      0x4856
#define X225_USB_DEVICE_ID      0x4857
#define X225_AUDIO_DEVICE_ID    0x4858
#define X225_MODEM_DEVICE_ID    0x4859
#define X225_LPC_DEVICE_ID      0xFFFF      /* No LPC for x225              */
#define X225_PCIC_DEVICE_ID     0x485B      /* Special: not in config space */

#define X226_HBIU_DEVICE_ID     0x4865
#define X226_IDE_DEVICE_ID      0x4866
#define X226_USB_DEVICE_ID      0x4867
#define X226_AUDIO_DEVICE_ID    0x4868
#define X226_MODEM_DEVICE_ID    0x4869
#define X226_LPC_DEVICE_ID      0xFFFF      /* No LPC for x226              */
#define X226_PCIC_DEVICE_ID     0x486B      /* Special: not in config space */

#define X210_HBIU_DEVICE_ID     0x4860
#define X210_IDE_DEVICE_ID      0x4861
#define X210_USB_DEVICE_ID      0x4862
#define X210_AUDIO_DEVICE_ID    0x4863
#define X210_MODEM_DEVICE_ID    0x4864
#define X210_LPC_DEVICE_ID      0xFFFF      /* No LPC for x21x              */
#define X210_PCIC_DEVICE_ID     0x486B      /* Special: not in config space */

#define CHIP_ID_UNKNOWN         0xFFFFFFFF
#define CHIP_ID_MASK            0x0000FFFF
#define CHIP_REVISION_MASK      0xFFFF0000

#define CHIP_ID_X220            X220_HBIU_DEVICE_ID
#define CHIP_ID_X220_A11       (0x00010000 | X220_HBIU_DEVICE_ID)
#define CHIP_ID_X220_A12       (0x00020000 | X220_HBIU_DEVICE_ID)
#define CHIP_ID_X220_A21       (0x00030000 | X220_HBIU_DEVICE_ID)
#define CHIP_ID_X220_A22       (0x00040000 | X220_HBIU_DEVICE_ID)

#define CHIP_ID_X225            X225_HBIU_DEVICE_ID
#define CHIP_ID_X225_A11       (0x00010000 | X225_HBIU_DEVICE_ID)
#define CHIP_ID_X225_A12       (0x00020000 | X225_HBIU_DEVICE_ID)
#define CHIP_ID_X225_A13       (0x00030000 | X225_HBIU_DEVICE_ID)
#define CHIP_ID_X225_A21       (0x00040000 | X225_HBIU_DEVICE_ID)
#define CHIP_ID_X225_A22       (0x00050000 | X225_HBIU_DEVICE_ID)

#define CHIP_ID_X226            X226_HBIU_DEVICE_ID
#define CHIP_ID_X226_A11       (0x00010000 | X226_HBIU_DEVICE_ID)
#define CHIP_ID_X226_A12       (0x00020000 | X226_HBIU_DEVICE_ID)

#define CHIP_ID_X210            X210_HBIU_DEVICE_ID
#define CHIP_ID_X210_A11       (0x00010000 | X210_HBIU_DEVICE_ID)
#define CHIP_ID_X210_A12       (0x00020000 | X210_HBIU_DEVICE_ID)

#if (defined COMPILE_FOR_ALL_CHIPS)

#define XK_CHIP_X220(ChipId) ((ChipId & CHIP_ID_MASK) == CHIP_ID_X220)
#define XK_CHIP_X225(ChipId) ((ChipId & CHIP_ID_MASK) == CHIP_ID_X225)
#define XK_CHIP_X226(ChipId) ((ChipId & CHIP_ID_MASK) == CHIP_ID_X226)
#define XK_CHIP_X210(ChipId) ((ChipId & CHIP_ID_MASK) == CHIP_ID_X210)

#else

#define XK_CHIP_X220(ChipId)		0
#define XK_CHIP_X225(ChipId)		0
#define XK_CHIP_X226(ChipId)		0
#define XK_CHIP_X210(ChipId)		0
#if (defined COMPILE_FOR_X220)
#undef   XK_CHIP_X220
#define  XK_CHIP_X220(ChipId)	        1
#endif
#if (defined COMPILE_FOR_X225)
#undef   XK_CHIP_X225
#define  XK_CHIP_X225(ChipId)	        1
#endif
#if (defined COMPILE_FOR_X226)
#undef   XK_CHIP_X226
#define  XK_CHIP_X226(ChipId)	        1
#endif
#if (defined COMPILE_FOR_X210)
#undef   XK_CHIP_X210
#define  XK_CHIP_X210(ChipId)	        1
#endif

#endif


#define XK_CHIP_X220_A11(ChipId)   (ChipId == CHIP_ID_X220_A11)
#define XK_CHIP_X220_A12(ChipId)   (ChipId == CHIP_ID_X220_A12)
#define XK_CHIP_X220_A21(ChipId)   (ChipId == CHIP_ID_X220_A21)
#define XK_CHIP_X220_A22(ChipId)   (ChipId == CHIP_ID_X220_A22)

#define XK_CHIP_X225_A11(ChipId)   (ChipId == CHIP_ID_X225_A11)
#define XK_CHIP_X225_A12(ChipId)   (ChipId == CHIP_ID_X225_A12)
#define XK_CHIP_X225_A13(ChipId)   (ChipId == CHIP_ID_X225_A13)
#define XK_CHIP_X225_A21(ChipId)   (ChipId == CHIP_ID_X225_A21)
#define XK_CHIP_X225_A22(ChipId)   (ChipId == CHIP_ID_X225_A22)

#define XK_CHIP_X226_A11(ChipId)   (ChipId == CHIP_ID_X226_A11)
#define XK_CHIP_X226_A12(ChipId)   (ChipId == CHIP_ID_X226_A12)

#define XK_CHIP_X210_A11(ChipId)   (ChipId == CHIP_ID_X210_A11)
#define XK_CHIP_X210_A12(ChipId)   (ChipId == CHIP_ID_X210_A12)

/* 
 * Xilleon I/O ports base address. 
*/

#define XILLEON_PORT_BASE    KSEG1

#define XILLEON_HBIUBASE     (KSEG1ADDR(0x08000000))
#define XILLEON_PCIC1BASE    (KSEG1ADDR(0x10000000))
#define XILLEON_REGBASE      (KSEG1ADDR(0x18000000))
#define XILLEON_PCIC2BASE    (KSEG1ADDR(0x1a000000))
#define XILLEON_PCUBASE      (KSEG1ADDR(0x1c000000))

#define XILLEON_MEMSIZE     0x08000000
#define XILLEON_HBIUSIZE    0x08000000
#define XILLEON_PCIC1SIZE   0x08000000
#define XILLEON_REGSIZE     0x00010000
#define XILLEON_PCIC2SIZE   0x02000000
#define XILLEON_PCUSIZE     0x04000000

/*
 * PCU memory map
 */

#define PCU_BASE                0x1c000000
#define XILLEON_CORE_FLASH_BASE 0x1c200000
#define XILLEON_DOC_BASE        0x1c400000
#define XILLEON_LCD_BASE        0x1c500000


#define PCU_MODE_NONE             0
#define PCU_MODE_FLEXBUS          1
#define PCU_MODE_SFLASH_SEPST05   2
#define PCU_MODE_SFLASH_SEPST10   3
#define PCU_MODE_SFLASH_SEPST20   4
#define PCU_MODE_SFLASH_SEPST40   5
#define PCU_MODE_SFLASH_SEPST80   6
#define PCU_MODE_SFLASH_SEPISSI   7
#define PCU_MODE_SFLASH_SEPATMEL  8
#define PCU_MODE_PFLASH_32MBIT    9
#define PCU_MODE_PFLASH_64MBIT    10
#define PCU_MODE_PFLASH_128MBIT   11


/* FlexBus bases for STW5X226 */

#define FBC0BASE    0x00000000  /* Boot/core flash */
#define FBC0SIZE    0x0000000b  /* APERSIZE = 64MB */
#define FBC1BASE    0x01000000  /* User flash */
#define FBC1SIZE    0x00000009  /* APERSIZE = 16MB */
#define FBC2BASE    0x00600000  /* DOC */
#define FBC2SIZE    0x00000005  /* APERSIZE = 1MB */
#define FBC3BASE    0x00700000  /* LCD/cfg regs */
#define FBC3SIZE    0x00000005  /* APERSIZE = 1MB */
#define FBC4BASE    0x00800000  /* NIM 1 */
#define FBC4SIZE    0x00000007  /* APERSIZE = 4MB */
#define FBC5BASE    0x00c00000  /* NIM 2 */
#define FBC5SIZE    0x00000007  /* APERSIZE = 4MB */
#define IPABASE     0x02000000  /* UARTs/UIRTs */
#define IPASIZE     0x00000001  /* APERSIZE = 64KB */

#define UART0_BASE  (CP_PCU_BASE + IPABASE)
#define UART1_BASE  (CP_PCU_BASE + IPABASE + 0x10)
#define UART2_BASE  (CP_PCU_BASE + IPABASE + 0x20)     /* for STW5X226 */


/* ported from pmon flexbus.h */

#define DBUSWIDTH_8      0
#define DBUSWIDTH_16     1

#define ABUSLATCH_NONE   0
#define ABUSLATCH_LOWER  1
#define ABUSLATCH_UPPER  2
#define ABUSLATCH_BOTH   3


/* flexbus microstore */

/* ATMEL flash read */
#define FBC_MSTORE0_VAL  0x01e6 /* ENTRY 0x00 - 001111 00110 wait for 8 clocks RD/CE low */
#define FBC_MSTORE1_VAL  0x01f6 /* ENTRY 0x01 - 001111 10110 wait for 8 clocks RD/CE low */
#define FBC_MSTORE2_VAL  0x032f /* ENTRY 0x02 - 011001 01111 wait for 2 clocks ALL hi */

#ifdef HDTV2_IKOS

/* ATMEL flash write (1614 & AT29LV040 - 512Kbyte) */
#define FBC_MSTORE3_VAL  0x010d /* ENTRY 0x03 - 001000 01101 wait for 1 clock  WE low */
#define FBC_MSTORE4_VAL  0x01c5 /* ENTRY 0x04 - 001110 00101 wait for 7 clocks CE/WE low */
#define FBC_MSTORE5_VAL  0x01c5 /* ENTRY 0x04 - 001110 00101 wait for 7 clocks CE/WE low */
#define FBC_MSTORE6_VAL  0x010d /* ENTRY 0x06 - 001000 01101 wait for 1 clock  WE low */
#define FBC_MSTORE7_VAL  0x01cf /* ENTRY 0x07 - 001110 01111 wait for 7 clocks all high */
#define FBC_MSTORE8_VAL  0x01cf /* ENTRY 0x08 - 001110 01111 wait for 7 clocks all high */
#define FBC_MSTORE9_VAL  0x03cf /* ENTRY 0x09 - 011110 01111 wait for 7 clocks ALL hi */

/* LIBIT 4030 read */
#define FBC_MSTORE10_VAL 0x0009 /* ENTRY 0x0a - the 4030 RD is changed from active low to active high for testing -- TI*/
#define FBC_MSTORE11_VAL 0x010f /* ENTRY 0x0b - 001000 01111 wait for 1 clock   WE/STB/CE high, RD/RDS low */
#define FBC_MSTORE12_VAL 0x0177 /* ENTRY 0x0c - 001011 10111 wait for 4 clocks  WE/STB/RDS high, RD/CE low */
#define FBC_MSTORE13_VAL 0x03cf /* ENTRY 0x0d - 011110 01111 waith for 7 clocks WE/STB/CE high, RD/RDS low */

/* LIBIT 4030 write */
#define FBC_MSTORE14_VAL 0x010e /* ENTRY 0x0e - 001000 01110 wait for 1 clock   RD/WE/STB/CE high, RDS low */
#define FBC_MSTORE15_VAL 0x0166 /* ENTRY 0x0f - 001011 00110 wait for 4 clocks  RD/WE/STB high, CE/RDS low */
#define FBC_MSTORE16_VAL 0x036e /* ENTRY 0x10 - 011011 01110 waith for 1 clock  RD/WE/STB/CE high, RDS low */

#else

/* ATMEL flash write (1614 & AT29LV040 - 512Kbyte) */
#define FBC_MSTORE3_VAL  0x010d /* ENTRY 0x03 - 001000 01101 wait for 1 clock  WE low */
#define FBC_MSTORE4_VAL  0x01c5 /* ENTRY 0x04 - 001110 00101 wait for 7 clocks CE/WE low */
#define FBC_MSTORE5_VAL  0x010d /* ENTRY 0x05 - 001000 01101 wait for 1 clock  WE low */
#define FBC_MSTORE6_VAL  0x032f /* ENTRY 0x06 - 011001 01111 wait for 2 clocks ALL hi */
#define FBC_MSTORE7_VAL  0x0000 /* ENTRY 0x07 - */
#define FBC_MSTORE8_VAL  0x0000 /* ENTRY 0x08 - */
#define FBC_MSTORE9_VAL  0x0000 /* ENTRY 0x09 - */

/* LED debug register read */
#define FBC_MSTORE10_VAL 0x010f /* ENTRY 0x0a - 001000 01111 wait for 1 clock all high */
#define FBC_MSTORE11_VAL 0x0116 /* ENTRY 0x0b - 001000 10110 wait for 1 clock CE/RD low (capture data) */
#define FBC_MSTORE12_VAL 0x010f /* ENTRY 0x0c - 001000 01111 wait for 1 clock all high */

/* LED debug register write */
#define FBC_MSTORE13_VAL 0x010f /* ENTRY 0x0d - 001000 01111 wait for 1 clock all high */
#define FBC_MSTORE14_VAL 0x0105 /* ENTRY 0x0e - 001000 00101 wait for 1 clock CE/WE low */
#define FBC_MSTORE15_VAL 0x010f /* ENTRY 0x0f - 001000 01111 wait for 1 clock all high */
#define FBC_MSTORE16_VAL 0x0000 /* ENTRY 0x10 - halt */

#endif /* IKOS */

/* POD read */
#define FBC_MSTORE17_VAL 0x010f /* ENTRY 0x11 - 001000 01111 wait for 1 clock all high */
#define FBC_MSTORE18_VAL 0x0107 /* ENTRY 0x12 - 001000 00111 wait for 1 clock CE low */
#define FBC_MSTORE19_VAL 0x00f3 /* ENTRY 0x13 - 000111 10011 wait for clocked ready low CE/STB low */
#define FBC_MSTORE20_VAL 0x032f /* ENTRY 0x14 - 011001 01111 wait for 2 clocks all high */

/* POD write */
#define FBC_MSTORE21_VAL 0x010f /* ENTRY 0x15 - 001000 01111 wait for 1 clock all high */
#define FBC_MSTORE22_VAL 0x0106 /* ENTRY 0x16 - 001000 00110 wait for 1 clock CE/WE low */
#define FBC_MSTORE23_VAL 0x00e2 /* ENTRY 0x17 - 000111 00010 wait for clocked RDY low CE/WE/STB low */
#define FBC_MSTORE24_VAL 0x030f /* ENTRY 0x18 - 011000 01111 wait for 1 clock all high */

/* UART read */
#define FBC_MSTORE25_VAL 0x0147 /* ENTRY 0x19 - 001010 00111 wait 3 clocks  RDS high, CE low) */
#define FBC_MSTORE26_VAL 0x01e6 /* ENTRY 0x1a - 001111 00110 wait 9 clocks  RD/CE low */
#define FBC_MSTORE27_VAL 0x0116 /* ENTRY 0x1b - 001000 10110 Capture Data   RD/STB/RDS high, WE/CE low  */
#define FBC_MSTORE28_VAL 0x1127 /* ENTRY 0x1c - 001001 00111 wait 2 clocks  CE low  */
#define FBC_MSTORE29_VAL 0x03cf /* ENTRY 0x1d - 011110 01111 wait 7 clocks - all high) */

/* UART write */
#define FBC_MSTORE30_VAL 0x0147 /* ENTRY 0x1e - 001010 00111 wait 3 clocks  CE low */
#define FBC_MSTORE31_VAL 0x01c5 /* ENTRY 0x1f - 001110 00101 wait 7 clocks  WE/CE low  */
#define FBC_MSTORE32_VAL 0x0127 /* ENTRY 0x20 - 001001 00111 wait 2 clocks  CE low */
#define FBC_MSTORE33_VAL 0x01ef /* ENTRY 0x21 - 001111 01111 wait 9 clocks  all high */
#define FBC_MSTORE34_VAL 0x030f /* ENTRY 0x22 - 011000 01111 "                       */

/* Disk on Chip read */
#define FBC_MSTORE35_VAL 0x010f /* ENTRY 0x23 - 001000 01111 wait for 1 clock  ALL hi */
#define FBC_MSTORE36_VAL 0x01d6 /* ENTRY 0x24 - 001110 10110 wait for 7 clocks CE/RD low */
#define FBC_MSTORE37_VAL 0x030f /* ENTRY 0x26 - 011000 01111 wait for 1 clock  ALL hi */

/* Disk on Chip write */
#define FBC_MSTORE38_VAL 0x010f /* ENTRY 0x26 - 001000 01111 wait for 1 clock  ALL hi */
#define FBC_MSTORE39_VAL 0x0185 /* ENTRY 0x27 - 001100 00101 wait for 5 clocks CE/WE low */
#define FBC_MSTORE40_VAL 0x034f /* ENTRY 0x28 - 011010 01111 wait for 3 clocks ALL hi */

/* TI TSB42 (1394) read */
#define FBC_MSTORE41_VAL 0x010f /* ENTRY 0x29 - 001000 01111 set all inactive for 1 clock, set to read */
#define FBC_MSTORE42_VAL 0x0107 /* ENTRY 0x2a - 001000 00111 set CS active, 1 clock delay */
#define FBC_MSTORE43_VAL 0x0073 /* ENTRY 0x2b - 000011 10011 set STB active, wait for RDY to go low, read data */
#define FBC_MSTORE44_VAL 0x030f /* ENTRY 0x2c - 011000 01111 set all inactive 1 clock, then halt */

/* Unused */
#define FBC_MSTORE45_VAL 0x0000 /* ENTRY 0x2c - */

/* TI TSB42 (1394) write */
#define FBC_MSTORE46_VAL 0x10d  /* ENTRY 0x2e - 001000 01101 set all inactive for 1 clock, set to write */
#define FBC_MSTORE47_VAL 0x105  /* ENTRY 0x2f - 001000 00101 set CS active, 1 clock delay  */
#define FBC_MSTORE48_VAL 0x0045 /* ENTRY 0x30 - 000011 10011 set STB active, wait for RDY to go low  */
#define FBC_MSTORE49_VAL 0x30f  /* ENTRY 0x31 - 011000 01111 set all inactive for 1 clock, set to read,halt */

/* Unused */
#define FBC_MSTORE50_VAL 0x0000 /* ENTRY 0x32 - */
#define FBC_MSTORE51_VAL 0x0000 /* ENTRY 0x33 - */
#define FBC_MSTORE52_VAL 0x0000 /* ENTRY 0x34 - */
#define FBC_MSTORE53_VAL 0x0000 /* ENTRY 0x35 - */
#define FBC_MSTORE54_VAL 0x0000 /* ENTRY 0x36 - */
#define FBC_MSTORE55_VAL 0x0000 /* ENTRY 0x37 - */
#define FBC_MSTORE56_VAL 0x0000 /* ENTRY 0x38 - */
#define FBC_MSTORE57_VAL 0x0000 /* ENTRY 0x39 - */
#define FBC_MSTORE58_VAL 0x0000 /* ENTRY 0x3a - */

/* LIBIT 4230 read */
#define FBC_MSTORE59_VAL 0x0103 /* ENTRY 0x3b - 001000 00011 wait for 1 clock CE/STB low; WE high */
#define FBC_MSTORE60_VAL 0x0277 /* ENTRY 0x3c - 010011 10111 wait for not RDY, then halt CE low */

/* LIBIT 4230 write */
#define FBC_MSTORE61_VAL 0x0101 /* ENTRY 0x3d - 001000 00001 wait for 1 clock CE/STB/WE low */
#define FBC_MSTORE62_VAL 0x0065 /* ENTRY 0x3e - 000011 00101 wait for not RDY, CE/WE low */
#define FBC_MSTORE63_VAL 0x030f /* ENTRY 0x3f - 011000 01111 wait for 1 clock, then halt all high */

/*****************************************************************************/

/* flexbus aperture 0 setup */
#define FBC0_READVEC   0x00
#define FBC0_WRITEVEC  0x03

/* flexbus aperture 1 setup */
#define FBC1_READVEC   0x00
#define FBC1_WRITEVEC  0x03
#define FBC1_DBUSWIDTH DBUSWIDTH_16
#define FBC1_ABUSLATCH ABUSLATCH_BOTH

/* flexbus aperture 2 setup */
#define FBC2_READVEC   0x0A
#define FBC2_WRITEVEC  0x0D
#define FBC2_DBUSWIDTH DBUSWIDTH_8
#define FBC2_ABUSLATCH ABUSLATCH_BOTH

/* flexbus aperture 3 setup */
#define FBC3_READVEC   0x00
#define FBC3_WRITEVEC  0x00
#define FBC3_DBUSWIDTH DBUSWIDTH_8
#define FBC3_ABUSLATCH ABUSLATCH_BOTH

/* flexbus aperture 4 setup - NIM slots */
#define FBC4_READVEC   0x29
#define FBC4_WRITEVEC  0x2e
#define FBC4_DBUSWIDTH DBUSWIDTH_8
#define FBC4_ABUSLATCH ABUSLATCH_BOTH

/* flexbus aperture 5 setup - NIM slots */
#define FBC5_READVEC   0x00
#define FBC5_WRITEVEC  0x00
#define FBC5_DBUSWIDTH DBUSWIDTH_8
#define FBC5_ABUSLATCH ABUSLATCH_BOTH


/* boot straps macros */

#define STRAPS__SYS_CFG__SHIFT     (5)
#define STRAPS__SYS_CFG__MASK      (0x3<<STRAPS__SYS_CFG__SHIFT)
#define STRAPS__SYS_CFG__SOLO      (0x0<<STRAPS__SYS_CFG__SHIFT)
#define STRAPS__SYS_CFG__RESERVED  (0x1<<STRAPS__SYS_CFG__SHIFT)
#define STRAPS__SYS_CFG__PEER      (0x2<<STRAPS__SYS_CFG__SHIFT)
#define STRAPS__SYS_CFG__PEERPLUS  (0x3<<STRAPS__SYS_CFG__SHIFT)

#define STRAPS__BOOTROM_SEL__SHIFT               (9)
#define STRAPS__BOOTROM_SEL__MASK                (0xF<<STRAPS__BOOTROM_SEL__SHIFT)
#define STRAPS__BOOTROM_SEL__RESERVED1           (0x0<<STRAPS__BOOTROM_SEL__SHIFT)
#define STRAPS__BOOTROM_SEL__RESERVED2           (0x1<<STRAPS__BOOTROM_SEL__SHIFT)
#define STRAPS__BOOTROM_SEL__RESERVED3           (0x2<<STRAPS__BOOTROM_SEL__SHIFT)
#define STRAPS__BOOTROM_SEL__RESERVED4           (0x3<<STRAPS__BOOTROM_SEL__SHIFT)
#define STRAPS__BOOTROM_SEL__NAND_32Mb           (0x4<<STRAPS__BOOTROM_SEL__SHIFT)
#define STRAPS__BOOTROM_SEL__NAND_64Mb           (0x5<<STRAPS__BOOTROM_SEL__SHIFT)
#define STRAPS__BOOTROM_SEL__NAND_128Mb          (0x6<<STRAPS__BOOTROM_SEL__SHIFT)
#define STRAPS__BOOTROM_SEL__ST_M25P80           (0x7<<STRAPS__BOOTROM_SEL__SHIFT)
#define STRAPS__BOOTROM_SEL__ST_M25P10           (0x8<<STRAPS__BOOTROM_SEL__SHIFT)
#define STRAPS__BOOTROM_SEL__ST_M25P05           (0x9<<STRAPS__BOOTROM_SEL__SHIFT)
#define STRAPS__BOOTROM_SEL__ST_M25P20           (0xA<<STRAPS__BOOTROM_SEL__SHIFT)
#define STRAPS__BOOTROM_SEL__NEXTFLASH_NX25F011  (0xB<<STRAPS__BOOTROM_SEL__SHIFT)
#define STRAPS__BOOTROM_SEL__ATMEL_AT25F1024     (0xC<<STRAPS__BOOTROM_SEL__SHIFT)
#define STRAPS__BOOTROM_SEL__ST_M25P40           (0xD<<STRAPS__BOOTROM_SEL__SHIFT)
#define STRAPS__BOOTROM_SEL__NOR_8               (0xE<<STRAPS__BOOTROM_SEL__SHIFT)
#define STRAPS__BOOTROM_SEL__NOR_16              (0xF<<STRAPS__BOOTROM_SEL__SHIFT)


/* GPIO SEL macros */

#define GPIOSEL__1394_TRANSPORT                     0
#define GPIOSEL__NA_TRANSPORT                       1
#define GPIOSEL__I2S_B_OUT                          2 
#define GPIOSEL__I2S_A_OUT                          3 
#define GPIOSEL__SPDIF_A_B_OUT                      4 
#define GPIOSEL__DVI_OUT                            5 
#define GPIOSEL__OUT_OF_BAND                        6 
#define GPIOSEL__HOST_VIP_INTERRUPT                 7 
#define GPIOSEL__ITU656_IN_PORT_B                   8 
#define GPIOSEL__ITU656_OUT_PORT_C                  9 
#define GPIOSEL__CRT                                10
#define GPIOSEL__NA_EJTAG                           11
#define GPIOSEL__DEBUG_BUS_A                        12
#define GPIOSEL__DEBUG_BUS_B                        13
#define GPIOSEL__SERIAL_PORT_A_1                    14
#define GPIOSEL__CLK_DEBUG_OUT                      15
#define GPIOSEL__DREQBB_GPIO6                       16
#define GPIOSEL__DVS_DATA_PCI                       17
#define GPIOSEL__SC_A_NRSS_DATA__FB_INTERRUPTS_PCI  18
#define GPIOSEL__IDE                                21
#define GPIOSEL__IR                                 22
#define GPIOSEL__SERIAL_PORT_A_2                    23
#define GPIOSEL__SC_B__FB_INTERRUPTS                24
#define GPIOSEL__SC_A__FB_INTERRUPTS                25
#define GPIOSEL__ITU656_IN_PORT_A                   26


/*
#define XILLEON_IPA_BASE  (XILLEON_PCUBASE+(GETFLD_REGMM32(APER_PCU_IPA_ADDR, BASE_ADDRESS)<<16))
*/

#if (defined CONFIG_STWX220) && (!defined CONFIG_STW3X225)
#define XILLEON_IPA_BASE        0x1c600000
#else
#define XILLEON_IPA_BASE        0x1e000000
#endif

#define XILLEON_UART0_REGS_BASE  (XILLEON_IPA_BASE + 0x10 + KSEG1)
#define XILLEON_UART1_REGS_BASE  (XILLEON_IPA_BASE + 0x0 + KSEG1)
#define XILLEON_UIRT_REGS_BASE  (XILLEON_IPA_BASE + 0x80 + KSEG1)

/* used to hardcoded IPA_BASE for STW3X22X boards */
#define XILLEON_STW3_IPA_BASE        0x1c600000 
#define XILLEON_STW3_UART0_REGS_BASE  (XILLEON_STW3_IPA_BASE + 0x10 + KSEG1)
#define XILLEON_STW3_UART1_REGS_BASE  (XILLEON_STW3_IPA_BASE + 0x0 + KSEG1)


#define XILLEON_NIM1_BASE       0x1c800000
#define XILLEON_NIM2_BASE       0x1cc00000
#define XILLEON_USER_FLASH_BASE 0x1d000000

#define XILLEON_CORE_FLASH_SIZE 0x00200000  // 2M
#define XILLEON_DOC_SIZE        0x00100000  // 1M
#define XILLEON_LCD_SIZE        0x00100000  // 1M
#define XILLEON_IPA_SIZE        0x00010000  // 64K
#define XILLEON_NIM1_SIZE       0x00400000  // 4M
#define XILLEON_NIM2_SIZE       0x00400000  // 4M
#define XILLEON_USER_FLASH_SIZE 0x01000000  // 16M
#define XILLEON_NAND_FLASH_SIZE 0x02000000


#ifdef CONFIG_IKOS
#define XILLEON_BASE_BAUD ( 97323 / 16 ) 
#else
#define XILLEON_BASE_BAUD ( 48000000 / 16 ) 
#endif
/*
 * Internal macros
 */
#define VAL2FLD(reg, field, val)		(((unsigned long)(val) << reg##__##field##__SHIFT) & reg##__##field##__MASK)
#define FLD2VAL(reg, field, val)		(((val) & reg##__##field##__MASK) >> reg##__##field##__SHIFT)
#define MODIFYFLD(var, reg, field, val)		(var = (var & (~reg##__##field##__MASK)) | (((unsigned long)(val) << reg##__##field##__SHIFT) & reg##__##field##__MASK))

/*
 * Macros for APER space access
 */

#define APER_READ_32(base,offset)  (*(volatile u32 *)((KSEG1)+(base)+(offset)))
#define APER_READ_16(base,offset)  (*(volatile u16 *)((KSEG1)+(base)+(offset)))
#define APER_READ_8(base,offset)   (*(volatile u8 *)((KSEG1)+(base)+(offset)))

#define APER_WRITE_32(base,offset,data)  (*(volatile u32 *)((KSEG1)+(base)+(offset)) = (data))
#define APER_WRITE_16(base,offset,data)  (*(volatile u16 *)((KSEG1)+(base)+(offset)) = (data))
#define APER_WRITE_8(base,offset,data)  (*(volatile u8 *)((KSEG1)+(base)+(offset)) = (data))

#define APER_PCU_BASE       (GETFLD_REGMM32(APER_CP_PCU_ADDR,BASE_ADDRESS)<<16)
#define APER_PCU_IPA_BASE   (GETFLD_REGMM32(APER_PCU_IPA_ADDR, BASE_ADDRESS)<<16)

/* Macros for PFLASH access */
/*#define PFLASH_BASE             0x0*/
#define PFLASH_BASE    (GETFLD_REGMM32(APER_PCU_PFLASH_ADDR,BASE_ADDRESS)<<16)

#define PFLASH_READ_32(offset)  APER_READ_32((APER_PCU_BASE+PFLASH_BASE),offset)
#define PFLASH_READ_16(offset)  APER_READ_16((APER_PCU_BASE+PFLASH_BASE),offset)
#define PFLASH_READ_8(offset)   APER_READ_8((APER_PCU_BASE+PFLASH_BASE),offset)

#define PFLASH_WRITE_32(offset,data) APER_WRITE_32((APER_PCU_BASE+PFLASH_BASE),offset,data)
#define PFLASH_WRITE_16(offset,data) APER_WRITE_16((APER_PCU_BASE+PFLASH_BASE),offset,data)
#define PFLASH_WRITE_8(offset,data)  APER_WRITE_8((APER_PCU_BASE+PFLASH_BASE),offset,data)

#define GETMEM_PFLASH_32(offset) PFLASH_READ_32(offset)
#define GETMEM_PFLASH_16(offset) PFLASH_READ_16(offset)
#define GETMEM_PFLASH_8(offset)  PFLASH_READ_8(offset)

#define SETMEM_PFLASH_32(offset,data) PFLASH_WRITE_32(offset,data)
#define SETMEM_PFLASH_16(offset,data) PFLASH_WRITE_16(offset,data)
#define SETMEM_PFLASH_8(offset,data) PFLASH_WRITE_8(offset,data)

/* Macros for SFLASH access */

/*#define SFLASH_BASE             0x0*/
#define SFLASH_BASE    (GETFLD_REGMM32(APER_PCU_SFLASH_ADDR,BASE_ADDRESS)<<16)

#define SFLASH_READ_32(offset)  APER_READ_32((APER_PCU_BASE+SFLASH_BASE),offset)
#define SFLASH_READ_16(offset)  APER_READ_16((APER_PCU_BASE+SFLASH_BASE),offset)
#define SFLASH_READ_8(offset)   APER_READ_8((APER_PCU_BASE+SFLASH_BASE),offset)

#define SFLASH_WRITE_32(offset,data) APER_WRITE_32((APER_PCU_BASE+SFLASH_BASE),offset,data)
#define SFLASH_WRITE_16(offset,data) APER_WRITE_16((APER_PCU_BASE+SFLASH_BASE),offset,data)
#define SFLASH_WRITE_8(offset,data)  APER_WRITE_8((APER_PCU_BASE+SFLASH_BASE),offset,data)

#define GETMEM_SFLASH_32(offset) SFLASH_READ_32(offset)
#define GETMEM_SFLASH_16(offset) SFLASH_READ_16(offset)
#define GETMEM_SFLASH_8(offset)  SFLASH_READ_8(offset)

#define SETMEM_SFLASH_32(offset,data) SFLASH_WRITE_32(offset,data)
#define SETMEM_SFLASH_16(offset,data) SFLASH_WRITE_16(offset,data)
#define SETMEM_SFLASH_8(offset,data) SFLASH_WRITE_8(offset,data)


/*
 * Macros for "register" I/O space
 */
#define GETREG_REGMM32(reg)       (*(volatile u32 *)(XILLEON_REGBASE + mm##reg))
#define SETREG_REGMM32(reg,value) (*(volatile u32 *)(XILLEON_REGBASE + mm##reg) = value)
#define GETREG_REGMM16(reg)       (*(volatile u16 *)(XILLEON_REGBASE + mm##reg))
#define SETREG_REGMM16(reg,value) (*(volatile u16 *)(XILLEON_REGBASE + mm##reg) = value)
#define GETREG_REGMM8(reg)        (*(volatile u8 *)(XILLEON_REGBASE + mm##reg))
#define SETREG_REGMM8(reg,value)  (*(volatile u8 *)(XILLEON_REGBASE + mm##reg) = value)

#define GETFLD_REGMM32(reg, field)	  (FLD2VAL(reg, field, GETREG_REGMM32(reg)))
#define SETFLD_REGMM32(reg, field, val)	  SETREG_REGMM32(reg, (GETREG_REGMM32(reg) & ~reg##__##field##__MASK) | VAL2FLD(reg, field, val))
#define GETFLAG_REGMM32(reg,field)	  (GETREG_REGMM32(reg) & reg##__##field##__MASK)
#define SETFLAG_REGMM32(reg,field)	  SETREG_REGMM32(reg, GETREG_REGMM32(reg) | reg##__##field##__MASK)
#define CLEARFLAG_REGMM32(reg,field)	  SETREG_REGMM32(reg, GETREG_REGMM32(reg) & ~reg##__##field##__MASK)
#define TOGGLEFLAG_REGMM32(reg,field)     SETREG_REGMM32(reg, GETREG_REGMM32(reg) ^ reg##__##field##__MASK)

#define GETFLD_REGMM16(reg, field)	  (FLD2VAL(reg, field, GETREG_REGMM16(reg)))
#define SETFLD_REGMM16(reg, field, val)	  SETREG_REGMM16(reg, (GETREG_REGMM16(reg) & ~reg##__##field##__MASK) | VAL2FLD(reg, field, val))
#define GETFLAG_REGMM16(reg,field)	  (GETREG_REGMM16(reg) & reg##__##field##__MASK)
#define SETFLAG_REGMM16(reg,field)	  SETREG_REGMM16(reg, GETREG_REGMM16(reg) | reg##__##field##__MASK)
#define CLEARFLAG_REGMM16(reg,field)	  SETREG_REGMM16(reg, GETREG_REGMM16(reg) & ~reg##__##field##__MASK)
#define TOGGLEFLAG_REGMM16(reg,field)     SETREG_REGMM16(reg, GETREG_REGMM16(reg) ^ reg##__##field##__MASK)

#define GETFLD_REGMM8(reg, field)	 (FLD2VAL(reg, field, GETREG_REGMM8(reg)))
#define SETFLD_REGMM8(reg, field, val)	 SETREG_REGMM8(reg, (GETREG_REGMM8(reg) & ~reg##__##field##__MASK) | VAL2FLD(reg, field, val))
#define GETFLAG_REGMM8(reg,field)	 (GETREG_REGMM8(reg) & reg##__##field##__MASK)
#define SETFLAG_REGMM8(reg,field)	 SETREG_REGMM8(reg, GETREG_REGMM8(reg) | reg##__##field##__MASK)
#define CLEARFLAG_REGMM8(reg,field)	 SETREG_REGMM8(reg, GETREG_REGMM8(reg) & ~reg##__##field##__MASK)
#define TOGGLEFLAG_REGMM8(reg,field)   	 SETREG_REGMM8(reg, GETREG_REGMM8(reg) ^ reg##__##field##__MASK)
/*
 * Registers for PCU IPA I/O space
 */
#define GETREG_PCUIPAMM32(reg)       (*(volatile u32 *)(KSEG1ADDR(XILLEON_IPA_BASE) + mmpcuipa##reg))
#define SETREG_PCUIPAMM32(reg,value) (*(volatile u32 *)(KSEG1ADDR(XILLEON_IPA_BASE) + mmpcuipa##reg) = value)
#define GETFLD_PCUIPAMM32(reg, field)	  (FLD2VAL(reg, field, GETREG_PCUIPAMM32(reg)))
#define SETFLD_PCUIPAMM32(reg, field, val)	  SETREG_PCUIPAMM32(reg, (GETREG_PCUIPAMM32(reg) & ~reg##__##field##__MASK) | VAL2FLD(reg, field, val))
#define GETFLAG_PCUIPAMM32(reg,field)	  (GETREG_PCUIPAMM32(reg) & reg##__##field##__MASK)
#define SETFLAG_PCUIPAMM32(reg,field)	  SETREG_PCUIPAMM32(reg, GETREG_PCUIPAMM32(reg) | reg##__##field##__MASK)
#define CLEARFLAG_PCUIPAMM32(reg,field)	  SETREG_PCUIPAMM32(reg, GETREG_PCUIPAMM32(reg) & ~reg##__##field##__MASK)
#define TOGGLEFLAG_PCUIPAMM32(reg,field)     SETREG_PCUIPAMM32(reg, GETREG_PCUIPAMM32(reg) ^ reg##__##field##__MASK)

#define WC_GETREG_REGMM32(reg)			     GETREG_REGMM32(reg)
#define WC_MODIFYFLD(regVal, reg, fld, val)          MODIFYFLD(regVal, reg, fld, val)
#define WC_SETREG_REGMM32(reg, val)		     SETREG_REGMM32(reg, val)


#define WC_GETREG_REGMM32(reg)			     GETREG_REGMM32(reg)
#define WC_MODIFYFLD(regVal, reg, fld, val)          MODIFYFLD(regVal, reg, fld, val)
#define WC_SETREG_REGMM32(reg, val)		     SETREG_REGMM32(reg, val)

#endif /* !(_MIPS_XILLEON_H) */



