#ifndef STW_FLASH_H
#define STW_FLASH_H



#define SPARE_AREA_L256_ECC0_OFFSET     0x0
#define SPARE_AREA_L256_ECC1_OFFSET     0x1
#define SPARE_AREA_L256_ECC2_OFFSET     0x2
#define SPARE_AREA_U256_ECC0_OFFSET     0x3
#define SPARE_AREA_VALID_BLOCK_OFFSET   0x5
#define SPARE_AREA_U256_ECC1_OFFSET     0x6
#define SPARE_AREA_U256_ECC2_OFFSET     0x7
#define SPARE_AREA_VALID_BLOCK_VALUE    0xFF


#define STW_MAX_NUM_BLOCKS              0x400
#define STW_NAND_BLOCK_NUM_SHIFT        0x5
#define BLOCK_NUM_TOTAL_SHIFT           (STW_NAND_BLOCK_NUM_SHIFT + \
                                         PFLASH_BE_ADDR__BLOCK_ERASE_ADDR__SHIFT) 
#define PFLASH_NAND_CS1_OFFSET          0x01000000




/* NOR flash bases */
#define NFLASH0_APER    0
#define NFLASH0_BASE    0x00000000
#define NFLASH1_APER    0
#define NFLASH1_BASE    0x00400000




/* The following portion is ported from ATI pmon pflash.h */


#define  uint32   uint32_t
#define  UINT32   uint32_t
#define  int32    int32_t
#define  uint8    uint8_t

#define  GETFLD   GETFLD_REGMM32
#define  SETFLD   SETFLD_REGMM32    
#define  GETREG   GETREG_REGMM32
#define  SETREG   SETREG_REGMM32

#define  GETMEM_PFLASHMM8    GETMEM_PFLASH_8  
#define  SETMEM_PFLASHMM8    SETMEM_PFLASH_8
#define  GETMEM_PFLASHMM32   GETMEM_PFLASH_32
#define  SETMEM_PFLASHMM32   SETMEM_PFLASH_32


#define  GETMEM_SFLASHMM8    GETMEM_SFLASH_8
#define  SETMEM_SFLASHMM8    SETMEM_SFLASH_8
#define  GETMEM_SFLASHMM32   GETMEM_SFLASH_32

#define  SETMEM_PCU0MM8
#define  SETMEM_PCU1MM8
#define  SETMEM_PCU2MM8
#define  SETMEM_PCU3MM8
#define  SETMEM_PCU4MM8
#define  SETMEM_PCU5MM8

#define  SETMEM_PCU0MM16
#define  SETMEM_PCU1MM16
#define  SETMEM_PCU2MM16
#define  SETMEM_PCU3MM16
#define  SETMEM_PCU4MM16
#define  SETMEM_PCU5MM16

#define  SETMEM_PCU0MM32
#define  SETMEM_PCU1MM32
#define  SETMEM_PCU2MM32
#define  SETMEM_PCU3MM32
#define  SETMEM_PCU4MM32
#define  SETMEM_PCU5MM32


#define  GETMEM_PCU0MM8
#define  GETMEM_PCU1MM8
#define  GETMEM_PCU2MM8
#define  GETMEM_PCU3MM8
#define  GETMEM_PCU4MM8
#define  GETMEM_PCU5MM8

#define  GETMEM_PCU0MM16
#define  GETMEM_PCU1MM16
#define  GETMEM_PCU2MM16
#define  GETMEM_PCU3MM16
#define  GETMEM_PCU4MM16
#define  GETMEM_PCU5MM16

#define  GETMEM_PCU0MM32
#define  GETMEM_PCU1MM32
#define  GETMEM_PCU2MM32
#define  GETMEM_PCU3MM32
#define  GETMEM_PCU4MM32
#define  GETMEM_PCU5MM32


#define PFF_ECC            (1<<0)
#define PFF_VERIFY         (1<<1)
#define PFF_ALLOW_ALL      (1<<2) /* debug only - will erase ibt */
#define PFF_ALLOW_MB       (1<<3) /* internal only - will erase mb */
#define PFF_ALLOW_IBT      (1<<4) /* internal only - will erase ibt */

#define PFLASH_PAGE_SIZE    0x200
#define PFLASH_VALID_BLOCK_VALUE        0xff
#define PFLASH_INVALID_BLOCK_VALUE      0xbd


/* flash numbers */
#define NFLASH0_NUM              0
#define NFLASH1_NUM              1
#define PFLASH0_NUM              8
#define PFLASH1_NUM              9
#define SFLASH_NUM               10

#define PFLASH0_MASK             (1<<PFLASH0_NUM)
#define PFLASH1_MASK             (1<<PFLASH1_NUM)
#define SFLASH_MASK              (1<<SFLASH_NUM)



/************************************************************************/

typedef enum
{
    CS0,
    CS1,
    CS_INVALID
}
CHIP_SEL;


enum
{
    PFLASH_CMD_BLOCK_ERASE=1,
    PFLASH_CMD_RESET=2,
    PFLASH_CMD_READ_STATUS=3,
    PFLASH_CMD_ID_READ =4,
};


enum
{
    PFLASH_OK=0,
    PFLASH_NOT_FOUND,
    PFLASH_TIME_OUT,
    PFLASH_SEPROM_BUSY,
    PFLASH_CMD_TRIG_BUSY,
    PFLASH_ID_STAT_DATA_ERROR,
    PFLASH_STATUS_ERROR,
    PFLASH_BLOCK_ERASE_NOT_DONE,
    PFLASH_RESET_NOT_DONE,
    PFLASH_BLOCK_INVALID,
    PFLASH_VERIFY_FAILED,
    PFLASH_READY_BUSY_TRANSITION_MISSED,
    PFLASH_IBT_NOT_FOUND,
    PFLASH_LAST_ERROR
};

/************************************************************************/

int pflashInit(void);
int pflashGetPcuMode(void);
uint32 pflashGetChipID(CHIP_SEL chipsel);
uint32 pflashGetTotalBlocks(void);
uint32 pflashGetTotalPages(void);
uint32 pflashGetBlockSizeInBytes(void);
uint32 pflashGetChipStartOffset(CHIP_SEL chipsel);
uint32 pflashGetBlockStartOffset(CHIP_SEL chipsel, uint32 block);
int pflashChipErase(CHIP_SEL chipsel, uint32 flags);
int pflashChipWrite(CHIP_SEL chipsel, uint32 block_start, char *addr, uint32 size, uint32 flags);
int pflashChipRead(CHIP_SEL chipsel, uint32 block_start, uint32 blocks, char *addr, uint32 flags);
int pflashBlockErase(CHIP_SEL chipsel, uint32 block, uint32 flags);
int pflashBlockEraseVerify(CHIP_SEL chipsel, uint32 block);
int pflashBlockRead(CHIP_SEL chipsel, uint32 block, char *buffer, uint32 flags);
int pflashBlockWrite(CHIP_SEL chipsel, uint32 block, char *buffer,  uint32 flags);
int pflashBlockVerify(CHIP_SEL chipsel, uint32 block, char *buffer, uint32 flags);
int pflashPageRead(CHIP_SEL chipsel, uint32 block, uint32 page, char *buffer, uint32 flags);
int pflashPageWrite(CHIP_SEL chipsel, uint32 block, uint32 page, char *buffer, uint32 flags);
int pflashPageVerify(CHIP_SEL chipsel, uint32 block, uint32 page, char *buffer, uint32 flags);
int pflashWaitCMDTriggerDone(void);
int pflashGetStatus(CHIP_SEL chipsel);
int pflashClearStateMachine(void);
char *pflashGetIdString(CHIP_SEL chipsel);
uint32 pflashGetChipSize(CHIP_SEL chipsel);
int pflashIsBlockInvalid(CHIP_SEL chipsel, uint32 block, uint32 flags);
int pflashSetBlockInvalid(CHIP_SEL chipsel, uint32 block);
int pflashAutoExec(void);
int pflashSetAutoExec(char *command, uint32 *rblock);
char *pflashGetAutoExec(uint32 *rblock);
int pflashGetBufferSize(uint32 imagesize);


int sflashInit(void);
int sflashGetPcuMode(void);
char *sflashGetIdString(void);
int sflashGetChipSize(void);
int sflashGetBlockSize(int block);
int sflashGetTotalBlocks(void);
int sflashGetBlockStartOffset(UINT32 block);
int sflashChipErase(void);
int sflashBlockErase(int block);
int sflashBlockEraseVerify(uint32 block);
int sflashChipWrite(uint32 block_start, char *addr, uint32 size);
int sflashBlockWrite(uint32 block, char *data);
int sflashBlockVerify(uint32 block, char *buffer);
int sflashChipRead(uint32 block_start, char *addr, uint32 blocks);
int sflashBlockRead(uint32 block, char *data);
int sflashCheckIdleAndSoftReset(void);
int sflashCheckStatusRegister(void);
int sflashCheckWriteInProgress(uint32 timeout);
void sflashReadEnableSequence(void);
int sflashGetBufferSize(uint32 imagesize);



#endif /* STW_FLASH_H */































