/*
 * linux/include/asm-arm/hardware/serial_pnx0105.h
 *
 * Internal header file for Philips IP_3106 VPB UART
 *
 * Copyright (C) 2003 Philips Semiconductors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef ASM_ARM_HARDWARE_SERIAL_IP3106_H
#define ASM_ARM_HARDWARE_SERIAL_IP3106_H

// -------------------------------------------------------------------------------
//  From Philips Semiconductors IP_3106 VPB UART Datasheet
// -------------------------------------------------------------------------------

//  UART Register Offsets.

#define IP3106_UART_RBR_REG               0x000  // R   - Receive Buffer Register
#define IP3106_UART_THR_REG               0x000  // W   - Transmitter Holding Register
#define IP3106_UART_DLL_REG               0x000  // R/W - Divisor Latch LSB
#define IP3106_UART_IER_REG               0x004  // R/W - Interrupt Enable Register
#define IP3106_UART_DLM_REG               0x004  // R/W - Divisor Latch MSB
#define IP3106_UART_IIR_REG               0x008  // R   - Interrupt Identification Register
#define IP3106_UART_FCR_REG               0x008  // W   - FIFO Control Register
#define IP3106_UART_LCR_REG               0x00C  // R/W - Line Control Register
#define IP3106_UART_MCR_REG               0x010  // R/W - Modem Control Register
#define IP3106_UART_LSR_REG               0x014  // R   - Line Status Register
#define IP3106_UART_MSR_REG               0x018  // R   - Modem Status Register
#define IP3106_UART_SCR_REG               0x01C  // R/W - Scratch Register
#define IP3106_UART_ACR_REG               0x020  // R/W - Auto-baud Control Register
#define IP3106_UART_ICR_REG               0x024  // R/W - IrDA Control Register
#define IP3106_UART_FDR_REG               0x028  // R/W - Fractional Divider Register
#define IP3106_UART_CFG_REG               0xFD4  // R   - Configuration Register
#define IP3106_UART_MID_REG               0xFFC  // R   - Module Identification Register


#define IP3106_UART_BEGIN_ADR_OF_BLOCK    0x0000
#define IP3106_UART_END_ADR_OF_BLOCK      0x1000
#define IP3106_UART_BLOCK_SIZE            (IP3106_UART_END_ADR_OF_BLOCK - IP3106_UART_BEGIN_ADR_OF_BLOCK)


//  IER Register definitions

#define IP3106_UART_IER_ABTOIE            0x200  // R/W - Auto-baud time-out interrupt enable
#define IP3106_UART_IER_ABEOIE            0x100  // R/W - End of auto-baud interrupt enable
#define IP3106_UART_IER_CTSIE             0x080  // R/W - Clear To Send interrupt enable
#define IP3106_UART_IER_MSIE              0x008  // R/W - Modem Status interrupt enable
#define IP3106_UART_IER_RLSIE             0x004  // R/W - Receiver Line Status interrupt enable
#define IP3106_UART_IER_THREIE            0x002  // R/W - Transmitter Holding Register Empty interrupt enable
#define IP3106_UART_IER_RDAIE             0x001  // R/W - Receive Data Available interrupt enable

//  IIR Register definitions

#define IP3106_UART_IIR_ABTOI             0x200  // R   - Auto-baud time-out interrupt
#define IP3106_UART_IIR_ABEOI             0x100  // R   - Auto-baud end of interrupt
#define IP3106_UART_IIR_FEN_MASK          0x0C0  // R   - Copies of FCR[0]
#define IP3106_UART_IIR_IID_MASK          0x00E  // R   - Interrupt Identification
#define IP3106_UART_IIR_IS                0x001  // R   - Interrupt Status

#define IP3106_UART_IIR_IID_CTO           0x00C  // R   - Character time-out
#define IP3106_UART_IIR_IID_RLS           0x006  // R   - Receiver Line Status
#define IP3106_UART_IIR_IID_RDA           0x004  // R   - Received Data Available
#define IP3106_UART_IIR_IID_THRE          0x002  // R   - Transmitter Holding Register Empty
#define IP3106_UART_IIR_IID_MS            0x000  // R   - Modem Status

//  FCR Register definitions

#define IP3106_UART_FCR_RTL_MASK          0x0C0  // W   - Receiver trigger level selection
#define IP3106_UART_FCR_DMAM              0x008  // W   - DMA mode select
#define IP3106_UART_FCR_TFRST             0x004  // W   - Transmitter FIFO reset
#define IP3106_UART_FCR_RFRST             0x002  // W   - Receiver FIFO reset
#define IP3106_UART_FCR_FEN               0x001  // W   - FIFO enable

//  LCR Register definitions

#define IP3106_UART_LCR_DLAB              0x080  // R/W - Divisor Latch Access
#define IP3106_UART_LCR_BRK               0x040  // R/W - Break control
#define IP3106_UART_LCR_PSTICK            0x020  // R/W - Parity stick selector
#define IP3106_UART_LCR_PEVEN             0x010  // R/W - Parity selector
#define IP3106_UART_LCR_PEN               0x008  // R/W - Parity enable
#define IP3106_UART_LCR_STOP              0x004  // R/W - Number of stop bits selector
#define IP3106_UART_LCR_WLEN_MASK         0x003  // R/W - Word length select

#define IP3106_UART_LCR_WLEN_8            0x003
#define IP3106_UART_LCR_WLEN_7            0x002
#define IP3106_UART_LCR_WLEN_6            0x001
#define IP3106_UART_LCR_WLEN_5            0x000

//  MCR Register definitions

#define IP3106_UART_MCR_ACTSEN            0x080  // R/W - Auto CTS flow control enable
#define IP3106_UART_MCR_ARTSEN            0x040  // R/W - Auto RTS flow control enable
#define IP3106_UART_MCR_LOOP              0x010  // R/W - Loop-back mode enable
#define IP3106_UART_MCR_OUT2              0x008  // R/W - Out2_n output
#define IP3106_UART_MCR_OUT1              0x004  // R/W - Out1_n output
#define IP3106_UART_MCR_RTS               0x002  // R/W - Request To Send
#define IP3106_UART_MCR_DTR               0x001  // R/W - Data Terminal Ready control

//  LSR Register definitions

#define IP3106_UART_LSR_RE                0x080  // R   - Receiver error
#define IP3106_UART_LSR_TEMT              0x040  // R   - Transmitter empty
#define IP3106_UART_LSR_THRE              0x020  // R   - Transmitter Holding Register empty
#define IP3106_UART_LSR_BI                0x010  // R   - Break indication
#define IP3106_UART_LSR_FE                0x008  // R   - Framing error
#define IP3106_UART_LSR_PE                0x004  // R   - Parity error
#define IP3106_UART_LSR_OE                0x002  // R   - Overrun error
#define IP3106_UART_LSR_DR                0x001  // R   - Data Ready

//  MSR Register definitions

#define IP3106_UART_MSR_DCD               0x080  // R   - Data Carrier Detect
#define IP3106_UART_MSR_RI                0x040  // R   - Ring Indicator
#define IP3106_UART_MSR_DSR               0x020  // R   - Data Set Ready
#define IP3106_UART_MSR_CTS               0x010  // R   - Clear To Send
#define IP3106_UART_MSR_DDCD              0x008  // R   - Delta Data Carrier Detect
#define IP3106_UART_MSR_TERI              0x004  // R   - Trailing Edge Ring Indicator
#define IP3106_UART_MSR_DDSR              0x002  // R   - Delta Data Set Ready
#define IP3106_UART_MSR_DCTS              0x001  // R   - Delta Clear To Send

//  ACR Register definitions

#define IP3106_UART_ACR_ABTOICLR          0x200  // W   - Auto-baud time-out interrupt clear
#define IP3106_UART_ACR_ABEOICLR          0x100  // W   - End of auto-baud interrupt clear
#define IP3106_UART_ACR_AUTORESTART       0x004  // R/W - Automatic restart mode
#define IP3106_UART_ACR_MODE              0x002  // R/W - Auto-baud mode
#define IP3106_UART_ACR_START             0x001  // R/W - Start Auto-baud

//  ICR Register definitions

#define IP3106_UART_ICR_PULSEDIV          0x038  // R/W - Configure pulse width
#define IP3106_UART_ICR_FIXPULSEN         0x004  // R/W - Enable IrDA fixed pulse width
#define IP3106_UART_ICR_IRDAINV           0x002  // R/W - Invert serial input
#define IP3106_UART_ICR_IRDAEN            0x001  // R/W - Enable IrDA

//  FDR Register definitions

#define IP3106_UART_FDR_MULVAL            0x0F0  // R/W - Baud-rate pre-scaler multiplier
#define IP3106_UART_FDR_DIVVAL            0x00F  // R/W - Baud-rate generation pre-scaler divisor

//  CFG Register definitions

#define IP3106_UART_CFG_HASIRDA          0x1000  // R   - 
#define IP3106_UART_CFG_HASLEVEL         0x0200  // R   - 
#define IP3106_UART_CFG_HASDMA           0x0100  // R   - 
#define IP3106_UART_CFG_MODEM            0x0030  // R   - 
#define IP3106_UART_CFG_TYPE             0x0003  // R   - 

//  MID Register definitions

#define IP3106_UART_MID_ID           0xFFFF0000  // R   - Unique identification number (=0x0C22=3106)
#define IP3106_UART_MID_MAJREV       0x0000F000  // R   - Major revision
#define IP3106_UART_MID_MINREV       0x00000F00  // R   - Minor revision
#define IP3106_UART_MID_APERTURE     0x000000FF  // R   - Aperture


#endif
