/*
 *  linux/include/asm-arm/hardware/serial_cintegrator.h
 *
 *  Internal header file for AMBA PL011D serial ports
 *
 *  Copyright (C) 2002 ARM Limited
 *  Copyright (C) 2000 Deep Blue Solutions Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef ASM_ARM_HARDWARE_SERIAL_AMBA_H
#define ASM_ARM_HARDWARE_SERIAL_AMBA_H

/* -------------------------------------------------------------------------------
 *  From AMBA UART (PL011) Block Specification (DDI 0183D)
 * -------------------------------------------------------------------------------
 *  UART Register Offsets.
 */
#define AMBA_UARTDR                     0x00	 /*  Data read or written from the interface. */
#define AMBA_UARTRSR                    0x04	 /*  Receive status register (Read). */
#define AMBA_UARTECR                    0x04	 /*  Error clear register (Write). */
#define AMBA_UARTFR                     0x18	 /*  Flag register (Read only). */
#define AMBA_UARTILPR                   0x20	 /*  IrDA low power counter register. */
#define AMBA_UARTIBRD                   0x24     /*  Integer baud rate divisor */
#define AMBA_UARTFBRD                   0x28     /*  Fractional baud rate divisor */
#define AMBA_UARTLCR_H                  0x2C	 /*  Line control register, high byte. */
#define AMBA_UARTCR                     0x30	 /*  Control register. */
#define AMBA_UARTIFLS                   0x34     /*  Interrupt FIFO level select register */
#define AMBA_UARTIMSC                   0x38     /*  Interrupt mask set/clear */
#define AMBA_UARTRIS                    0x3C     /*  Raw interrupt status */
#define AMBA_UARTMIS                    0x40     /*  Masked interrupt status */
#define AMBA_UARTICR                    0x44     /*  Interrupt clear register */
#define AMBA_UARTDMACR                  0x48     /*  DMA control register */

#define AMBA_UARTRSR_OE                 (1 << 3) /*  Overrun error */
#define AMBA_UARTRSR_BE                 (1 << 2) /*  Break error */
#define AMBA_UARTRSR_PE                 (1 << 1) /*  Parity error */
#define AMBA_UARTRSR_FE                 (1 << 0) /*  Framing error */

#define AMBA_UARTFR_TXFE                (1 << 7)
#define AMBA_UARTFR_RXFF                (1 << 6)
#define AMBA_UARTFR_TXFF                (1 << 5)
#define AMBA_UARTFR_RXFE                (1 << 4)
#define AMBA_UARTFR_BUSY                (1 << 3)
#define AMBA_UARTFR_DCD			(1 << 2)
#define AMBA_UARTFR_DSR			(1 << 1)
#define AMBA_UARTFR_CTS			(1 << 0)
#define AMBA_UARTFR_TMSK                (AMBA_UARTFR_TXFF + AMBA_UARTFR_BUSY)

#define AMBA_UARTCR_CTSEn               (1 << 15)
#define AMBA_UARTCR_RTSEn               (1 << 14)
#define AMBA_UARTCR_Out2                (1 << 13)
#define AMBA_UARTCR_Out1                (1 << 12)
#define AMBA_UARTCR_RTS                 (1 << 11)
#define AMBA_UARTCR_DTR                 (1 << 10)
#define AMBA_UARTCR_RXE                 (1 << 9)
#define AMBA_UARTCR_TXE                 (1 << 8)               
#define AMBA_UARTCR_LBE                 (1 << 7)
#define AMBA_UARTCR_SIRLP               (1 << 2)
#define AMBA_UARTCR_SIREN               (1 << 1)
#define AMBA_UARTCR_UARTEN              (1 << 0)
 
#define AMBA_UARTIMSC_OEIM              (1 << 10)
#define AMBA_UARTIMSC_BEIM              (1 << 9)
#define AMBA_UARTIMSC_PEIM              (1 << 8)
#define AMBA_UARTIMSC_FEIM              (1 << 7)
#define AMBA_UARTIMSC_RTIM              (1 << 6)
#define AMBA_UARTIMSC_TXIM              (1 << 5)
#define AMBA_UARTIMSC_RXIM              (1 << 4)
#define AMBA_UARTIMSC_DSRMIM            (1 << 3)
#define AMBA_UARTIMSC_DCDMIM            (1 << 2)
#define AMBA_UARTIMSC_CTSMIM            (1 << 1)
#define AMBA_UARTIMSC_RIMIM             (1 << 0)

#define AMBA_UARTMIS_OE                 (1 << 10)  /* Overrun Error masked interrupt */
#define AMBA_UARTMIS_BE                 (1 << 9)   /* Break Error */
#define AMBA_UARTMIS_PE                 (1 << 8)   /* Parity Error */
#define AMBA_UARTMIS_FE                 (1 << 7)   /* Framing Error */
#define AMBA_UARTMIS_RT                 (1 << 6)   /* Receive Timeout */
#define AMBA_UARTMIS_TX                 (1 << 5)   /* Transmit Masked Interrupt status */
#define AMBA_UARTMIS_RX                 (1 << 4)   /* Receive Masked Interrupt status */
#define AMBA_UARTMIS_DSRM               (1 << 3)   /* nUARTDSR modem masked interrupt */
#define AMBA_UARTMIS_DCDM               (1 << 2)   /* nUARTDCD modem masked interrupt */
#define AMBA_UARTMIS_CTSM               (1 << 1)   /* nUARTCTS modem masked interrupt */
#define AMBA_UARTMIS_RIM                (1 << 0)   /* nUARTRI  modem masked interrupt */

#define AMBA_UARTICR_OE                 (1 << 10)
#define AMBA_UARTICR_BE                 (1 << 9)
#define AMBA_UARTICR_PE                 (1 << 8)
#define AMBA_UARTICR_FE                 (1 << 7)
#define AMBA_UARTICR_RT                 (1 << 6)
#define AMBA_UARTICR_TX                 (1 << 5)
#define AMBA_UARTICR_RX                 (1 << 4)
#define AMBA_UARTICR_DSR                (1 << 3)
#define AMBA_UARTICR_DCD                (1 << 2)
#define AMBA_UARTICR_CTS                (1 << 1)
#define AMBA_UARTICR_RI                 (1 << 0)   /* nUARTRI Modem Interrupt clear */

#define AMBA_UARTLCR_H_SPS              (1 << 7)
#define AMBA_UARTLCR_H_WLEN_IDX         5
#define AMBA_UARTLCR_H_WLEN_MSK         (2 << AMBA_UARTLCR_H_WLEN_IDX)
#define AMBA_UARTLCR_H_WLEN_5           (0 << AMBA_UARTLCR_H_WLEN_IDX)
#define AMBA_UARTLCR_H_WLEN_6           (1 << AMBA_UARTLCR_H_WLEN_IDX)
#define AMBA_UARTLCR_H_WLEN_7           (2 << AMBA_UARTLCR_H_WLEN_IDX)
#define AMBA_UARTLCR_H_WLEN_8           (3 << AMBA_UARTLCR_H_WLEN_IDX)
#define AMBA_UARTLCR_H_FEN              (1 << 4)
#define AMBA_UARTLCR_H_STP2             (1 << 3)
#define AMBA_UARTLCR_H_EPS              (1 << 2)
#define AMBA_UARTLCR_H_PEN              (1 << 1)
#define AMBA_UARTLCR_H_BRK              (1 << 0)

#define AMBA_UARTDMACR_RXE              (1 << 0)
#define AMBA_UARTDMACR_TXE              (1 << 1)
#define AMBA_UARTDMACR_ERR              (1 << 2)


#define AMBA_UARTRSR_ANY	(AMBA_UARTRSR_OE|AMBA_UARTRSR_BE|AMBA_UARTRSR_PE|AMBA_UARTRSR_FE)
#define AMBA_UARTFR_MODEM_ANY	(AMBA_UARTFR_DCD|AMBA_UARTFR_DSR|AMBA_UARTFR_CTS)

#endif
