/*
 * linux/include/asm-arm/arch-sa1100/hrtime.h
 *
 * Author:	Nicolas Pitre
 * Created:	Jul 3, 2003
 * Copyright:	MontaVista Software, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <asm/hardware.h>


/*
 * The maximum resolution we can achieve is 1000000000 / 3686400 = 271.
 * Let give the system a bit of slack with 1000 (1 us) which is already
 * below the latency noise level anyway.
 */
#define hr_time_resolution  1000

#define arch_cycles_per_jiffy  (3686400 / HZ)

#define arch_cycle_to_nsec(cycles)  \
    (((cycles) * ((1000000000LL << 32) / 3686400)) >> 32)

#define nsec_to_arch_cycle(nsec)  \
    (((nsec) * ((3686400LL << 32) / 1000000000)) >> 32)

/* Note: OSMR0 is always the OSCR match value for jiffies+1 */
#define get_arch_cycles(ref)  ({  \
    long flags, cycles;  \
    local_irq_save(flags);  \
    cycles = (jiffies - (ref) + 1) * arch_cycles_per_jiffy + OSCR - OSMR0;  \
    local_irq_restore(flags);  \
    cycles;  })

#define schedule_jiffies_int(x) (get_arch_cycles(x) >= arch_cycles_per_jiffy)
	
extern int schedule_hr_timer_int(unsigned ref_jiffies, int cycles);
