/*
 * linux/include/asm-arm/arch-s3c2800/timex.h
 *
 * Copyright (C) 2002 SAMSUNG ELECTRONICS 
 *                           SW.LEE <hitchcar@sec.samsung.com>
 * 2003-2004 (c) MontaVista Software, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#if !defined(__ASM_ARCH_TIMEX_H)
#define __ASM_ARCH_TIMEX_H

#include <asm/arch/hardware.h>

/* These timer constants allow us to tolerate and compensate for
 * latencies as high as 1.3 seconds without any loss of accuracy
 * in system time keeping functions. However what we gain in accuracy,
 * we lose in precision, i.e. system time keeping precision is limited
 * to 20us for this case.
 */

#define TIMER2_PRESCALER	249
#define TIMER2_DIVIDER		4
#define	SYS_TIMER_MUX_1_n	SYS_TIMER_MUX_1_4

#define CLOCK_TICK_RATE	 	(PCLK/((TIMER2_PRESCALER+1)*(TIMER2_DIVIDER)))

#define TIMER2_COUNT		((CLOCK_TICK_RATE/HZ) - 1)

#endif
