/*
 * linux/include/asm-arm/arch-s3c2800/time.h
 *
 * Copyright (C) SAMSUNG ELECTRONICS 
 *                      SW.LEE <hitchcar@sec.samsung.com>
 * 2003-2004 (c) MontaVista Software, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <asm/system.h>
#include <asm/leds.h>
#include <asm/arch/timex.h>

unsigned short systimer_mark;

/*
 * Returns microsecond since last clock interrupt.
 * Note that interrupts will have been disabled by do_gettimeoffset()
 * IRQs are disabled before entering here from do_gettimeofday() 
 */
static unsigned long
s3c2800_gettimeoffset(void)
{
	unsigned short now = ~((unsigned short)(rTMCNT0));
	unsigned short delta = now - systimer_mark;

	return (unsigned long)(delta) * tick / (CLOCK_TICK_RATE / HZ);
}

/*
 * IRQ handler for the timer
 */
static void
s3c2800_timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
	unsigned short now = ~((unsigned short)(rTMCNT0));

	do {
		systimer_mark += TIMER2_COUNT + 1;
		barrier();
		do_timer(regs);
		do_leds();
		do_set_rtc();
		do_profile(regs);
	} while (unlikely((now - systimer_mark) > (TIMER2_COUNT)));
}

/*
 * Set up timer interrupt.
 */

static inline void
setup_timer(void)
{
	extern unsigned long (*gettimeoffset) (void);
	gettimeoffset = s3c2800_gettimeoffset;
	systimer_mark = 0;
	timer_irq.handler = s3c2800_timer_interrupt;
	timer_irq.flags = SA_INTERRUPT;

	rTMDMASEL = 0;

	/* Use timer0 for time stamp counter */
	rTMCON0 = SYS_TIMER_MUX_1_n;
	rTMDATA0 = (TIMER2_PRESCALER << 16) | 0xffff;

	/* Use timer2 for system timer interrupt */
	rTMCON2 = SYS_TIMER_MUX_1_n;
	rTMDATA2 = (TIMER2_PRESCALER << 16) | TIMER2_COUNT;

	setup_arm_irq(IRQ_TIMER2, &timer_irq);

	/* start the timers */
	rTMCON2 = SYS_TIMER_MUX_1_n | SYS_TIMER_COUNT_ENA | \
		  SYS_TIMER_INT_DMA_ENA;
	rTMCON0 = SYS_TIMER_MUX_1_n | SYS_TIMER_COUNT_ENA;
}
