/*
 * linux/include/asm-arm/arch-s3c2800/s3c2800.h
 *
 * Initially based on:
 *  linux-2.4.18-rmk6-swl6/include/asm-arm/arch-s3c2410/s3c2410.h
 *  Copyright (C) 2002 SAMSUNG ELECTORNICS
 *  SW.LEE (hitchcar@sec.samsung.com)
 *
 * Author: MontaVista Software, Inc. <source@mvista.com>
 *
 * 2003-2004 (c) MontaVista Software, Inc.
 *
 * This file is licensed under the terms of the GNU General Public
 * License version 2. This program is licensed "as is" without any
 * warranty of any kind, whether express or implied.
 */

#ifndef __S3C2800_H
#define __S3C2800_H

/* clock parameters */
#define  FCLK 200000000
#define  HCLK (FCLK/2)
#define  PCLK (HCLK/2)


#define PA_SDRAM_BASE	      0x08000000	/* sdram bank 0 */


/*
 * S3C2800 internal registers
 */

/* Be careful !!!!
 * PAGE_OFFSET + VMALLOC_END = 0xD0000000
 */

#define VA_IO_BASE0           (0xD0000000)
#define VA_IO_BASE1           (0xE0000000)

#define PA_CKPO_BASE          (0x10000000)
#define VA_CKPO_BASE          (VA_IO_BASE0+0x00000000)

#define PA_MEM_CTR_BASE       (0x10010000)
#define VA_MEM_CTR_BASE       (VA_IO_BASE0+0x00010000)

#define PA_INT_BASE           (0x10020000)
#define VA_INT_BASE           (VA_IO_BASE0+0x00020000)

#define PA_DMA_BASE           (0x10030000)
#define VA_DMA_BASE           (VA_IO_BASE0+0x00030000)

#define PA_PCI_BASE           (0x10080000)
#define VA_PCI_BASE           (VA_IO_BASE0+0x00080000)

#define PA_IO_PORT_BASE       (0x10100000)
#define VA_IO_PORT_BASE       (VA_IO_BASE1+0x00100000)

#define PA_RRCR_BASE          (0x10110000)
#define VA_RRCR_BASE          (VA_IO_BASE1+0x00110000)

#define PA_WD_BASE            (0x10120000)
#define VA_WD_BASE            (VA_IO_BASE1+0x00120000)

#define PA_TIMER_BASE         (0x10130000)
#define VA_TIMER_BASE         (VA_IO_BASE1+0x00130000)

#define PA_RTC_BASE           (0x10160000)
#define VA_RTC_BASE           (VA_IO_BASE1+0x00160000)

#define PA_UART_BASE          (0x10170000)
#define VA_UART_BASE          (VA_IO_BASE1+0x00170000)

#define PA_IIC_BASE           (0x10190000)
#define VA_IIC_BASE           (VA_IO_BASE1+0x00190000)

#define VA_MEM_CTR(offset)  (*(volatile unsigned *)(VA_MEM_CTR_BASE+(offset)))

/* Memory control */
#define rENDIAN		VA_MEM_CTR(0x00) /* endian control */
#define rSMBCON0	VA_MEM_CTR(0x04) /* bank 0 control */
#define rSMBCON1	VA_MEM_CTR(0x08) /* bank 1 control */
#define rSMBCON2	VA_MEM_CTR(0x0c) /* bank 2 control */
#define rSMBCON3	VA_MEM_CTR(0x10) /* bank 3 control */
#define rREFRESH	VA_MEM_CTR(0x14) /* DRAM/SDRAM refresh control */
#define rDMTMCON	VA_MEM_CTR(0x18) /* dynamic memory timing control */
#define rMRSR		VA_MEM_CTR(0x1c) /* memory mode select */


/* interrupt */
#define VA_INT(offset)  (*(volatile unsigned *)(VA_INT_BASE+(offset)))

#define rSRCPND     VA_INT(0x00) /* Interrupt request status */
#define rINTMOD     VA_INT(0x04) /* Interrupt mode control */
#define rINTMSK     VA_INT(0x08) /* Interrupt mask control */
#define rIRQPND     VA_INT(0x0c) /* IRQ interrupt service pending */
#define rFIQPND     VA_INT(0x10) /* FIQ interrupt service pending */


/* remote control reciever */
#define VA_RRCR(offset)  (*(volatile unsigned *)(VA_RRCR_BASE+(offset)))

#define rRRCR	VA_RRCR(0x00) /* remote control receiver control */
#define rFIFOD  VA_RRCR(0x04) /* fifo data register */

/* DMA */
#define VA_DMA(chan, offset)	\
  (*(volatile unsigned *)(VA_DMA_BASE+(0x10000*chan)+(offset)))

#define VA_DMA_0(offset)	VA_DMA(0, offset)
#define VA_DMA_1(offset)	VA_DMA(1, offset)
#define VA_DMA_2(offset)	VA_DMA(2, offset)
#define VA_DMA_3(offset)	VA_DMA(3, offset)

/* DMA Device Address Reg. channel [0..3] */
#define DMASp   	0x10000	  /* DMA control reg. space (bytes) */
#define ARRAY_DISRC(ch)	((volatile unsigned *)(VA_DMA_BASE+(ch)*DMASp))

#define rDISRC0     VA_DMA_0(0x00) 	/* DMA 0 Initial source */
#define rDIDST0     VA_DMA_0(0x04) 	/* DMA 0 Initial Destination */
#define rDCON0      VA_DMA_0(0x08) 	/* DMA 0 Control */
#define rDSTAT0     VA_DMA_0(0x0c)	/* DMA 0 Status */
#define rDCSRC0     VA_DMA_0(0x10)	/* DMA 0 Current source */
#define rDCDST0     VA_DMA_0(0x14)	/* DMA 0 Current destination */
#define rDMASKTRIG0 VA_DMA_0(0x18)	/* DMA 0 Mask trigger */

#define rDISRC1     VA_DMA_1(0x00) 	/* DMA 1 Initial source */
#define rDIDST1     VA_DMA_1(0x04) 	/* DMA 1 Initial Destination */
#define rDCON1      VA_DMA_1(0x08) 	/* DMA 1 Control */
#define rDSTAT1     VA_DMA_1(0x0c)	/* DMA 1 Status */
#define rDCSRC1     VA_DMA_1(0x10)	/* DMA 1 Current source */
#define rDCDST1     VA_DMA_1(0x14)	/* DMA 1 Current destination */
#define rDMASKTRIG1 VA_DMA_1(0x18)	/* DMA 1 Mask trigger */

#define rDISRC2     VA_DMA_2(0x00) 	/* DMA 2 Initial source */
#define rDIDST2     VA_DMA_2(0x04) 	/* DMA 2 Initial Destination */
#define rDCON2      VA_DMA_2(0x08) 	/* DMA 2 Control */
#define rDSTAT2     VA_DMA_2(0x0c)	/* DMA 2 Status */
#define rDCSRC2     VA_DMA_2(0x10)	/* DMA 2 Current source */
#define rDCDST2     VA_DMA_2(0x14)	/* DMA 2 Current destination */
#define rDMASKTRIG2 VA_DMA_2(0x18)	/* DMA 2 Mask trigger */

#define rDISRC3     VA_DMA_3(0x00) 	/* DMA 3 Initial source */
#define rDIDST3     VA_DMA_3(0x04) 	/* DMA 3 Initial Destination */
#define rDCON3      VA_DMA_3(0x08) 	/* DMA 3 Control */
#define rDSTAT3     VA_DMA_3(0x0c)	/* DMA 3 Status */
#define rDCSRC3     VA_DMA_3(0x10)	/* DMA 3 Current source */
#define rDCDST3     VA_DMA_3(0x14)	/* DMA 3 Current destination */
#define rDMASKTRIG3 VA_DMA_3(0x18)	/* DMA 2 Mask trigger */

/* DMA channel status */
#define DSTAT_STAT_READY      0x000000         
#define DSTAT_STAT_BUSY       0x100000         

/* DMA mask trigger register */
#define DMASKTRIG_STOP        0x4 /* bits 100 */
#define DMASKTRIG_START       0x0
#define DMASKTRIG_ON          0x2 /* bits 010 */
#define DMASKTRIG_OFF         0x0
#define DMASKTRIG_NO_SW_TRIG  0x0

/* DMA control register flag */
#define DCON_HS_MODE        ( 0x1 << 30)
#define DCON_SYNC_AHB       ( 0x1 << 29)
#define DCON_INT_ENABLE     ( 0x1 << 28)
#define DCON_TSZ_BURST      ( 0x1 << 27)
#define DCON_WHSR_MODE      ( 0x1 << 26)
#define DCON_HWSRCSEL_I2SDO ( 0x00 << 24)
#define DCON_HW_SEL         ( 0x1 << 23)
#define DCON_NO_AUTO_RELOAD ( 0x1 << 22)
#define DCON_DSZ_HWORD      ( 0x1 << 20)


/* clock & power management */
#define VA_CKPO(offset)    (*(volatile unsigned *)(VA_CKPO_BASE+(offset)))
#define PA_CKPO(offset)    (*(volatile unsigned *)(PA_CKPO_BASE+(offset)))

#define rPLLCON		VA_CKPO(0x00) /* PLL Control */
#define rCLKCON		VA_CKPO(0x04) /* clock generator control */
#define rCLKSLOW	VA_CKPO(0x08) /* slow clock control */
#define rLOCKTIME	VA_CKPO(0x0c) /* PLL lock time counter */
#define rSWRCON		VA_CKPO(0x10) /* software reset control */
#define rRSTST		VA_CKPO(0x14) /* reset status regster */

/* clkcon bits */
#define CLKCON_PCLK	(1 << 12)
#define CLKCON_HCLK	(1 << 11)
#define CLKCON_PCI	(1 << 10)
#define CLKCON_IIC1	(1 << 9)
#define CLKCON_IIC0	(1 << 8)
#define CLKCON_RTC	(1 << 7)
#define CLKCON_UART1	(1 << 6)
#define CLKCON_UART0	(1 << 5)
#define CLKCON_DMA23	(1 << 4)
#define CLKCON_DMA01	(1 << 3)
#define CLKCON_TIMER	(1 << 2)
#define CLKCON_IDLE_BIT	(1 << 1)

/* UART */
#define VA_UART(dt, n, offset)	\
    (*(volatile dt *)(VA_UART_BASE+(0x10000*n)+(offset)))

#define VA_UART_0(offset)	VA_UART(unsigned, 0, offset)
#define VA_UART_1(offset)	VA_UART(unsigned, 1, offset)

#define VA_UART_0_B(offset)	VA_UART(char, 0, offset)
#define VA_UART_1_B(offset)	VA_UART(char, 1, offset)

#define rULCON0     VA_UART_0(0x00) /* UART 0 Line control */
#define rUCON0      VA_UART_0(0x04) /* UART 0 Control */
#define rUFCON0     VA_UART_0(0x08) /* UART 0 FIFO control */
#define rUMCON0     VA_UART_0(0x0c) /* UART 0 Modem control */
#define rUTRSTAT0   VA_UART_0(0x10) /* UART 0 Tx/Rx status */
#define rUERSTAT0   VA_UART_0(0x14) /* UART 0 Rx error status */
#define rUFSTAT0    VA_UART_0(0x18) /* UART 0 FIFO status */
#define rUMSTAT0    VA_UART_0(0x1c) /* UART 0 Modem status */
#define rUBRDIV0    VA_UART_0(0x28) /* UART 0 Baud rate divisor */

#define rULCON1     VA_UART_1(0x00) /* UART 1 Line control */
#define rUCON1      VA_UART_1(0x04) /* UART 1 Control */
#define rUFCON1     VA_UART_1(0x08) /* UART 1 FIFO control */
#define rUMCON1     VA_UART_1(0x0c) /* UART 1 Modem control */
#define rUTRSTAT1   VA_UART_1(0x10) /* UART 1 Tx/Rx status */
#define rUERSTAT1   VA_UART_1(0x14) /* UART 1 Rx error status */
#define rUFSTAT1    VA_UART_1(0x18) /* UART 1 FIFO status */
#define rUMSTAT1    VA_UART_1(0x1c) /* UART 1 Modem status */
#define rUBRDIV1    VA_UART_1(0x28) /* UART 1 Baud rate divisor */

#ifdef __BIG_ENDIAN
#define rUTXH0  VA_UART_0_B(0x23) /* UART 0 Transmission Hold */
#define rURXH0  VA_UART_0_B(0x27) /* UART 0 Receive buffer */
#else /* Little Endian */
#define rUTXH0	VA_UART_0_B(0x20) /* UART 0 Transmission Hold */
#define rURXH0	VA_UART_0_B(0x24) /* UART 0 Receive buffer */
#endif

#ifdef __BIG_ENDIAN
#define rUTXH1  VA_UART_1_B(0x23) /* UART 1 Transmission Hold */
#define rURXH1  VA_UART_1_B(0x27) /* UART 1 Receive buffer */
#else /* Little Endian */
#define rUTXH1	VA_UART_1_B(0x20) /* UART 1 Transmission Hold */
#define rURXH1	VA_UART_1_B(0x24) /* UART 1 Receive buffer */
#endif


/* timer */
#define VA_TIMER(t, offset)	\
    (*(volatile unsigned *)(VA_TIMER_BASE+(0x10000*t)+(offset)))

#define VA_TIMER_ADDR(t, offset)	\
    ((volatile unsigned *)(VA_TIMER_BASE+(0x10000*t)+(offset)))

#define rTMDMASEL	VA_TIMER(0, 0x0c) /* dma or interrupt mode selection */

#define VA_TIMER_0(offset)	VA_TIMER(0, offset)
#define VA_TIMER_1(offset)	VA_TIMER(1, offset)
#define VA_TIMER_2(offset)	VA_TIMER(2, offset)

#define rTMCON0		VA_TIMER_0(0x00)
#define rTMDATA0	VA_TIMER_0(0x04)
#define rTMCNT0		VA_TIMER_0(0x08)

#define rTMCON1		VA_TIMER_1(0x00)
#define rTMDATA1	VA_TIMER_1(0x04)
#define rTMCNT1		VA_TIMER_1(0x08)

#define rTMCON2		VA_TIMER_2(0x00)
#define rTMDATA2	VA_TIMER_2(0x04)
#define rTMCNT2		VA_TIMER_2(0x08)

#define SYS_TIMER_COUNT_ENA	(1 << 0)
#define SYS_TIMER_INT_DMA_ENA	(1 << 1)
#define SYS_TIMER_MUX_1_4	(0 << 2)	/* PCLK/4  */
#define SYS_TIMER_MUX_1_8	(1 << 2)	/* PCLK/8  */
#define SYS_TIMER_MUX_1_16	(2 << 2)	/* PCLK/16  */
#define SYS_TIMER_MUX_1_32	(3 << 2)	/* PCLK/32  */


/* watch dog timer */
#define VA_WD(offset)    (*(volatile unsigned *)(VA_WD_BASE+(offset)))

#define rWTPSCLR	VA_WD(0x00) /* Watch-dog timer prescaler value */
#define rWTCON		VA_WD(0x04) /* Watch-dog timer mode */
#define rWTCNT		VA_WD(0x08) /* Eatch-dog timer count */


/* IIC */
#define VA_IIC(n, offset)	\
    (*(volatile unsigned *)(VA_IIC_BASE+(0x10000*n)+(offset)))

#define VA_IIC_0(offset)	VA_IIC(0, offset)
#define VA_IIC_1(offset)	VA_IIC(1, offset)

#define rIICCON0  VA_IIC(0, 0x00) /* IIC control */
#define rIICSTAT0 VA_IIC(0, 0x04) /* IIC status */
#define rIICADD0  VA_IIC(0, 0x08) /* IIC address */
#define rIICDS0   VA_IIC(0, 0x0c) /* IIC data shift */

#define rIICCON1  VA_IIC(1, 0x00) /* IIC control */
#define rIICSTAT1 VA_IIC(1, 0x04) /* IIC status */
#define rIICADD1  VA_IIC(1, 0x08) /* IIC address */
#define rIICDS1   VA_IIC(1, 0x0c) /* IIC data shift */


/*-----------------------------------------------------*/

/* GPIO ports */
#define VA_IO_PORT(offset)  (*(volatile unsigned *)(VA_IO_PORT_BASE+(offset)))

#define rPCONA    VA_IO_PORT(0x00) /* Port A control */
#define rPDATA    VA_IO_PORT(0x04) /* Port A data */
#define rPUPA     VA_IO_PORT(0x08) /* Pull-up control A */

#define rPCONB    VA_IO_PORT(0x0c) /* Port B control */
#define rPDATB    VA_IO_PORT(0x10) /* Port B data */

#define rPCONC    VA_IO_PORT(0x18) /* Port C control */
#define rPDATC    VA_IO_PORT(0x1c) /* Port C data */
#define rPUPC     VA_IO_PORT(0x20) /* Pull-up control C */

#define rPCOND    VA_IO_PORT(0x24) /* Port D control */
#define rPDATD    VA_IO_PORT(0x28) /* Port D data */
#define rPUPD     VA_IO_PORT(0x2c) /* Pull-up control D */

#define rPCONE    VA_IO_PORT(0x30) /* Port E control */
#define rPDATE    VA_IO_PORT(0x34) /* Port E data */
#define rPUPE     VA_IO_PORT(0x3c) /* Pull-up control E */

#define rPCONF    VA_IO_PORT(0x3c) /* Port F control */
#define rPDATF    VA_IO_PORT(0x40) /* Port F data */
#define rPUPF     VA_IO_PORT(0x44) /* Pull-up control F */

#define rEXTINTR   VA_IO_PORT(0x48) /* External interrupt control register */
#define rSPUCR   VA_IO_PORT(0x4c) /* special pull-up control register */

//#define rMISCCR    VA_IO_PORT(0x80) //Miscellaneous control
//#define rDCLKCON   VA_IO_PORT(0x84) //DCLK0/1 control
//#define rEXTINT1   VA_IO_PORT(0x8c) //External interrupt control register 1
//#define rEXTINT2   VA_IO_PORT(0x90) //External interrupt control register 2
//#define rEINTFLT0  VA_IO_PORT(0x94) //Reserved
//#define rEINTFLT1  VA_IO_PORT(0x98) //Reserved
//#define rEINTFLT2  VA_IO_PORT(0x9c) //External interrupt filter control register 2
//#define rEINTFLT3  VA_IO_PORT(0xa0) //External interrupt filter control register 3
//#define rEINTMSK  VA_IO_PORT(0xa4) //External interrupt mask
//#define rEINTPND  VA_IO_PORT(0xa8) //External interrupt pending
//#define rGSTATUS0  VA_IO_PORT(0xac) //External pin status
//#define rGSTATUS1  VA_IO_PORT(0xb0) //Chip ID(0x32800000)
//#define rGSTATUS2  VA_IO_PORT(0xb4) //Reset type
//#define rGSTATUS3  VA_IO_PORT(0xb8) //Saved data0(32-bit) before entering POWER_OFF mode 
//#define rGSTATUS4  VA_IO_PORT(0xbc) //Saved data0(32-bit) before entering POWER_OFF mode 


/* RTC */
#ifdef __BIG_ENDIAN
#define VA_RTC(offset)  (*(volatile char *)(VA_RTC_BASE+(offset)+3))
#else
#define VA_RTC(offset)  (*(volatile char *)(VA_RTC_BASE+(offset)))
#endif

#define rRTCCON    VA_RTC(0x00) /* RTC control */
#define rRTCALM    VA_RTC(0x04) /* RTC alarm control */
#define rALMSEC    VA_RTC(0x08) /* Alarm second */
#define rALMMIN    VA_RTC(0x0c) /* Alarm minute */
#define rALMHOUR   VA_RTC(0x10) /* Alarm Hour */
#define rALMDAY    VA_RTC(0x14) /* Alarm day */
#define rALMMON    VA_RTC(0x18) /* Alarm month */
#define rALMYEAR   VA_RTC(0x1c) /* Alarm year */
#define rBCDSEC    VA_RTC(0x20) /* BCD second */
#define rBCDMIN    VA_RTC(0x24) /* BCD minute */
#define rBCDHOUR   VA_RTC(0x28) /* BCD hour */
#define rBCDDAY    VA_RTC(0x2c) /* BCD day */
#define rBCDDATE   VA_RTC(0x30) /* BCD date */
#define rBCDMON    VA_RTC(0x34) /* BCD month */
#define rBCDYEAR   VA_RTC(0x38) /* BCD year */
#define rTICNT     VA_RTC(0x40) /* Tick time count */
#define rRTCRST    VA_RTC(0x44) /* RTC round reset */


/* PCI */
#define VA_PCI(offset)  (*(volatile unsigned *)(VA_PCI_BASE+(offset)))

#define rPCIVDIDR    VA_PCI(0x00) /* PCI vendor */
#define rPCISCR		VA_PCI(0x04) /* PCI status and command */
#define rPCICRIDR    VA_PCI(0x08) /* PCI class code and revision */
#define rPCIGCONR    VA_PCI(0x0c) /* PCI general control */
#define rPCIBAR0    VA_PCI(0x10) /* PCI memory bar 0 */
#define rPCIBAR1    VA_PCI(0x14) /* PCI memory bar 0 */
#define rPCIBAR2    VA_PCI(0x18) /* PCI memory bar 0 */
#define rPCISSVIDR    VA_PCI(0x2c) /* PCI subsystem */
#define rPCICPR    VA_PCI(0x34) /* PCI subsystem */
#define rPCIMISCR    VA_PCI(0x3c) /* PCI subsystem */
#define rPCITOR    VA_PCI(0x40) /* PCI subsystem */

#define rPCICON    VA_PCI(0x100) /* PCI control and status */
#define rPCISET    VA_PCI(0x104) /* PCI command */
#define rPCIINTEN    VA_PCI(0x108)
#define rPCIINTST    VA_PCI(0x10c)
#define rPCIINTAD    VA_PCI(0x110)
#define rPCIATAPM    VA_PCI(0x114)
#define rPCIATAPI    VA_PCI(0x118)
#define rPCIBELAP    VA_PCI(0x128)
#define rPCIATPA0    VA_PCI(0x140)
#define rPCIBAM0    VA_PCI(0x144)
#define rPCIATAPA1    VA_PCI(0x148)
#define rPCIBAM1    VA_PCI(0x14c)
#define rPCIATAPA2    VA_PCI(0x150)
#define rPCIBAM2    VA_PCI(0x154)

/*  Used in serial_s3c2800.c ,uncompress.h */
#define SER_BAUD_9600    9600 
#define SER_BAUD_19200   19200
#define SER_BAUD_38400   38400
#define SER_BAUD_57600   57600
#define SER_BAUD_115200  115200
#define CURRENT_BAUD_RATE  SER_BAUD_115200 

#endif /* __S3C2800_H */
