/*
 * linux/include/asm-arm/arch-pnx0105/uncompress.h
 *
 * Copyright (C) 2003 Philips Semiconductors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//  IP_3106 UART Register Offsets.

#define IP3106_UART_RBR_REG         0x00000000  // R   - Receive Buffer Register
#define IP3106_UART_THR_REG         0x00000000  // W   - Transmitter Holding Register
#define IP3106_UART_DLL_REG         0x00000000  // R/W - Divisor Latch LSB
#define IP3106_UART_IER_REG         0x00000004  // R/W - Interrupt Enable Register
#define IP3106_UART_DLM_REG         0x00000004  // R/W - Divisor Latch MSB
#define IP3106_UART_IIR_REG         0x00000008  // R   - Interrupt Identification Register
#define IP3106_UART_FCR_REG         0x00000008  // W   - FIFO Control Register
#define IP3106_UART_LCR_REG         0x0000000C  // R/W - Line Control Register
#define IP3106_UART_MCR_REG         0x00000010  // R/W - Modem Control Register
#define IP3106_UART_LSR_REG         0x00000014  // R   - Line Status Register
#define IP3106_UART_MSR_REG         0x00000018  // R   - Modem Status Register
#define IP3106_UART_SCR_REG         0x0000001C  // R/W - Scratch Register
#define IP3106_UART_ACR_REG         0x00000020  // R/W - Auto-baud Control Register
#define IP3106_UART_ICR_REG         0x00000024  // R/W - IrDA Control Register
#define IP3106_UART_FDR_REG         0x00000028  // R/W - Fractional Divider Register
#define IP3106_UART_CFG_REG         0x00000FD4  // R   - Configuration Register
#define IP3106_UART_MID_REG         0x00000FFC  // R   - Module Identification Register



#define IP3106_UART0_BASE_ADDRESS   0x15000000

#define IP3106_UART_TX_CHAR         (*(volatile unsigned char *)(IP3106_UART0_BASE_ADDRESS + IP3106_UART_THR_REG))
#define IP3106_UART_GET_LSR         (*(volatile unsigned char *)(IP3106_UART0_BASE_ADDRESS + IP3106_UART_LSR_REG))



/*
 * This does not append a newline
 */
static void puts(const char *s)
{
    while (*s) {
        IP3106_UART_TX_CHAR = *s;
        while ((IP3106_UART_GET_LSR & (1 << 6)) == 0)
            barrier();
        if (*s == '\n') {
            IP3106_UART_TX_CHAR = '\r';
            while ((IP3106_UART_GET_LSR & (1 << 6)) == 0)
                barrier();
        }
        s++;
    }
}

/*
 * nothing to do
 */
#define arch_decomp_setup()

#define arch_decomp_wdog()
