/* 
 * linux/include/asm-arm/arch-pnx0105/platform.h
 *
 * Copyright (C) 2003 Philips Semiconductors
 *
 * Modified by Vitaly Wool <vwool@ru.mvista.com> to enable HRT/WDT/RTC
 * Copyright (C) 2004 MontaVista Software, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __address_h
#define __address_h                 1

//--------------------------------------------------------------------------------
// PNX0105 memory map
//--------------------------------------------------------------------------------

// AHB0 [0x00000000:0x7FFFFFFF]
// AHB1 [0x80000000:0x9FFFFFFF]


// AHB0 SLAVE PORT 3
//------------------

#define INTC_BASE            0x00001000	 // Interrupt Controller
#define INTC_LENGTH          0x00001000

// AHB0 SLAVE PORT 4
//------------------

#define ADSS_AHB_BASE        0x10000000
#define ADSS_AHB_LENGTH      0x00100000

// AHB0 SLAVE PORT 5
//------------------

#define ISRAM_BASE           0x11000000
#define ISRAM_LENGTH         0x00010000   // 64 KByte
#define SIMCTL_BASE          0x1100FFE0
#define SIMCTL_LENGTH        0x00000020

// AHB0 SLAVE PORT 6
//------------------

#define ISROM_BASE           0x12000000
#define ISROM_LENGTH         0x00008000   // 32 KByte

// AHB0 SLAVE PORT 0 - VPB 0 bus [0x13000000:0x13007FFF]
//------------------------------------------------------

#define EROUTER_BASE         0x13000000	 // Event Router
#define EROUTER_LENGTH       0x00002000

#define RTC_BASE             0x13002000	 // Real Time Clock
#define RTC_LENGTH           0x00000400

#define ADC_BASE             0x13002400	 // Analog Digital Converter
#define ADC_LENGTH           0x00000400

#define WDOG_BASE            0x13002800	 // Watch Dog
#define WDOG_LENGTH          0x00000400

#define SYSCTL_BASE          0x13002C00	 // System Controller registers
#define SYSCTL_LENGTH        0x00000400

#define IOCONF_BASE          0x13003000	 // IO Configuration
#define IOCONF_LENGTH        0x00001000

#define CGU_TOTAL_BASE       0x13004000	 // CGU plus CGUSWITCHBOX
#define CGU_TOTAL_LENGTH     0x00001000

// AHB0 SLAVE PORT 0 - VPB 1 bus [0x13008000:0x13008FFF]
//------------------------------------------------------

#define CT0_BASE             0x13008000	 // Counter/Timer 0
#define CT0_LENGTH           0x00000400

#define CT1_BASE             0x13008400	 // Counter/Timer 1
#define CT1_LENGTH           0x00000400

#define I2C0_BASE            0x13008800	 // I2C 0
#define I2C0_LENGTH          0x00000400

#define I2C1_BASE            0x13008C00	 // I2C 1
#define I2C1_LENGTH          0x00000400

// AHB0 SLAVE PORT 1 - VPB 2 bus [0x15000000:0x15003FFF]
//------------------------------------------------------

#define UART_BASE            0x15000000	 // UART
#define UART_LENGTH          0x00001000

#define SPI_BASE             0x15001000	 // SPI
#define SPI_LENGTH           0x00001000

#define LCD_BASE             0x15002000	 // LCD
#define LCD_LENGTH           0x00000400

#define SDMA_BASE            0x15002800	 // SDMA
#define SDMA_LENGTH          0x00000800

// AHB0 SLAVE PORT 2 - VPB 3 bus [0x16000000:0x160003FF]
//------------------------------------------------------

#define SAI0_BASE            0x16000000	 // Simple Audio Input 0
#define SAI0_LENGTH          0x00000080

#define SAI1_BASE            0x16000080	 // Simple Audio Input 1
#define SAI1_LENGTH          0x00000080

#define SAI2_BASE            0x16000100	 // Simple Audio Input 2
#define SAI2_LENGTH          0x00000080

#define SAO0_BASE            0x16000200	 // Simple Audio Output 0
#define SAO0_LENGTH          0x00000080

#define SAO1_BASE            0x16000280	 // Simple Audio Output 1
#define SAO1_LENGTH          0x00000080

#define CREG_BASE            0x16000380	 //
#define CREG_LENGTH          0x00000080

// AHB0 SLAVE PORT 7
//------------------

#define FLASH0_BASE          0x20000000	 //
#define FLASH0_LENGTH        0x00200000   // 2 MByte

#define SRAM0_BASE           0x24000000	 //
#define SRAM0_LENGTH         0x00200000   // 2 MByte

#define SPARE0_BASE          0x28000000	 //
#define SPARE0_LENGTH        0x00200000   // 2 MByte

#define SDRAM0_BASE          0x30000000	 // memory as seen by ARM
#define SDRAM0_LENGTH        0x02000000   // 32 MB (Max 256 MByte)

// AHB0 SLAVE PORT 8
//------------------

#define FLASH1_BASE          0x40000000	 //
#define FLASH1_LENGTH        0x00200000   // 2 MByte

#define SRAM1_BASE           0x44000000	 //
#define SRAM1_LENGTH         0x00200000   // 2 MByte

#define SPARE1_BASE          0x48000000	 //
#define SPARE1_LENGTH        0x00200000   // 2 MByte

#define SDRAM1_BASE          0x50000000	 //
#define SDRAM1_LENGTH        0x02000000   // 32 MB (Max 256 MByte)

// AHB1 SLAVE PORT 9
//------------------

#define USB_DMA_BASE         0x80000000	 //
#define USB_DMA_LENGTH       0x00001000

#define USB_CORE_BASE        0x80001000	 //
#define USB_CORE_LENGTH      0x00001000

#define GDMA_BASE            0x80002000	 //
#define GDMA_LENGTH          0x00001000

#define TV_OUT_BASE          0x80003000	 //
#define TV_OUT_LENGTH        0x00001000

#define MPMC_BASE            0x80004000	 //
#define MPMC_LENGTH          0x00001000

#define PCCARD_BASE          0x90000000	 //
#define PCCARD_LENGTH        0x10000000

#define PCCARD_REGS_BASE     0x9C000000	 //
#define PCCARD_REGS_LENGTH   0x00001000

//--------------------------------------------------------------------------------
// Interrupts
//--------------------------------------------------------------------------------
//  
//  The following definitions relate to the bitmask returned by READ_INT.
// 


// Interrupt numbers

#define INT_EVENTROUTER0            1
#define INT_EVENTROUTER1            2
#define INT_EVENTROUTER2            3
#define INT_EVENTROUTER3            4
#define INT_TIMER0                  5
#define INT_TIMER1                  6
#define INT_RTC                     7
#define INT_RTCALARM                8
#define INT_ADC                     9
#define INT_UART                    10
#define INT_I2C0                    11
#define INT_I2C1                    12
#define INT_SPI                     13
#define INT_EPIC_ARM1               14
#define INT_EPIC_ARM2               15
#define INT_EPIC_SAI1               16
#define INT_EPIC_SAI2               17
#define INT_EPIC_SAI3               18
#define INT_EPIC_SAO1               19
#define INT_EPIC_SAO2               20
#define INT_EPIC_SPDIF              21
#define INT_LCD                     22
#define INT_SDMA                    23
#define INT_USB_SLOW                24
#define INT_USB_FAST                25
#define INT_DMA_CHANNEL1            26
#define INT_DMA_CHANNEL2            27
#define INT_PCCARD                  28
#define INT_GDMA                    29
#define INT_YUV                     30

// Interrupt bit positions

#define INTMASK_EVENTROUTER0        (1 << INT_EVENTROUTER0)
#define INTMASK_EVENTROUTER1        (1 << INT_EVENTROUTER1)
#define INTMASK_EVENTROUTER2        (1 << INT_EVENTROUTER2)
#define INTMASK_EVENTROUTER3        (1 << INT_EVENTROUTER3)
#define INTMASK_TIMER0              (1 << INT_TIMER0)
#define INTMASK_TIMER1              (1 << INT_TIMER1)
#define INTMASK_RTC                 (1 << INT_RTC)
#define INTMASK_RTCALARM            (1 << INT_RTCALARM)
#define INTMASK_ADC                 (1 << INT_ADC)
#define INTMASK_UART                (1 << INT_UART)
#define INTMASK_I2C0                (1 << INT_I2C0)
#define INTMASK_I2C1                (1 << INT_I2C1)
#define INTMASK_SPI                 (1 << INT_SPI)
#define INTMASK_EPIC_ARM1           (1 << INT_EPIC_ARM1)
#define INTMASK_EPIC_ARM2           (1 << INT_EPIC_ARM2)
#define INTMASK_EPIC_SAI1           (1 << INT_EPIC_SAI1)
#define INTMASK_EPIC_SAI2           (1 << INT_EPIC_SAI2)
#define INTMASK_EPIC_SAI3           (1 << INT_EPIC_SAI3)
#define INTMASK_EPIC_SAO1           (1 << INT_EPIC_SAO1)
#define INTMASK_EPIC_SAO2           (1 << INT_EPIC_SAO2)
#define INTMASK_EPIC_SPDIF          (1 << INT_EPIC_SPDIF)
#define INTMASK_LCD                 (1 << INT_LCD)
#define INTMASK_SDMA                (1 << INT_SDMA)
#define INTMASK_USB_SLOW            (1 << INT_USB_SLOW)
#define INTMASK_USB_FAST            (1 << INT_USB_FAST)
#define INTMASK_DMA_CHANNEL1        (1 << INT_DMA_CHANNEL1)
#define INTMASK_DMA_CHANNEL2        (1 << INT_DMA_CHANNEL2)
#define INTMASK_PCCARD              (1 << INT_PCCARD)
#define INTMASK_GDMA                (1 << INT_GDMA)
#define INTMASK_YUV                 (1 << INT_YUV)

// Interrupt priorities

#define HIGHEST_IRQ_PRIORITY 15
#define LOWEST_IRQ_PRIORITY  1

#define PRIORITY_IRQ1               1
#define PRIORITY_IRQ2               1
#define PRIORITY_IRQ3               1
#define PRIORITY_IRQ4               1
#define PRIORITY_IRQ5               1
#define PRIORITY_IRQ6               1
#define PRIORITY_IRQ7               1
#define PRIORITY_IRQ8               1
#define PRIORITY_IRQ9               1
#define PRIORITY_IRQ10              1
#define PRIORITY_IRQ11              1
#define PRIORITY_IRQ12              1
#define PRIORITY_IRQ13              1
#define PRIORITY_IRQ14              1
#define PRIORITY_IRQ15              1
#define PRIORITY_IRQ16              1
#define PRIORITY_IRQ17              1
#define PRIORITY_IRQ18              1
#define PRIORITY_IRQ19              1
#define PRIORITY_IRQ20              1
#define PRIORITY_IRQ21              1
#define PRIORITY_IRQ22              1
#define PRIORITY_IRQ23              1
#define PRIORITY_IRQ24              1
#define PRIORITY_IRQ25              1
#define PRIORITY_IRQ26              1
#define PRIORITY_IRQ27              1
#define PRIORITY_IRQ28              1
#define PRIORITY_IRQ29              1
#define PRIORITY_IRQ30              1

// SC_VALID_INT - Mask of valid system controller interrupts

#define SC_VALID_INT         0x7FFFFFFE

#define MAXIRQNUM                   30
#define MAXFIQNUM                   30
#define MAXSWINUM                   30
 
//--------------------------------------------------------------------------------
// PNX0105 Interrupt Controllers
//--------------------------------------------------------------------------------

// The interrupt architecture recommends the following use of interrupt targets
// for the ARM processor:
//    target 0 = IRQ (standard interrupt service with full context state save/restore)
//    target 1 = FIQ (fast interrupt service with minimal context save/restore)

// Offsets from interrupt controller base INTC_BASE

#define INTC_PRIORITYMASK_IRQ       0x000   // target 0
#define INTC_PRIORITYMASK_FIQ       0x004   // target 1
#define INTC_VECTOR_IRQ             0x100   // target 0
#define INTC_VECTOR_FIQ             0x104   // target 1
#define INTC_PENDING_1_31           0x200
#define INTC_FEATURES               0x300
#define INTC_REQUEST_BASE           0x400
#define INTC_MOD_ID                 0xFFC

//--------------------------------------------------------------------------------
// PNX0105 Clock Generation Unit
//--------------------------------------------------------------------------------

// Offsets from clock generation unit base CGU_TOTAL_BASE

#define CGU_POWERMODE               0xC00

//--------------------------------------------------------------------------------
// Timer definitions
//--------------------------------------------------------------------------------

#define TICKS_PER_uSEC              12   // Both timers (1 & 2) run at 12MHz
#define MAX_TIMER                   1

// These are useconds NOT ticks.  

#define mSEC_1                      1000
#define mSEC_5                      (mSEC_1 * 5)
#define mSEC_10                     (mSEC_1 * 10)
#define mSEC_25                     (mSEC_1 * 25)
#define SEC_1                       (mSEC_1 * 1000)

/* RTC registers definition */
#define PNX0105_RTC_INT_LOC      (IO_ADDRESS(RTC_BASE) + 0x00)  //  r  -
#define PNX0105_RTC_INT_CLEAR    (IO_ADDRESS(RTC_BASE) + 0x00)  //  w  -
#define PNX0105_RTC_PRESCALE     (IO_ADDRESS(RTC_BASE) + 0x04)  //  r  -
#define PNX0105_RTC_CLK_REG      (IO_ADDRESS(RTC_BASE) + 0x08)  // r/w -
#define PNX0105_RTC_INC_INT      (IO_ADDRESS(RTC_BASE) + 0x0C)  // r/w -
#define PNX0105_RTC_ALARM_MASK   (IO_ADDRESS(RTC_BASE) + 0x10)  // r/w -
#define PNX0105_RTC_CTIME0       (IO_ADDRESS(RTC_BASE) + 0x14)  //  r  -
#define PNX0105_RTC_CTIME1       (IO_ADDRESS(RTC_BASE) + 0x18)  //  r  -
#define PNX0105_RTC_CTIME2       (IO_ADDRESS(RTC_BASE) + 0x1C)  //  r  -
#define PNX0105_RTC_SECONDS      (IO_ADDRESS(RTC_BASE) + 0x20)  // r/w -
#define PNX0105_RTC_MINUTES      (IO_ADDRESS(RTC_BASE) + 0x24)  // r/w -
#define PNX0105_RTC_HOURS        (IO_ADDRESS(RTC_BASE) + 0x28)  // r/w -
#define PNX0105_RTC_DAYOFMONTH   (IO_ADDRESS(RTC_BASE) + 0x2C)  // r/w -
#define PNX0105_RTC_DAYOFWEEK    (IO_ADDRESS(RTC_BASE) + 0x30)  // r/w -
#define PNX0105_RTC_DAYOFYEAR    (IO_ADDRESS(RTC_BASE) + 0x34)  // r/w -
#define PNX0105_RTC_MONTHS       (IO_ADDRESS(RTC_BASE) + 0x38)  // r/w -
#define PNX0105_RTC_YEARS        (IO_ADDRESS(RTC_BASE) + 0x3C)  // r/w -
#define PNX0105_RTC_SEC_ALARM    (IO_ADDRESS(RTC_BASE) + 0x60)  // r/w -
#define PNX0105_RTC_MIN_ALARM    (IO_ADDRESS(RTC_BASE) + 0x64)  // r/w -
#define PNX0105_RTC_HRS_ALARM    (IO_ADDRESS(RTC_BASE) + 0x68)  // r/w -
#define PNX0105_RTC_DOM_ALARM    (IO_ADDRESS(RTC_BASE) + 0x6C)  // r/w -
#define PNX0105_RTC_DOW_ALARM    (IO_ADDRESS(RTC_BASE) + 0x70)  // r/w -
#define PNX0105_RTC_DOY_ALARM    (IO_ADDRESS(RTC_BASE) + 0x74)  // r/w -
#define PNX0105_RTC_MONTHS_ALARM (IO_ADDRESS(RTC_BASE) + 0x78)  // r/w -
#define PNX0105_RTC_YEARS_ALARM  (IO_ADDRESS(RTC_BASE) + 0x7C)  // r/w -


#endif

//--------------------------------------------------------------------------------
// END OF FILE
//--------------------------------------------------------------------------------
