/*
 * linux/include/asm-arm/arch-pnx0105/irqs.h
 *
 * Copyright (C) 2003 Philips Semiconductors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Use the PNX0105 definitions */
#include <asm/arch/platform.h>

/* 
 *  IRQ interrupts definitions are the same the INT definitions
 *  held within platform.h
 */
#define IRQ_EVENTROUTER0                INT_EVENTROUTER0
#define IRQ_EVENTROUTER1                INT_EVENTROUTER1
#define IRQ_EVENTROUTER2                INT_EVENTROUTER2
#define IRQ_EVENTROUTER3                INT_EVENTROUTER3
#define IRQ_TIMER0                      INT_TIMER0
#define IRQ_TIMER1                      INT_TIMER1
#define IRQ_RTC                         INT_RTC
#define IRQ_RTCALARM                    INT_RTCALARM
#define IRQ_ADC                         INT_ADC
#define IRQ_UART                        INT_UART
#define IRQ_I2C0                        INT_I2C0
#define IRQ_I2C1                        INT_I2C1
#define IRQ_SPI                         INT_SPI
#define IRQ_EPIC_ARM1                   INT_EPIC_ARM1
#define IRQ_EPIC_ARM2                   INT_EPIC_ARM2
#define IRQ_EPIC_SAI1                   INT_EPIC_SAI1
#define IRQ_EPIC_SAI2                   INT_EPIC_SAI2
#define IRQ_EPIC_SAI3                   INT_EPIC_SAI3
#define IRQ_EPIC_SAO1                   INT_EPIC_SAO1
#define IRQ_EPIC_SAO2                   INT_EPIC_SAO2
#define IRQ_EPIC_SPDIF                  INT_EPIC_SPDIF
#define IRQ_LCD                         INT_LCD
#define IRQ_SDMA                        INT_SDMA
#define IRQ_USB_SLOW                    INT_USB_SLOW
#define IRQ_USB_FAST                    INT_USB_FAST
#define IRQ_DMA_CHANNEL1                INT_DMA_CHANNEL1
#define IRQ_DMA_CHANNEL2                INT_DMA_CHANNEL2
#define IRQ_PCCARD                      INT_PCCARD
#define IRQ_GDMA                        INT_GDMA
#define IRQ_YUV                         INT_YUV

#define IRQMASK_EVENTROUTER0            INTMASK_EVENTROUTER0
#define IRQMASK_EVENTROUTER1            INTMASK_EVENTROUTER1
#define IRQMASK_EVENTROUTER2            INTMASK_EVENTROUTER2
#define IRQMASK_EVENTROUTER3            INTMASK_EVENTROUTER3
#define IRQMASK_TIMER0                  INTMASK_TIMER0
#define IRQMASK_TIMER1                  INTMASK_TIMER1
#define IRQMASK_RTC                     INTMASK_RTC
#define IRQMASK_RTCALARM                INTMASK_RTCALARM
#define IRQMASK_ADC                     INTMASK_ADC
#define IRQMASK_UART                    INTMASK_UART
#define IRQMASK_I2C0                    INTMASK_I2C0
#define IRQMASK_I2C1                    INTMASK_I2C1
#define IRQMASK_SPI                     INTMASK_SPI
#define IRQMASK_EPIC_ARM1               INTMASK_EPIC_ARM1
#define IRQMASK_EPIC_ARM2               INTMASK_EPIC_ARM2
#define IRQMASK_EPIC_SAI1               INTMASK_EPIC_SAI1
#define IRQMASK_EPIC_SAI2               INTMASK_EPIC_SAI2
#define IRQMASK_EPIC_SAI3               INTMASK_EPIC_SAI3
#define IRQMASK_EPIC_SAO1               INTMASK_EPIC_SAO1
#define IRQMASK_EPIC_SAO2               INTMASK_EPIC_SAO2
#define IRQMASK_EPIC_SPDIF              INTMASK_EPIC_SPDIF
#define IRQMASK_LCD                     INTMASK_LCD
#define IRQMASK_SDMA                    INTMASK_SDMA
#define IRQMASK_USB_SLOW                INTMASK_USB_SLOW
#define IRQMASK_USB_FAST                INTMASK_USB_FAST
#define IRQMASK_DMA_CHANNEL1            INTMASK_DMA_CHANNEL1
#define IRQMASK_DMA_CHANNEL2            INTMASK_DMA_CHANNEL2
#define IRQMASK_PCCARD                  INTMASK_PCCARD
#define IRQMASK_GDMA                    INTMASK_GDMA
#define IRQMASK_YUV                     INTMASK_YUV

/* 
 *  FIQ interrupts definitions are the same the INT definitions.
 */
#define FIQ_EVENTROUTER0                INT_EVENTROUTER0
#define FIQ_EVENTROUTER1                INT_EVENTROUTER1
#define FIQ_EVENTROUTER2                INT_EVENTROUTER2
#define FIQ_EVENTROUTER3                INT_EVENTROUTER3
#define FIQ_TIMER0                      INT_TIMER0
#define FIQ_TIMER1                      INT_TIMER1
#define FIQ_RTC                         INT_RTC
#define FIQ_RTCALARM                    INT_RTCALARM
#define FIQ_ADC                         INT_ADC
#define FIQ_UART                        INT_UART
#define FIQ_I2C0                        INT_I2C0
#define FIQ_I2C1                        INT_I2C1
#define FIQ_SPI                         INT_SPI
#define FIQ_EPIC_ARM1                   INT_EPIC_ARM1
#define FIQ_EPIC_ARM2                   INT_EPIC_ARM2
#define FIQ_EPIC_SAI1                   INT_EPIC_SAI1
#define FIQ_EPIC_SAI2                   INT_EPIC_SAI2
#define FIQ_EPIC_SAI3                   INT_EPIC_SAI3
#define FIQ_EPIC_SAO1                   INT_EPIC_SAO1
#define FIQ_EPIC_SAO2                   INT_EPIC_SAO2
#define FIQ_EPIC_SPDIF                  INT_EPIC_SPDIF
#define FIQ_LCD                         INT_LCD
#define FIQ_SDMA                        INT_SDMA
#define FIQ_USB_SLOW                    INT_USB_SLOW
#define FIQ_USB_FAST                    INT_USB_FAST
#define FIQ_DMA_CHANNEL1                INT_DMA_CHANNEL1
#define FIQ_DMA_CHANNEL2                INT_DMA_CHANNEL2
#define FIQ_PCCARD                      INT_PCCARD
#define FIQ_GDMA                        INT_GDMA
#define FIQ_YUV                         INT_YUV

#define FIQMASK_EVENTROUTER0            INTMASK_EVENTROUTER0
#define FIQMASK_EVENTROUTER1            INTMASK_EVENTROUTER1
#define FIQMASK_EVENTROUTER2            INTMASK_EVENTROUTER2
#define FIQMASK_EVENTROUTER3            INTMASK_EVENTROUTER3
#define FIQMASK_TIMER0                  INTMASK_TIMER0
#define FIQMASK_TIMER1                  INTMASK_TIMER1
#define FIQMASK_RTC                     INTMASK_RTC
#define FIQMASK_RTCALARM                INTMASK_RTCALARM
#define FIQMASK_ADC                     INTMASK_ADC
#define FIQMASK_UART                    INTMASK_UART
#define FIQMASK_I2C0                    INTMASK_I2C0
#define FIQMASK_I2C1                    INTMASK_I2C1
#define FIQMASK_SPI                     INTMASK_SPI
#define FIQMASK_EPIC_ARM1               INTMASK_EPIC_ARM1
#define FIQMASK_EPIC_ARM2               INTMASK_EPIC_ARM2
#define FIQMASK_EPIC_SAI1               INTMASK_EPIC_SAI1
#define FIQMASK_EPIC_SAI2               INTMASK_EPIC_SAI2
#define FIQMASK_EPIC_SAI3               INTMASK_EPIC_SAI3
#define FIQMASK_EPIC_SAO1               INTMASK_EPIC_SAO1
#define FIQMASK_EPIC_SAO2               INTMASK_EPIC_SAO2
#define FIQMASK_EPIC_SPDIF              INTMASK_EPIC_SPDIF
#define FIQMASK_LCD                     INTMASK_LCD
#define FIQMASK_SDMA                    INTMASK_SDMA
#define FIQMASK_USB_SLOW                INTMASK_USB_SLOW
#define FIQMASK_USB_FAST                INTMASK_USB_FAST
#define FIQMASK_DMA_CHANNEL1            INTMASK_DMA_CHANNEL1
#define FIQMASK_DMA_CHANNEL2            INTMASK_DMA_CHANNEL2
#define FIQMASK_PCCARD                  INTMASK_PCCARD
#define FIQMASK_GDMA                    INTMASK_GDMA
#define FIQMASK_YUV                     INTMASK_YUV


#define NR_IRQS                         (MAXIRQNUM + 1)

