/*
 * linux/include/asm-arm/arch-pnx0105/hardware.h
 *
 * This file contains the hardware definitions of the PNX0105.
 *
 * Copyright (C) 2003 Philips Semiconductors
 * 
 * Modified by Vitaly Wool <vwool@ru.mvista.com> to enable HRT/WDT/RTC
 * Copyright (C) 2004 MontaVista Software, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ASM_ARCH_HARDWARE_H
#define __ASM_ARCH_HARDWARE_H

#include <asm/sizes.h>
#include <asm/arch/platform.h>

// Where in virtual memory are the IO devices (timers, system controller...)
#define IO_BASE         0xF0000000      // Virtual Address of IO

// macro to get at IO space when running virtually
// WATCH OUT: THIS MACRO CAN NOT BE USED FOR THE FOLLOWING MODULES
//                - X-memory RAM_1
//                - X-memory RAM_2
//                - X-memory RAM_3
//                - X-memory RAM_4
//                - DSP Control registers
//                - Y-memory ROM
//                - Y-memory RAM_1
//                - Y-memory RAM_2
//                - P-memory ROM
//                - P-memory RAM_1
//                - P-memory RAM_2
//                - DSP DIO registers
//                - DSP DMA registers
//                - Static Memory 0
//                - USB DMA
//                - USB CORE
//                - GDMA
//                - YUV Output
//                - MPMC
//                - PCCARD
#define IO_ADDRESS(x)   (x | IO_BASE)

/*
 * Where is the timer (VA)?
 */
#define TIMER0_VA_BASE  (IO_ADDRESS(CT0_BASE)+0x00000000)
#define TIMER1_VA_BASE  (IO_ADDRESS(CT0_BASE)+0x00000400)
#define RTC_TIMER_BASE  (IO_ADDRESS(RTC_BASE))
#define INTC_VA_BASE    IO_ADDRESS(INTC_BASE) 

#ifndef __ASSEMBLY__
/*
 * What does it look like?
 */
typedef struct TimerStruct {
	volatile unsigned long TimerLoad;
	volatile unsigned long TimerValue;
	volatile unsigned long TimerControl;
	volatile unsigned long TimerClear;
} TimerStruct_t;

#endif


#endif
