/*
 * linux/include/asm-arm/arch-omap/uncompress.h
 *
 * Serial port stubs for kernel decompress status messages
 *
 * Author: RidgeRun, Inc.
 *         Greg Lonnon (glonnon@ridgerun.com) or info@ridgerun.com
 *
 * Copyright (C) 2000 RidgeRun, Inc. (http://www.ridgerun.com)
 * 2002-2004 (c) MontaVista Software, Inc.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <linux/config.h>
#include <linux/types.h>
#include <linux/serial_reg.h>
#include <asm/mach-types.h>
#include <asm/hardware.h>


#define check_port(base, shift) ((base[UART_OMAP_MDR1 << shift] & 7) == 0)

static void
puts(const char *s)
{
	volatile u8 * uart = 0;
	int shift = 0;

	/* Determine which serial port to use */
	do {
		if (machine_is_innovator()) {
			shift = 2;
			uart = (volatile u8 *)(OMAP1510_UART1_BASE);
		} else {
			/* Assume nothing for unknown machines.
			 * Add an entry for your machine to select
			 * the default serial console here. If the
			 * serial port is enabled, we'll use it to
			 * display status messages. Else we'll be
			 * quiet.
			 */
			return;
		}
		if (check_port(uart, shift))
			break;
		/* Silent boot if no serial ports are enabled. */
		return;
	} while (0);

	/*
	 * Now, xmit each character
	 */
	while (*s) {
		while (!(uart[UART_LSR << shift] & UART_LSR_THRE))
			barrier();
		uart[UART_TX << shift] = *s;
		if (*s++ == '\n') {
			while (!(uart[UART_LSR << shift] & UART_LSR_THRE))
				barrier();
			uart[UART_TX << shift] = *s;
		}
	}
}

/*
 * nothing to do
 */
#define arch_decomp_setup()
#define arch_decomp_wdog()
