/*
 *  linux/include/asm-arm/arch-mx2ads/time.h
 *
 *  Copyright (C) 2004 MontaVista Software Inc.
 *  Copyright (C) 2004 Motorola Semiconductors HK Ltd
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef __ASM_ARCH_TIME_H__
#define __ASM_ARCH_TIME_H__

#ifndef U32
typedef unsigned long U32;
#endif

#include <asm/system.h>
#include <asm/leds.h>
#include <asm/arch/hardware.h>
#include <asm/arch/gpio.h>
#include <asm/arch/hrtime.h>
#include <linux/sc_math.h>

#define TIM_32KHZ       0x08
#define TIM_PERCLK1     0x02
#define TIM_INTEN       0x10
#define TIM_ENAB        0x01
#define TIM_FRERUN        0x0100

/*
 *  These are useconds NOT ticks.
 *
 */
#define mSEC_1                          1000
#define mSEC_5                          (mSEC_1 * 5)
#define mSEC_10                         (mSEC_1 * 10)
#define mSEC_25                         (mSEC_1 * 25)
#define SEC_1                           (mSEC_1 * 1000)

#define SC_ARCH2USEC        31
#define SC_USEC2ARCH        29
#define arch_cycle_to_usec(cycles)    \
    mpy_sc_n(SC_ARCH2USEC, (cycles), scaled_usec_per_arch_cycle)
int scaled_usec_per_arch_cycle;

/*
 * Returns number of ms since last clock interrupt.  Note that interrupts
 * will have been disabled by do_gettimeoffset()
 */
static unsigned long
mx2ads_gettimeoffset(void)
{
	unsigned long ticks, status;

	ticks = GPT_TCN(GPT1);

	return arch_cycle_to_usec(ticks);
}

/*
 * IRQ handler for the timer
 */
static void
mx2ads_timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{

	if (GPT_TSTAT(GPT1))
#ifdef CONFIG_MX2TO1
		GPT_TSTAT(GPT1) = 0;	/* clear interrupt */
#else
		GPT_TSTAT(GPT1) = 1;	/* clear interrupt */
#endif
	barrier();
	do_timer(regs);
	do_leds();
	do_set_rtc();
	barrier();
	do_profile(regs);
}

/*
 * Set up timer interrupt, and return the current time in seconds.
 */
extern __inline__ void
setup_timer(void)
{
	unsigned long mpll_frequency;
	unsigned int timer_reload;

	timer_reload = arch_cycles_per_jiffy;

#ifdef CONFIG_HIGH_RES_TIMERS
	mx2_register_gpios(PORT_E, 5, GPIO | OUTPUT | OCR_B);
#endif
	CRM_PCCR1 |= PCCR1_GPT1_EN | PCCR1_GPT2_EN | PCCR1_GPT3_EN;

	if (CRM_MPCTL0 == 0x7b1c73) {
		mpll_frequency = 266000053;
	} else {
		mpll_frequency = 266000053;
	}

#ifdef CONFIG_MX2TO1
	mpll_frequency =
	    mpll_frequency / (((CRM_CSCR & CSCR_BCLKDIV) >> 10) + 1);
	mpll_frequency = mpll_frequency / (((CRM_CSCR & CSCR_IPDIV) >> 9) + 1);
#else
	mpll_frequency = mpll_frequency / ((CRM_PCDR1 & 0x3f) + 1);
#endif
	mpll_frequency = mpll_frequency / 100;

	timer_irq.handler = mx2ads_timer_interrupt;

	scaled_usec_per_arch_cycle =
	    SC_n(SC_ARCH2USEC, USEC_PER_SEC) / CLOCK_TICK_RATE;

	/* Make irqs happen for the system timer */
	setup_arm_irq(INT_GPT1, &timer_irq);
	gettimeoffset = mx2ads_gettimeoffset;

	GPT_TCTL(GPT1) = 0;
	GPT_TPRER(GPT1) = mpll_frequency / timer_reload - 1;
	GPT_TCMP(GPT1) = arch_cycles_per_jiffy - 1;
	GPT_TCTL(GPT1) = (TIM_PERCLK1 | TIM_INTEN);

#ifdef CONFIG_HIGH_RES_TIMERS
	GPT_TCTL(GPT2) = 0;
	GPT_TPRER(GPT2) = mpll_frequency / timer_reload - 1;
	GPT_TCMP(GPT2) = arch_cycles_per_jiffy - 1;
	GPT_TCTL(GPT2) = (TIM_PERCLK1);
#endif

	GPT_TCTL(GPT1) |= TIM_ENAB;
#ifdef CONFIG_HIGH_RES_TIMERS
	GPT_TCTL(GPT2) |= TIM_ENAB;
#endif

}
#endif
