/*
 * include/asm-arm/arch-mx2ads/preem_latency.h
 * timing support for preempt-stats patch
 */

#ifndef __ASM_ARCH_PREEM_LATENCY_H
#define __ASM_ARCH_PREEM_LATENCY_H


#include <asm/hardware.h>
#include <asm/arch/gpio.h>

#define TICKS_PER_USEC		2     /* 2MHz timer */

#define TIM_PERCLK1     0x0002
#define TIM_ENAB        0x0001 /* Enable Timer */
#define TIM_FRR         0x0100 /* Free-Run mode enable */
#define TIM_RST         0x8000 /* Reset timer */


static inline
void init_gpt3 (void)
{

	mx2_register_gpios(PORT_E, 5, GPIO | OUTPUT | OCR_C);
	CRM_PCCR1 |= PCCR1_GPT3_EN;

	/*
	 * Disable timer
	 */
	GPT_TCTL(GPT3) = 0;
	GPT_TCTL(GPT3) = TIM_RST;
	GPT_TCTL(GPT3) = 0;

	/*
	 * Set up free-running 2Mhz timer
	 */
#ifdef CONFIG_MX2TO1
	GPT_TPRER(GPT3) = 0x15;
#else
	GPT_TPRER(GPT3) = 0x20;
#endif
	GPT_TCTL(GPT3) = (TIM_PERCLK1 | TIM_FRR);

	GPT_TCTL(GPT3) |= (TIM_ENAB);
}

static inline
unsigned int read_gpt3 (void)
{
	return ((unsigned int)GPT_TCN(GPT3));
}

#define readclock_init()   \
	do {                         \
		init_gpt3();         \
	} while (0)

#define readclock(_x)		\
	do {                         \
		(_x) = read_gpt3();  \
	} while (0)

/* We have enabled 2 Mhz timer */
#define clock_to_usecs(_x)	((_x) >> 1)

#endif /* __ASM_ARCH_PREEM_LATENCY_H */
