/*
 *  linux/include/asm-arm/arch-mx2ads/pll.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Copyright (C) 2003 Motorola Semiconductors SuZhou Ltd
 *
 */

#ifndef __ASM_ARCH_PLL_H
#define __ASM_ARCH_PLL_H

#include <asm/arch/hardware.h>

/*Set the MPLL SPLL output*/
#define _PLL_CLK_MPLL
#define _PLL_CLK_SPLL

/* Setting for CSCR 0x10027000*/
#define _PLL_CSCR_CLKO_SEL
#define _PLL_CSCR_USB_DIV
#define _PLL_CSCR_SD_CNT
#define _PLL_CSCR_SSI2_SEL
#define _PLL_CSCR_SSI1_SEL
#define _PLL_CSCR_FIR_SEL
#define _PLL_CSCR_SP_SEL
#define _PLL_CSCR_MCU_SEL
#define _PLL_CSCR_PRESC
#define _PLL_CSCR_BCLKDIV
#define _PLL_CSCR_CLKO_SEL
#define _PLL_CSCR_IPDIV

/*Setting for SPCDR 0x10027018*/
#define _PLL_SPCDR_SSI2DIV
#define _PLL_SPCDR_PERDIV2
#define _PLL_SPCDR_SSI1DIV
#define _PLL_SPCDR_NFCDIV
#define _PLL_SPCDR_PERDIV1
#define _PLL_SPCDR_CLKO_48DIV
#define _PLL_SPCDR_FIRI_MIRDIV

/* From the setting above, caculating the following frequency*/

#define _PLL_CLK_FCLK	(_PLL_CLK_MPLL)/(_PLL_CSCR_PRESC+1)
#define _PLL_CLK_HCLK	(_PLL_CLK_FCLK)/(_PLL_CSCR_BCLKDIV+1)
#define _PLL_CLK_NFCCLK	(_PLL_CLK_FCLK)/(_PLL_SPCDR_NFCDIV+1)
#define _PLL_CLK_PERDIV1	(_PLL_CLK_FCLK)/(_PLL_SPCDR_PERDIV1+1)
#define _PLL_CLK_PERDIV2	(_PLL_CLK_FCLK)/(_PLL_SPCDR_PERDIV2+1)
#define _PLL_CLK_PERCLK	(_PLL_CLK_HCLK)/(_PLL_CSCR_IPDIV+1)

#define _PLL_CLK_FIRICLK	(_PLL_CLK_SPLL)/(_PLL_SPCDR_FIRI_MIRDIV+1)
#define _PLL_CLK_CLK48M	(_PLL_CLK_SPLL)/(_PLL_CSCR_USB_DIV+1)
#define _PLL_CLK_SSI1CLK	(_PLL_CLK_SPLL)/(_PLL_SPCDR_SSI1DIV+1)
#define _PLL_CLK_SSI2CLK	(_PLL_CLK_SPLL)/(_PLL_SPCDR_SSI2DIV+1)

/* The following clk source are generated by PLL*/

#define GATE_HCLK_MODULE_CSI		0x80000000
#define GATE_HCLK_MODULE_DMA		0x40000000
#define GATE_HCLK_MODULE_SAHARA		0x20000000
#define GATE_HCLK_MODULE_BROM 		0x10000000
#define GATE_HCLK_MODULE_EMMA		0x08000000
#define GATE_HCLK_MODULE_LCDC 		0x04000000
#define GATE_HCLK_MODULE_SLCDC		0x02000000
#define GATE_HCLK_MODULE_USBOTG		0x01000000
#define GATE_HCLK_MODULE_BMI 		0x00800000
#define GATE_IPG_MODULE_SLCDC 		0x00200000
#define GATE_IPG_MODULE_FIR_BUAD	0x00100000
#define GATE_IPG_MODULE_NFC 		0x00080000
#define GATE_IPG_MODULE_LCDC_PIXCLK	0x00040000
#define GATE_IPG_MODULE_SSI1_BAUD 	0x00020000
#define GATE_IPG_MODULE_SSI2_BAUD	0x00010000
#define GATE_IPG_MODULE_EMMA		0x00008000
#define GATE_IPG_MODULE_USBOTG 		0x00004000
#define GATE_IPG_MODULE_DMA 		0x00002000
#define GATE_IPG_MODULE_I2C 		0x00001000
#define GATE_IPG_MODULE_GPIO 		0x00000800
#define GATE_IPG_MODULE_SDHC2		0x00000400
#define GATE_IPG_MODULE_SDHC1		0x00000200
#define GATE_IPG_MODULE_FIR		0x00000100
#define GATE_IPG_MODULE_SSI2 		0x00000080
#define GATE_IPG_MODULE_SSI1		0x00000040
#define GATE_IPG_MODULE_CSPI2		0x00000020
#define GATE_IPG_MODULE_CSPI1		0x00000010
#define GATE_IPG_MODULE_UART1		0x00000008
#define GATE_IPG_MODULE_UART2		0x00000004
#define GATE_IPG_MODULE_UART3		0x00000002
#define GATE_IPG_MODULE_UART4		0x00000001
#define GATE_IPG_MODULE_OWIRE		0x80000000
#define GATE_IPG_MODULE_KPP		0x40000000
#define GATE_IPG_MODULE_RTC		0x20000000
#define GATE_IPG_MODULE_PWM		0x10000000
#define GATE_IPG_MODULE_GPT3		0x08000000
#define GATE_IPG_MODULE_GPT2		0x04000000
#define GATE_IPG_MODULE_GPT1		0x02000000
#define GATE_IPG_MODULE_WDT		0x01000000

/* caculate the frequency of clock source*/

#define CLK_IPG_MODULE_SLCDC 		_PLL_CLK_PERCLK
#define CLK_IPG_MODULE_FIR_BUAD		_PLL_CLK_FIRICLK
#define CLK_IPG_MODULE_NFC 		_PLL_CLK_NFCCLK
#define CLK_IPG_MODULE_LCDC_PIXCLK	_PLL_CLK_PERDIV2
#define CLK_IPG_MODULE_SSI1_BAUD 	_PLL_CLK_SSI1CLK
#define CLK_IPG_MODULE_SSI2_BAUD	_PLL_CLK_SSI2CLK
#define CLK_IPG_MODULE_EMMA		_PLL_CLK_PERCLK
#define CLK_IPG_MODULE_USBOTG 		_PLL_CLK_CLK48M
#define CLK_IPG_MODULE_DMA 		_PLL_CLK_PERCLK
#define CLK_IPG_MODULE_I2C 		_PLL_CLK_PERCLK
#define CLK_IPG_MODULE_GPIO 		_PLL_CLK_PERCLK
#define CLK_IPG_MODULE_SDHC2		_PLL_CLK_PERDIV2
#define CLK_IPG_MODULE_SDHC1		_PLL_CLK_PERDIV2
#define CLK_IPG_MODULE_FIR		_PLL_CLK_PERCLK
#define CLK_IPG_MODULE_SSI2 		_PLL_CLK_PERCLK
#define CLK_IPG_MODULE_SSI1		_PLL_CLK_PERCLK
#define CLK_IPG_MODULE_CSPI2		_PLL_CLK_PERDIV2
#define CLK_IPG_MODULE_CSPI1		_PLL_CLK_PERDIV2
#define CLK_IPG_MODULE_UART1		_PLL_CLK_PERDIV1
#define CLK_IPG_MODULE_UART2		_PLL_CLK_PERDIV1
#define CLK_IPG_MODULE_UART3		_PLL_CLK_PERDIV1
#define CLK_IPG_MODULE_UART4		_PLL_CLK_PERDIV1
#define CLK_IPG_MODULE_OWIRE		_PLL_CLK_PERCLK
#define CLK_IPG_MODULE_KPP		_PLL_CLK_PERCLK
#define CLK_IPG_MODULE_RTC		_PLL_CLK_PERCLK
#define CLK_IPG_MODULE_PWM		_PLL_CLK_PERDIV1
#define CLK_IPG_MODULE_GPT3		_PLL_CLK_PERDIV1
#define CLK_IPG_MODULE_GPT2		_PLL_CLK_PERDIV1
#define CLK_IPG_MODULE_GPT1		_PLL_CLK_PERDIV1
#define CLK_IPG_MODULE_WDT		_PLL_CLK_PERCLK

/* define the clock gate register */

#define GATE_REG_HCLK_MODULE_CSI		CRM_PCCR0
#define GATE_REG_HCLK_MODULE_DMA		CRM_PCCR0
#define GATE_REG_HCLK_MODULE_SAHARA		CRM_PCCR0
#define GATE_REG_HCLK_MODULE_BROM 		CRM_PCCR0
#define GATE_REG_HCLK_MODULE_EMMA		CRM_PCCR0
#define GATE_REG_HCLK_MODULE_LCDC 		CRM_PCCR0
#define GATE_REG_HCLK_MODULE_SLCDC		CRM_PCCR0
#define GATE_REG_HCLK_MODULE_USBOTG		CRM_PCCR0
#define GATE_REG_HCLK_MODULE_BMI 		CRM_PCCR0
#define GATE_REG_IPG_MODULE_SLCDC 		CRM_PCCR0
#define GATE_REG_IPG_MODULE_FIR_BUAD		CRM_PCCR0
#define GATE_REG_IPG_MODULE_NFC 		CRM_PCCR0
#define GATE_REG_IPG_MODULE_LCDC_PIXCLK		CRM_PCCR0
#define GATE_REG_IPG_MODULE_SSI1_BAUD 		CRM_PCCR0
#define GATE_REG_IPG_MODULE_SSI2_BAUD		CRM_PCCR0
#define GATE_REG_IPG_MODULE_EMMA		CRM_PCCR0
#define GATE_REG_IPG_MODULE_USBOTG 		CRM_PCCR0
#define GATE_REG_IPG_MODULE_DMA 		CRM_PCCR0
#define GATE_REG_IPG_MODULE_I2C 		CRM_PCCR0
#define GATE_REG_IPG_MODULE_GPIO 		CRM_PCCR0
#define GATE_REG_IPG_MODULE_SDHC2		CRM_PCCR0
#define GATE_REG_IPG_MODULE_SDHC1		CRM_PCCR0
#define GATE_REG_IPG_MODULE_FIR			CRM_PCCR0
#define GATE_REG_IPG_MODULE_SSI2 		CRM_PCCR0
#define GATE_REG_IPG_MODULE_SSI1		CRM_PCCR0
#define GATE_REG_IPG_MODULE_CSPI2		CRM_PCCR0
#define GATE_REG_IPG_MODULE_CSPI1		CRM_PCCR0
#define GATE_REG_IPG_MODULE_UART1		CRM_PCCR0
#define GATE_REG_IPG_MODULE_UART2		CRM_PCCR0
#define GATE_REG_IPG_MODULE_UART3		CRM_PCCR0
#define GATE_REG_IPG_MODULE_UART4		CRM_PCCR0
#define GATE_REG_IPG_MODULE_OWIRE		CRM_PCCR1
#define GATE_REG_IPG_MODULE_KPP			CRM_PCCR1
#define GATE_REG_IPG_MODULE_RTC			CRM_PCCR1
#define GATE_REG_IPG_MODULE_PWM			CRM_PCCR1
#define GATE_REG_IPG_MODULE_GPT3		CRM_PCCR1
#define GATE_REG_IPG_MODULE_GPT2		CRM_PCCR1
#define GATE_REG_IPG_MODULE_GPT1		CRM_PCCR1
#define GATE_REG_IPG_MODULE_WDT			CRM_PCCR1

#define  mx_module_get_clk(module)	CLK_IPG_##module
#define  mx_module_clk_open(module)	GATE_REG_##module |= GATE_##module
#define  mx_module_clk_close(module)	GATE_REG_##module &= ~GATE_##module
#endif
