/******************************************************************************

	include/asm-arm/arch-mx2ads/i2c.h
	header file for on-chip I2C of Motorola DragonBall MX2 support

	Author: MontaVista Software, Inc. <source@mvista.com>
	Copyright (c) 2003 MontaVista Software, Inc.

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*******************************************************************************/
#ifndef __ASM_ARCH_I2C_H__
#define __ASM_ARCH_I2C_H__

#include <linux/i2c.h>		/*use i2c-msg structure from here */

/*if set, indicates that mx2 i2c is initialized successfully
  check this before calling mx2_i2c_xfer()*/
#define MX2_I2C_INITIALIZED 1
extern char mx2_initstate_i2c;

/*this function sends "num" of messages described in "msgs[]".
  returnes a number of messages transferred or an error code*/
extern int mx2_i2c_xfer(struct i2c_msg msgs[], int num);

/*complements message flags described in linux/i2c.h*/
/*this flag has effect only if set in the first message (#0) supplied to mx2_i2c_xfer() */
#ifndef I2C_M_HIGH_SPEED
#define I2C_M_HIGH_SPEED	0x02	/* Transfer data at 400KHz instead of 100KHz */
#endif

#endif
