/*
 *  linux/include/asm-arm/arch-mx1ads/irqs.h
 *
 *  Copyright (C) 1999 ARM Limited
 *  Copyright (C) 2000 Deep Blue Solutions Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ARM_IRQS_H__
#define __ARM_IRQS_H__

/* Use the mx1ads definitions */
#include <asm/arch/platform.h>

#define IRQ_SOFTINT                 0
#define IRQ_CSI                 6
#define IRQ_DSPA_MAC                7
#define IRQ_DSPA                    8
#define IRQ_COMP                    9
#define IRQ_MSHC_XINT                   10
#define IRQ_GPIO_PORTA              11
#define IRQ_GPIO_PORTB              12
#define IRQ_GPIO_PORTC              13
#define IRQ_LCDC                    14
#define IRQ_SIM                     15
#define IRQ_SIM_DATA                16
#define IRQ_RTC                     17
#define IRQ_RTC_SAMINT                  18
#define IRQ_UART2_MINT_PFERR            19
#define IRQ_UART2_MINT_RTS              20
#define IRQ_UART2_MINT_DTR              21
#define IRQ_UART2_MINT_UARTC            22
#define IRQ_UART2_MINT_TX               23
#define IRQ_UART2_MINT_RX               24
#define IRQ_UART1_MINT_PFERR            25
#define IRQ_UART1_MINT_RTS              26
#define IRQ_UART1_MINT_DTR              27
#define IRQ_UART1_MINT_UARTC            28
#define IRQ_UART1_MINT_TX               29
#define IRQ_UART1_MINT_RX               30
#define IRQ_VOICE_DAC               31
#define IRQ_VOICE_ADC               32
#define IRQ_PEN_DATA                33
#define IRQ_PWM                     34
#define IRQ_SDHC                    35
#define IRQ_I2C                     39
#define IRQ_CSPI                    41
#define IRQ_SSI_TX                  42
#define IRQ_SSI_TX_ERR              43
#define IRQ_SSI_RX                  44
#define IRQ_SSI_RX_ERR              45
#define IRQ_TOUCH                   46
#define IRQ_USBD0                   47
#define IRQ_USBD1                   48
#define IRQ_USBD2                   49
#define IRQ_USBD3                   50
#define IRQ_USBD4                   51
#define IRQ_USBD5                   52
#define IRQ_USBD6                   53
#define IRQ_BTSYS                   55
#define IRQ_BTTIM                   56
#define IRQ_BTWUI                   57
#define IRQ_TIMER2                  58
#define IRQ_TIMER1                  59
#define IRQ_DMA_ERR                     60
#define IRQ_DMA                     61
#define IRQ_GPIO_PORTD              62

#define MAXIRQNUM                       62
#define MAXFIQNUM                       62
#define MAXSWINUM                       62
/*
 * Well, that's about all we need I think.
 */
#define NR_IRQS                         (MAXIRQNUM + 1)
#define NR_FIQS                      (MAXFIQNUM + 1)

#endif
