/*
 * include/asm-arm/arch-mx1ads/hrtime.h
 *
 * HRT hooks for the ARM MX1
 *
 * Author: MontaVista Software, Inc. <source@mvista.com>
 * 2003 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#ifndef __ASM_ARCH_HRTIME_H_
#define __ASM_ARCH_HRTIME_H_

#ifdef CONFIG_HIGH_RES_TIMERS

#include <linux/config.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/timex.h>
#include <asm/hardware.h>

int schedule_hr_timer_int(unsigned, int);
int get_arch_cycles(unsigned);

#define hr_time_resolution	1000

extern int arch_cycles_per_jiffy;

#define schedule_jiffies_int(x)	(get_arch_cycles(x) >= arch_cycles_per_jiffy)

#define SC_ARCH2NSEC        21
#define SC_NSEC2ARCH        32

extern int scaled_nsec_per_arch_cycle;

extern int scaled_arch_cycles_per_nsec;

#define arch_cycle_to_nsec(cycles)    \
    mpy_sc_n(SC_ARCH2NSEC, (cycles), scaled_nsec_per_arch_cycle)

#define nsec_to_arch_cycle(nsec)    \
    mpy_sc_n(SC_NSEC2ARCH, (nsec), scaled_arch_cycles_per_nsec)

#endif				/* CONFIG_HIGH_RES_TIMERS */

#endif				/* __ASM_ARCH_HRTIME_H_ */
