/*
 * include/asm-arm/arch-ixp425/ixp425.h 
 *
 * Register definitions for IXP425 
 *
 * Copyright (C) 2004 Intel Corporation.
 *
 * Maintainer: Deepak Saxena <dsaxena@mvista.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef __ASM_ARCH_HARDWARE_H__
#error "Do not include this directly, please #include <asm/hardware.h>"
#endif

#ifndef _ASM_ARM_IXP425_H_
#define _ASM_ARM_IXP425_H_

#include "ixp4xx.h"

/*
 * 
 * IXP425 Memory map:
 *
 * Phy		Phy Size	Map Size	Virt		Description
 * =========================================================================
 *
 * 0x00000000	0x10000000					SDRAM 1 
 *
 * 0x10000000	0x10000000					SDRAM 2
 *
 * 0x20000000	0x10000000					SDRAM 3
 *
 * 0x30000000	0x10000000					SDRAM 4 
 *
 * The above four are aliases to the same memory location  (0x00000000)
 *
 * 0x48000000	 0x4000000					PCI Memory
 *
 * 0x50000000	0x10000000			Not Mapped	EXP BUS
 *
 * 0x6000000	0x00004000	    0x4000	0xFFFEB000	QMgr
 *
 * 0xC0000000	     0x100   	    0x1000	0xFFFDD000	PCI CFG 
 *
 * 0xC4000000	     0x100          0x1000	0xFFFDE000	EXP CFG 
 *
 * 0xC8000000	    0xC000          0xC000	0xFFFDF000	PERIPHERAL
 *
 * 0xCC000000	     0x100   	    0x1000	Not Mapped	SDRAM CFG 
 */


/*
 * PCI Configuration space
 */
#define IXP425_PCI_CFG_BASE_PHYS		IXP4XX_PCI_CFG_BASE_PHYS
#define IXP425_PCI_CFG_BASE_VIRT		IXP4XX_PCI_CFG_BASE_VIRT
#define IXP425_PCI_CFG_REGION_SIZE		IXP4XX_PCI_CFG_REGION_SIZE

/*
 * Expansion BUS Configuration registers
 */
#define IXP425_EXP_CFG_BASE_PHYS		IXP4XX_EXP_CFG_BASE_PHYS
#define IXP425_EXP_CFG_BASE_VIRT		IXP4XX_EXP_CFG_BASE_VIRT
#define IXP425_EXP_CFG_REGION_SIZE		IXP4XX_EXP_CFG_REGION_SIZE

/*
 * Peripheral space
 */
#define IXP425_PERIPHERAL_BASE_PHYS		IXP4XX_PERIPHERAL_BASE_PHYS
#define IXP425_PERIPHERAL_BASE_VIRT		IXP4XX_PERIPHERAL_BASE_VIRT
#define IXP425_PERIPHERAL_REGION_SIZE	IXP4XX_PERIPHERAL_REGION_SIZE

/* 
 * Q Manager space .. not static mapped
 */
#define IXP425_QMGR_BASE_PHYS			IXP4XX_QMGR_BASE_PHYS
#define IXP425_QMGR_BASE_VIRT			IXP4XX_QMGR_BASE_VIRT
#define IXP425_QMGR_REGION_SIZE			IXP4XX_QMGR_REGION_SIZE

/*
 * Expansion BUS
 *
 * Expansion Bus 'lives' at either base1 or base 2 depending on the value of
 * Exp Bus config registers:
 *
 * Setting bit 31 of IXP425_EXP_CFG0 puts SDRAM at zero,
 * and The expansion bus to IXP425_EXP_BUS_BASE2
 */
#define IXP425_EXP_BUS_BASE1_PHYS		IXP4XX_EXP_BUS_BASE1_PHYS
#define IXP425_EXP_BUS_BASE2_PHYS		IXP4XX_EXP_BUS_BASE2_PHYS
#define IXP425_EXP_BUS_BASE2_VIRT		IXP4XX_EXP_BUS_BASE2_VIRT

#define IXP425_EXP_BUS_BASE_PHYS		IXP4XX_EXP_BUS_BASE_PHYS
#define IXP425_EXP_BUS_BASE_VIRT		IXP4XX_EXP_BUS_BASE_VIRT

#define IXP425_EXP_BUS_REGION_SIZE		IXP4XX_EXP_BUS_REGION_SIZE
#define IXP425_EXP_BUS_CSX_REGION_SIZE	IXP4XX_EXP_BUS_CSX_REGION_SIZE

#define IXP425_EXP_BUS_CS0_BASE_PHYS	IXP4XX_EXP_BUS_CS0_BASE_PHYS
#define IXP425_EXP_BUS_CS1_BASE_PHYS	IXP4XX_EXP_BUS_CS1_BASE_PHYS
#define IXP425_EXP_BUS_CS2_BASE_PHYS	IXP4XX_EXP_BUS_CS2_BASE_PHYS
#define IXP425_EXP_BUS_CS3_BASE_PHYS	IXP4XX_EXP_BUS_CS3_BASE_PHYS
#define IXP425_EXP_BUS_CS4_BASE_PHYS	IXP4XX_EXP_BUS_CS4_BASE_PHYS
#define IXP425_EXP_BUS_CS5_BASE_PHYS	IXP4XX_EXP_BUS_CS5_BASE_PHYS
#define IXP425_EXP_BUS_CS6_BASE_PHYS	IXP4XX_EXP_BUS_CS6_BASE_PHYS
#define IXP425_EXP_BUS_CS7_BASE_PHYS	IXP4XX_EXP_BUS_CS7_BASE_PHYS

#define IXP425_EXP_BUS_CS0_BASE_VIRT	IXP4XX_EXP_BUS_CS0_BASE_VIRT
#define IXP425_EXP_BUS_CS1_BASE_VIRT	IXP4XX_EXP_BUS_CS1_BASE_VIRT
#define IXP425_EXP_BUS_CS2_BASE_VIRT	IXP4XX_EXP_BUS_CS2_BASE_VIRT
#define IXP425_EXP_BUS_CS3_BASE_VIRT	IXP4XX_EXP_BUS_CS3_BASE_VIRT
#define IXP425_EXP_BUS_CS4_BASE_VIRT	IXP4XX_EXP_BUS_CS4_BASE_VIRT
#define IXP425_EXP_BUS_CS5_BASE_VIRT	IXP4XX_EXP_BUS_CS5_BASE_VIRT
#define IXP425_EXP_BUS_CS6_BASE_VIRT	IXP4XX_EXP_BUS_CS6_BASE_VIRT
#define IXP425_EXP_BUS_CS7_BASE_VIRT	IXP4XX_EXP_BUS_CS7_BASE_VIRT

#define IXP425_FLASH_WRITABLE			IXP4XX_FLASH_WRITABLE
#define IXP425_FLASH_DEFAULT			IXP4XX_FLASH_DEFAULT
#define IXP425_FLASH_WRITE				IXP4XX_FLASH_WRITE


#define IXP425_EXP_CS0_OFFSET			IXP4XX_EXP_CS0_OFFSET
#define IXP425_EXP_CS1_OFFSET   		IXP4XX_EXP_CS1_OFFSET
#define IXP425_EXP_CS2_OFFSET   		IXP4XX_EXP_CS2_OFFSET
#define IXP425_EXP_CS3_OFFSET   		IXP4XX_EXP_CS3_OFFSET
#define IXP425_EXP_CS4_OFFSET   		IXP4XX_EXP_CS4_OFFSET
#define IXP425_EXP_CS5_OFFSET   		IXP4XX_EXP_CS5_OFFSET
#define IXP425_EXP_CS6_OFFSET   		IXP4XX_EXP_CS6_OFFSET
#define IXP425_EXP_CS7_OFFSET   		IXP4XX_EXP_CS7_OFFSET
#define IXP425_EXP_CFG0_OFFSET			IXP4XX_EXP_CFG0_OFFSET
#define IXP425_EXP_CFG1_OFFSET			IXP4XX_EXP_CFG1_OFFSET

/*
 * Expansion Bus Controller registers.
 */
#define IXP425_EXP_REG(x) 				IXP4XX_EXP_REG(x)

#define IXP425_EXP_CS0      			IXP4XX_EXP_CS0
#define IXP425_EXP_CS1      			IXP4XX_EXP_CS1
#define IXP425_EXP_CS2      			IXP4XX_EXP_CS2 
#define IXP425_EXP_CS3      			IXP4XX_EXP_CS3
#define IXP425_EXP_CS4      			IXP4XX_EXP_CS4
#define IXP425_EXP_CS5      			IXP4XX_EXP_CS5
#define IXP425_EXP_CS6      			IXP4XX_EXP_CS6     
#define IXP425_EXP_CS7      			IXP4XX_EXP_CS7

#define IXP425_EXP_CFG0     			IXP4XX_EXP_CFG0 
#define IXP425_EXP_CFG1     			IXP4XX_EXP_CFG1 
 
#define IXP425_CONSOLE_UART_BASE_VIRT 	IXP4XX_UART1_BASE_VIRT
#define IXP425_CONSOLE_UART_BASE_PHYS 	IXP4XX_UART1_BASE_PHYS
/*
 * Peripheral Space Registers 
 */
#define IXP425_UART1_BASE_PHYS			IXP4XX_UART1_BASE_PHYS
#define IXP425_UART2_BASE_PHYS			IXP4XX_UART2_BASE_PHYS
#define IXP425_PMU_BASE_PHYS			IXP4XX_PMU_BASE_PHYS
#define IXP425_INTC_BASE_PHYS			IXP4XX_INTC_BASE_PHYS
#define IXP425_GPIO_BASE_PHYS			IXP4XX_GPIO_BASE_PHYS
#define IXP425_TIMER_BASE_PHYS			IXP4XX_TIMER_BASE_PHYS
#define IXP425_NPEA_BASE_PHYS			IXP4XX_NPEA_BASE_PHYS
#define IXP425_NPEB_BASE_PHYS			IXP4XX_NPEB_BASE_PHYS
#define IXP425_NPEC_BASE_PHYS			IXP4XX_NPEC_BASE_PHYS
#define IXP425_EthA_BASE_PHYS			IXP4XX_EthB0_BASE_PHYS
#define IXP425_EthB_BASE_PHYS			IXP4XX_EthC_BASE_PHYS
#define IXP425_USB_BASE_PHYS			IXP4XX_USB_BASE_PHYS

#define IXP425_UART1_BASE_VIRT			IXP4XX_UART1_BASE_VIRT
#define IXP425_UART2_BASE_VIRT			IXP4XX_UART2_BASE_VIRT
#define IXP425_PMU_BASE_VIRT			IXP4XX_PMU_BASE_VIRT
#define IXP425_INTC_BASE_VIRT			IXP4XX_INTC_BASE_VIRT
#define IXP425_GPIO_BASE_VIRT			IXP4XX_GPIO_BASE_VIRT
#define IXP425_TIMER_BASE_VIRT			IXP4XX_TIMER_BASE_VIRT
#define IXP425_NPEA_BASE_VIRT			IXP4XX_NPEA_BASE_VIRT
#define IXP425_NPEB_BASE_VIRT			IXP4XX_NPEB_BASE_VIRT
#define IXP425_NPEC_BASE_VIRT			IXP4XX_NPEC_BASE_VIRT
#define IXP425_EthA_BASE_VIRT			IXP4XX_EthB0_BASE_VIRT
#define IXP425_EthB_BASE_VIRT			IXP4XX_EthC_BASE_VIRT
#define IXP425_USB_BASE_VIRT			IXP4XX_USB_BASE_VIRT


/* 
 * UART Register Definitions , Offsets only as there are 2 UARTS.
 *   IXP425_UART1_BASE , IXP425_UART2_BASE.
 */

#define IXP425_UART_XTAL        		IXP4XX_UART_XTAL

/*
 * Constants to make it easy to access  Interrupt Controller registers
 */
#define IXP425_ICPR_OFFSET				IXP4XX_INTC_ST_OFFSET 	/* Interrupt Status */
#define IXP425_ICMR_OFFSET				IXP4XX_INTC_EN_OFFSET 	/* Interrupt Enable */
#define IXP425_ICLR_OFFSET				IXP4XX_INTC_SEL_OFFSET 	/* Interrupt IRQ/FIQ Select */
#define IXP425_ICIP_OFFSET  			IXP4XX_INTC_IST_OFFSET 	/* IRQ Status */
#define IXP425_ICFP_OFFSET				IXP4XX_INTC_FST_OFFSET 	/* FIQ Status */
#define IXP425_ICHR_OFFSET				IXP4XX_INTC_PRI_OFFSET 	/* Interrupt Priority */
#define IXP425_ICIH_OFFSET				IXP4XX_INTC_IPRI_OFFSET /* IRQ Highest Pri Int */
#define IXP425_ICFH_OFFSET				IXP4XX_INTC_FPRI_OFFSET	/* FIQ Highest Pri Int */

/*
 * Interrupt Controller Register Definitions.
 */
#define IXP425_INTC_REG(x) 				IXP4XX_INTC_REG(x)

#define IXP425_ICPR     				IXP4XX_INTC_ST		
#define IXP425_ICMR     				IXP4XX_INTC_EN		
#define IXP425_ICLR     				IXP4XX_INTC_SEL		
#define IXP425_ICIP     				IXP4XX_INTC_IST		
#define IXP425_ICFP     				IXP4XX_INTC_FST		
#define IXP425_ICHR     				IXP4XX_INTC_PRI		
#define IXP425_ICIH     				IXP4XX_INTC_IPRI	 
#define IXP425_ICFH     				IXP4XX_INTC_FPRI	
                                                                                
/*
 * Constants to make it easy to access GPIO registers
 */
#define IXP425_GPIO_GPOUTR_OFFSET       IXP4XX_GPIO_GPOUTR_OFFSET
#define IXP425_GPIO_GPOER_OFFSET        IXP4XX_GPIO_GPOER_OFFSET
#define IXP425_GPIO_GPINR_OFFSET        IXP4XX_GPIO_GPINR_OFFSET
#define IXP425_GPIO_GPISR_OFFSET        IXP4XX_GPIO_GPISR_OFFSET
#define IXP425_GPIO_GPIT1R_OFFSET		IXP4XX_GPIO_GPIT1R_OFFSET
#define IXP425_GPIO_GPIT2R_OFFSET		IXP4XX_GPIO_GPIT2R_OFFSET
#define IXP425_GPIO_GPCLKR_OFFSET		IXP4XX_GPIO_GPCLKR_OFFSET
#define IXP425_GPIO_GPDBSELR_OFFSET		IXP4XX_GPIO_GPDBSELR_OFFSET

/* 
 * GPIO Register Definitions.
 * [Only perform 32bit reads/writes]
 */
#define IXP425_GPIO_REG(x) 				IXP4XX_GPIO_REG(x)

#define IXP425_GPIO_GPOUTR				IXP4XX_GPIO_GPOUTR
#define IXP425_GPIO_GPOER       		IXP4XX_GPIO_GPOER
#define IXP425_GPIO_GPINR       		IXP4XX_GPIO_GPINR
#define IXP425_GPIO_GPISR       		IXP4XX_GPIO_GPISR
#define IXP425_GPIO_GPIT1R      		IXP4XX_GPIO_GPIT1R
#define IXP425_GPIO_GPIT2R      		IXP4XX_GPIO_GPIT2R
#define IXP425_GPIO_GPCLKR      		IXP4XX_GPIO_GPCLKR
#define IXP425_GPIO_GPDBSELR    		IXP4XX_GPIO_GPDBSELR

/*
 * Constants to make it easy to access Timer Control/Status registers
 */
#define IXP425_OSTS_OFFSET				IXP4XX_OSTS_OFFSET  /* Continious TimeStamp */
#define IXP425_OST1_OFFSET				IXP4XX_OST1_OFFSET  /* Timer 1 Timestamp */
#define IXP425_OSRT1_OFFSET				IXP4XX_OSRT1_OFFSET /* Timer 1 Reload */
#define IXP425_OST2_OFFSET				IXP4XX_OST2_OFFSET  /* Timer 2 Timestamp */
#define IXP425_OSRT2_OFFSET				IXP4XX_OSRT2_OFFSET /* Timer 2 Reload */
#define IXP425_OSWT_OFFSET				IXP4XX_OSWT_OFFSET  /* Watchdog Timer */
#define IXP425_OSWE_OFFSET				IXP4XX_OSWE_OFFSET  /* Watchdog Enable */
#define IXP425_OSWK_OFFSET				IXP4XX_OSWK_OFFSET  /* Watchdog Key */
#define IXP425_OSST_OFFSET				IXP4XX_OSST_OFFSET  /* Timer Status */

/*
 * Operating System Timer Register Definitions.
 */

#define IXP425_TIMER_REG(x) 			IXP4XX_TIMER_REG(x)

#define IXP425_OSTS						IXP4XX_OSTS
#define IXP425_OST1						IXP4XX_OST1
#define IXP425_OSRT1					IXP4XX_OSRT1
#define IXP425_OST2						IXP4XX_OST2
#define IXP425_OSRT2					IXP4XX_OSRT2
#define IXP425_OSWT						IXP4XX_OSWT
#define IXP425_OSWE						IXP4XX_OSWE
#define IXP425_OSWK						IXP4XX_OSWK
#define IXP425_OSST						IXP4XX_OSST

/*
 * Timer register values and bit definitions 
 */
#define IXP425_OST_ENABLE              IXP4XX_OST_ENABLE
#define IXP425_OST_ONE_SHOT            IXP4XX_OST_ONE_SHOT
/* Low order bits of reload value ignored */
#define IXP425_OST_RELOAD_MASK         IXP4XX_OST_RELOAD_MASK    
#define IXP425_OST_DISABLED            IXP4XX_OST_DISABLED
#define IXP425_OSST_TIMER_1_PEND       IXP4XX_OSST_TIMER_1_PEND
#define IXP425_OSST_TIMER_2_PEND       IXP4XX_OSST_TIMER_2_PEND
#define IXP425_OSST_TIMER_TS_PEND      IXP4XX_OSST_TIMER_TS_PEND
#define IXP425_OSST_TIMER_WDOG_PEND    IXP4XX_OSST_TIMER_WDOG_PEND
#define IXP425_OSST_TIMER_WARM_RESET   IXP4XX_OSST_TIMER_WARM_RESET


/*
 * PCI Control/Status Registers
 */
#define IXP425_PCI_CSR(x) 				IXP4XX_PCI_CSR(x)

/*
 * Shift value for byte enable on NP cmd/byte enable register
 */
#define IXP425_PCI_NP_CBE_BESL			IXP4XX_PCI_NP_CBE_BESL

/*
 * Clock Speed Definitions.
 */
#define IXP425_PERIPHERAL_BUS_CLOCK 	IXP4XX_PERIPHERAL_BUS_CLOCK /* 66Mhzi APB BUS   */ 

#endif
