/*
 * include/asm-arm/arch-ixp425/irqs.h
 *
 * IRQ definitions for IXP4xx based systems
 *
 * Copyright (C) 2004 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef _ARCH_IXP425_IRQS_H_
#define _ARCH_IXP425_IRQS_H_

#define NR_IRQS_LOWER			32		/* 42x has only  32 irqs (32 total)	*/
#define NR_IRQS					64		/* 46x has extra 32 irqs (64 total) */

/* 4xx IRQs */
#define IRQ_IXP4XX_NPEA			0
#define IRQ_IXP4XX_NPEB			1
#define IRQ_IXP4XX_NPEC			2
#define IRQ_IXP4XX_QM1			3
#define IRQ_IXP4XX_QM2			4
#define IRQ_IXP4XX_TIMER1		5
#define IRQ_IXP4XX_GPIO0		6
#define IRQ_IXP4XX_GPIO1		7
#define IRQ_IXP4XX_PCI_INT		8
#define IRQ_IXP4XX_PCI_DMA1		9
#define IRQ_IXP4XX_PCI_DMA2		10
#define IRQ_IXP4XX_TIMER2		11
#define IRQ_IXP4XX_USB			12
#define IRQ_IXP4XX_UART2		13
#define IRQ_IXP4XX_TIMESTAMP	14
#define IRQ_IXP4XX_UART1		15
#define IRQ_IXP4XX_WDOG			16
#define IRQ_IXP4XX_AHB_PMU		17
#define IRQ_IXP4XX_XSCALE_PMU	18
#define IRQ_IXP4XX_GPIO2		19
#define IRQ_IXP4XX_GPIO3		20
#define IRQ_IXP4XX_GPIO4		21
#define IRQ_IXP4XX_GPIO5		22
#define IRQ_IXP4XX_GPIO6		23
#define IRQ_IXP4XX_GPIO7		24
#define IRQ_IXP4XX_GPIO8		25
#define IRQ_IXP4XX_GPIO9		26
#define IRQ_IXP4XX_GPIO10		27
#define IRQ_IXP4XX_GPIO11		28
#define IRQ_IXP4XX_GPIO12		29
#define IRQ_IXP4XX_SW_INT1		30
#define IRQ_IXP4XX_SW_INT2		31

/* 46x extended IRQs */
#define IRQ_IXP4XX_USB_HOST		32
#define IRQ_IXP4XX_I2C			33
#define IRQ_IXP4XX_SSP			34
#define IRQ_IXP4XX_TSYNC		35
#define IRQ_IXP4XX_EAU_DONE		36
#define IRQ_IXP4XX_SHA_DONE		37
#define IRQ_IXP4XX_RESERVED_38	38
#define IRQ_IXP4XX_RESERVED_39	39
#define IRQ_IXP4XX_RESERVED_40	40
#define IRQ_IXP4XX_RESERVED_41	41
#define IRQ_IXP4XX_RESERVED_42	42
#define IRQ_IXP4XX_RESERVED_43	43
#define IRQ_IXP4XX_RESERVED_44	44
#define IRQ_IXP4XX_RESERVED_45	45
#define IRQ_IXP4XX_RESERVED_46	46
#define IRQ_IXP4XX_RESERVED_47	47
#define IRQ_IXP4XX_RESERVED_48	48
#define IRQ_IXP4XX_RESERVED_49	49
#define IRQ_IXP4XX_RESERVED_50	50
#define IRQ_IXP4XX_RESERVED_51	51
#define IRQ_IXP4XX_RESERVED_52	52
#define IRQ_IXP4XX_RESERVED_53	53
#define IRQ_IXP4XX_RESERVED_54	54
#define IRQ_IXP4XX_RESERVED_55	55
#define IRQ_IXP4XX_RESERVED_56	56
#define IRQ_IXP4XX_RESERVED_57	57
#define IRQ_IXP4XX_SWCP_PE		58
#define IRQ_IXP4XX_RESERVED_59	59
#define IRQ_IXP4XX_QM_PE		60
#define IRQ_IXP4XX_MCU_ECC		61
#define IRQ_IXP4XX_EXP_PE		62
#define IRQ_IXP4XX_RESERVED_63	63

#define XSCALE_PMU_IRQ			(IRQ_IXP4XX_XSCALE_PMU)

/*
 * IXDP4xx Board IRQs
 */
#define IRQ_IXDP425_PCI_INTA	IRQ_IXP4XX_GPIO11
#define IRQ_IXDP425_PCI_INTB	IRQ_IXP4XX_GPIO10
#define IRQ_IXDP425_PCI_INTC	IRQ_IXP4XX_GPIO9
#define IRQ_IXDP425_PCI_INTD	IRQ_IXP4XX_GPIO8

/*
 * PrPMC1100 Board IRQs
 */
#define IRQ_PRPMC1100_PCI_INTA	IRQ_IXP4XX_GPIO11
#define IRQ_PRPMC1100_PCI_INTB	IRQ_IXP4XX_GPIO10
#define IRQ_PRPMC1100_PCI_INTC	IRQ_IXP4XX_GPIO9
#define IRQ_PRPMC1100_PCI_INTD	IRQ_IXP4XX_GPIO8

/*
 * Coyote/Coyote II IRQs
 */
#define IRQ_COYOTE_PCI_INTA		IRQ_IXP4XX_GPIO11
#define IRQ_COYOTE_PCI_INTB		IRQ_IXP4XX_GPIO6

/* Added for backwards compatability */
#define IRQ_IXP425_NPEA			IRQ_IXP4XX_NPEA
#define IRQ_IXP425_NPEB			IRQ_IXP4XX_NPEB
#define IRQ_IXP425_NPEC			IRQ_IXP4XX_NPEC
#define IRQ_IXP425_QM1			IRQ_IXP4XX_QM1
#define IRQ_IXP425_QM2			IRQ_IXP4XX_QM2
#define IRQ_IXP425_TIMER1		IRQ_IXP4XX_TIMER1
#define IRQ_IXP425_TIMER2		IRQ_IXP4XX_TIMER2
#define IRQ_IXP425_USB			IRQ_IXP4XX_USB
#define IRQ_IXP425_UART2		IRQ_IXP4XX_UART2	
#define IRQ_IXP425_TIMESTAMP	IRQ_IXP4XX_TIMESTAMP
#define IRQ_IXP425_UART1		IRQ_IXP4XX_UART1	
#define IRQ_IXP425_WDOG			IRQ_IXP4XX_WDOG
#define IRQ_IXP425_AHB_PMU		IRQ_IXP4XX_AHB_PMU
#define IRQ_IXP425_XSCALE_PMU	IRQ_IXP4XX_XSCALE_PMU

#endif


