/*
 * linux/include/asm-arm/arch-ixp2400/system.h
 *
 * Copyright (C) 2002 Intel Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <asm/hardware.h>
#include <asm/mach-types.h>

static inline void arch_idle(void)
{
#if 0
	while (!current->need_resched && !hlt_counter) {
		cpu_do_idle(IDLE_CLOCK_SLOW);
		cpu_do_idle(IDLE_WAIT_FAST);
		cpu_do_idle(IDLE_CLOCK_FAST);
	}
#endif
}


static inline void arch_reset(char mode)
{
    cli();
    
	if (machine_is_ixdp2401()) {
        /* reset flash bank pointers */
        *IXDP2401_CPLD_FLASH_REG = ((0 >> IXDP2401_FLASH_WINDOW_BITS) |
			       	IXDP2401_CPLD_FLASH_INTERN);
		*IXDP2401_CPLD_RESET_REG = 0xffffffff;
	} else if (machine_is_ixdp2801()) {
        /*
         * This magic sequence written to CPLD reset register invokes
         * the reset of the whole IXDP2xxx board, including XScale processor
         * and all the external devices.
         * It will also reset the flash bank pointers and set bank #0 as active.
         */
        unsigned long i;

        i = *IXDP2801_CPLD_RESET_REG;
        i = 0x55AA0000 | (i & 0x0000FFFF);
        *IXDP2801_CPLD_RESET_REG = i;
        *IXDP2801_CPLD_RESET_REG;
        *IXDP2801_CPLD_RESET_REG = 0x80000000;
        *IXDP2801_CPLD_RESET_REG;
    }
           
    /* Use on-chip reset capability. */
    if (*IXP2000_STRAP_OPTIONS & CFG_PCI_BOOT_HOST) {
        *(IXP2000_RESET0) |= (RSTALL);
        udelay(1000);
    }
}




