/*
 * include/asm-arm/arch-ixp2000/ixdp2401.h
 *
 * Register and other defines for IXDP2401
 *
 * Based on: include/asm-arm/arch-ixp2000/ixdp2400.h, by Naeem Afzal <naeem.m.afzal@intel.com>
 *
 * Copyright (c) 2002-2003 Intel Corp.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 * Changelog:
 *  24-Mar-2003: Andrzej Mialkowski <andrzej.mialkowski@intel.com>
 *     - Adopted from IXDP2400, updated to reflect IXDP2401 memory map
 *  23-Sep-2004: Krzysztof Czurylo <krzysztof.czurylo@intel.com>
 *     - I2C defines for IXDP2401
 */

#ifndef _IXDP2401_H_
#define _IXDP2401_H_


/*
 * On board CPLD memory map
 */
#define IXDP2401_PHY_SP_BASE	0xc6000000
#define IXDP2401_VIRT_SP_BASE	0xd4000000
#define IXDP2401_SP_SIZE	0x01000000

#define IXDP2401_VIRT_NVRAM_BASE	(IXDP2401_VIRT_SP_BASE + 0x000000)
#define IXDP2401_VIRT_MB_IXF1104_BASE	(IXDP2401_VIRT_SP_BASE + 0x020000)
#define IXDP2401_VIRT_CPLD_BASE		(IXDP2401_VIRT_SP_BASE + 0x024000)
#define IXDP2401_VIRT_ADD_UART_BASE	(IXDP2401_VIRT_SP_BASE + 0x024040)
#define IXDP2401_VIRT_SAUS_UART_BASE	(IXDP2401_VIRT_SP_BASE + 0x024060)
#define IXDP2401_VIRT_CS8900_BASE	(IXDP2401_VIRT_SP_BASE + 0x024080)
#define IXDP2401_VIRT_FIC_BASE		(IXDP2401_VIRT_SP_BASE + 0x200000)
#define IXDP2401_VIRT_DB0_BASE		(IXDP2401_VIRT_SP_BASE + 0x400000)
#define IXDP2401_VIRT_DB1_BASE		(IXDP2401_VIRT_SP_BASE + 0x600000)

#define IXDP2401_CPLD_REG(reg) (volatile unsigned long *)(IXDP2401_VIRT_CPLD_BASE | reg)

#define IXDP2401_CPLD_RESET_REG		IXDP2401_CPLD_REG(0x00)
#define IXDP2401_CPLD_CLOCK_REG		IXDP2401_CPLD_REG(0x04)
#define IXDP2401_CPLD_INT_MASK_SET_REG	IXDP2401_CPLD_REG(0x08)
#define IXDP2401_CPLD_INT_STAT_REG	IXDP2401_CPLD_REG(0x0C)
#define IXDP2401_CPLD_INT_RAW_REG	IXDP2401_CPLD_REG(0x10)	 /* read */
#define IXDP2401_CPLD_INT_MASK_CLR_REG	IXDP2401_CPLD_INT_RAW_REG /* write */
#define IXDP2401_CPLD_INT_SIM_REG	IXDP2401_CPLD_REG(0x14)
	/* Interrupt bits are defined in irqs.h */
#define IXDP2401_CPLD_GBE_REG		IXDP2401_CPLD_REG(0x18)
#define IXDP2401_CPLD_MISC_REG		IXDP2401_CPLD_REG(0x1C)
	#define IXDP2401_CPLD_MISC_REV_MASK 0xFF
#define IXDP2401_CPLD_FLASH_REG		IXDP2401_CPLD_REG(0x20)
	#define IXDP2401_CPLD_FLASH_INTERN 0x8000
	#define IXDP2401_CPLD_FLASH_BANK_MASK 0xF
#define IXDP2401_CPLD_GDXCS0_REG	IXDP2401_CPLD_REG(0x24)
#define IXDP2401_CPLD_GDXCS1_REG	IXDP2401_CPLD_REG(0x28)

#define IXDP2401_FLASH_WINDOW_BITS 25
#define IXDP2401_FLASH_WINDOW_SIZE (1 << IXDP2401_FLASH_WINDOW_BITS)
#define IXDP2401_FLASH_WINDOW_MASK (IXDP2401_FLASH_WINDOW_SIZE - 1)

/*
 * I2C defines
 */
#define	IXDP2401_GPIO_SCL		0x07
#define	IXDP2401_GPIO_SDA		0x06

#ifndef __ASSEMBLY__
static inline unsigned long ixdp2401_set_flash_bank(unsigned long ofs)
{
	*IXDP2401_CPLD_FLASH_REG =
	    ((ofs >> IXDP2401_FLASH_WINDOW_BITS) |
	     IXDP2401_CPLD_FLASH_INTERN);
	return (ofs & IXDP2401_FLASH_WINDOW_MASK);
}

static inline unsigned long ixdp2401_get_flash_banks(void)
{
	*IXDP2401_CPLD_FLASH_REG =
	    (IXDP2401_CPLD_FLASH_BANK_MASK | IXDP2401_CPLD_FLASH_INTERN);
	return ((*IXDP2401_CPLD_FLASH_REG & IXDP2401_CPLD_FLASH_BANK_MASK)
		+ 1);
}
#endif

#endif /*_IXDP2401_H_ */


